/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.Harvestable;
import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.StatsWorks;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ErrorHarvestableImpl
implements Harvestable {
    private ErrorServiceImpl errorService;
    private String appName;
    private long lastHarvest;

    ErrorHarvestableImpl(ErrorServiceImpl errorService, String appName) {
        this.errorService = errorService;
        this.appName = appName;
        this.lastHarvest = System.nanoTime();
    }

    @Override
    public String getEndpointMethodName() {
        return "error_event_data";
    }

    @Override
    public void harvest() {
        this.recordIntervalMetric();
        this.errorService.harvestEvents(this.appName);
        this.errorService.harvestTracedErrors(this.appName);
    }

    private void recordIntervalMetric() {
        long startTimeInNanos = System.nanoTime();
        final long harvestIntervalInNanos = startTimeInNanos - this.lastHarvest;
        this.lastHarvest = startTimeInNanos;
        ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

            @Override
            public void doWork(StatsEngine statsEngine) {
                if (harvestIntervalInNanos > 0L) {
                    statsEngine.getResponseTimeStats("Supportability/EventHarvest/TransactionError/interval").recordResponseTime(harvestIntervalInNanos, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public String getAppName() {
                return ErrorHarvestableImpl.this.appName;
            }
        });
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        Number maxSamplesCollector = (Number)configuration.get("max_samples_stored");
        int maxSamples = maxSamplesCollector != null ? Math.min(maxSamplesCollector.intValue(), this.errorService.getErrorCollectorConfig().getMaxEventsStored()) : this.errorService.getErrorCollectorConfig().getMaxEventsStored();
        Number reportPeriod = (Number)configuration.get("report_period_in_seconds");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Events/TransactionError/ReportPeriod", reportPeriod.longValue()));
        int maxEventsStored = this.errorService.maxEventsStored;
        if (maxSamples != maxEventsStored) {
            this.errorService.setMaxEventsStored(maxSamples);
            this.errorService.harvestEvents(this.appName);
            this.errorService.clearReservoir();
        }
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

