/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.graph.ClassMethodSig;
import com.newrelic.agent.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class CallGraph
implements Graph {
    private final Set<String> ignoreExactName = Sets.newHashSet("toString", "equals", "hashCode", "clone", "<init>", "<clinit>");
    private final ConcurrentMap<ClassMethodSig, Set<ClassMethodSig>> graph = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Cache<ClassLoader, ClassLoader>> classloaders = Maps.newConcurrentMap();

    @Override
    public void addSource(ClassMethodSig source) {
        if (this.shouldIgnore(source.getMethodName())) {
            Agent.LOG.log(Level.FINEST, "ignoring source: {0}", source);
            return;
        }
        this.createSource(source);
    }

    @Override
    public void addSourceAndDestination(ClassMethodSig source, ClassMethodSig destination) {
        if (this.shouldIgnore(source.getMethodName()) || this.graph.get(source) != null && ((Set)this.graph.get(source)).contains(destination)) {
            Agent.LOG.log(Level.FINEST, "ignoring destination: {0} to source: {1}", destination, source);
            return;
        }
        this.createSource(source).add(destination);
        Agent.LOG.log(Level.FINEST, "added destination: {0}, to source: {1}", destination, source);
    }

    private Set<ClassMethodSig> createSource(ClassMethodSig source) {
        Set<ClassMethodSig> set = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<ClassMethodSig> result = this.graph.putIfAbsent(source, set);
        if (result == null) {
            Agent.LOG.log(Level.FINEST, "added source: {0}", source);
            return set;
        }
        return result;
    }

    private boolean shouldIgnore(String methodName) {
        return this.ignoreExactName.contains(methodName);
    }

    public Set<ClassMethodSig> getCallers() {
        return this.graph.keySet();
    }

    @Override
    public void addClassLoaderEntry(String name, ClassLoader loader) {
        Cache newLoaders = CacheBuilder.newBuilder().weakKeys().weakValues().build();
        Cache existingLoaders = this.classloaders.putIfAbsent(name, newLoaders);
        if (existingLoaders != null) {
            existingLoaders.put(loader, loader);
        } else {
            newLoaders.put(loader, loader);
        }
    }

    @Override
    public Collection<ClassMethodSig> getMethodsCalledBy(ClassMethodSig source) {
        Agent.LOG.log(Level.FINEST, "get methods on source: {0}", source);
        Set classMethodSigs = (Set)this.graph.get(source);
        return classMethodSigs == null ? Collections.emptySet() : classMethodSigs;
    }

    @Override
    public Collection<ClassMethodSig> getTransactionStartPoints() {
        Set sources = this.graph.keySet();
        HashSet destinations = Sets.newHashSet();
        for (Set list : this.graph.values()) {
            destinations.addAll(list);
        }
        Sets.SetView<ClassMethodSig> transactionStartPoints = Sets.difference(sources, destinations);
        for (ClassMethodSig cms : transactionStartPoints) {
            cms.setTransactionStartPoint(true);
        }
        return transactionStartPoints;
    }

    public void filterRemovedPackages(String packageName) {
        Iterator i = this.graph.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (((ClassMethodSig)entry.getKey()).getClassName().startsWith(packageName)) {
                i.remove();
                continue;
            }
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                ClassMethodSig cms = (ClassMethodSig)iterator.next();
                if (!cms.getClassName().startsWith(packageName)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public Set<Class<?>> reloadClassInClassloaders(ClassMethodSig cms) {
        Cache loaderReferences = (Cache)this.classloaders.get(cms.getClassName());
        if (loaderReferences == null || loaderReferences.asMap().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet classes = new HashSet();
        for (ClassLoader loaderReference : loaderReferences.asMap().values()) {
            if (loaderReference == null) continue;
            try {
                classes.add(loaderReference.loadClass(cms.getClassNameWithDots()));
            }
            catch (ClassNotFoundException e) {
                Agent.LOG.log(Level.FINEST, e, "Could not load class {0}", cms.getClassNameWithDots());
            }
        }
        return classes;
    }
}

