/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import java.util.Collection;

public class ClassNode {
    private final String className;
    private boolean isInterface;
    private final Collection<String> subClasses;

    public ClassNode(String className, boolean isInterface, Collection<String> subClasses) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        this.className = className;
        this.isInterface = isInterface;
        this.subClasses = subClasses;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassNode classNode = (ClassNode)o;
        return this.className.equals(classNode.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public void addSubClass(String subClass) {
        this.subClasses.add(subClass);
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public Collection<String> getSubClasses() {
        return this.subClasses;
    }
}

