/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.graph.CallGraph;
import com.newrelic.agent.graph.ClassMethodSig;
import com.newrelic.agent.graph.ClassNode;
import com.newrelic.agent.graph.DiscoveryEngine;
import com.newrelic.agent.graph.Graph;
import com.newrelic.agent.graph.MethodState;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.reinstrument.Retransformer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class DiscoveryEngineImpl
implements DiscoveryEngine {
    private static final ConcurrentMap<String, Collection<Method>> classToTracedMethods = Maps.newConcurrentMap();
    private static final double CHAIN_THRESHOLD = 5.0;
    private volatile DiscoveryEngineState state;
    private Collection<MethodState> discoveredMethods = Sets.newConcurrentHashSet();
    private Collection<ClassMethodSignature> visitedMethods;
    private Retransformer retransformer;
    private Set<String> ignoreTransactionDiscoveryClassContains;
    private Set<String> ignoreTransactionDiscoveryMethodStartsWith;

    public DiscoveryEngineImpl(int threshold, Collection<String> packages, Collection<String> ignoreTransactionDiscoveryClassContains, Collection<String> ignoreTransactionDiscoveryMethodStartsWith, boolean transactionDiscoveryEnabled, Retransformer retransformer) {
        this.retransformer = retransformer;
        this.ignoreTransactionDiscoveryClassContains = new HashSet<String>();
        this.ignoreTransactionDiscoveryMethodStartsWith = new HashSet<String>();
        this.visitedMethods = Sets.newConcurrentHashSet();
        if (transactionDiscoveryEnabled) {
            this.ignoreTransactionDiscoveryClassContains.addAll(ignoreTransactionDiscoveryClassContains);
            this.ignoreTransactionDiscoveryMethodStartsWith.addAll(ignoreTransactionDiscoveryMethodStartsWith);
        }
        this.state = new DiscoveryEngineState(threshold, packages, transactionDiscoveryEnabled, null, null);
    }

    @Override
    public Collection<Method> getTracedMethods(String internalClassName) {
        Collection methods = (Collection)classToTracedMethods.get(internalClassName);
        return methods != null ? Sets.newHashSet(methods) : Collections.emptySet();
    }

    @Override
    public Collection<ClassMethodSig> discoverSlowestTrace(long totalTimeNs, Tracer rootTracer, Collection<Tracer> tracers) {
        float parentPercentDuration;
        ClassMethodSig classMethodSig;
        MethodState methodState;
        DiscoveryEngineState localState = this.state;
        if (totalTimeNs <= 0L) {
            return Collections.emptyList();
        }
        Tracer slowestTracer = this.findSlowestTracer(rootTracer, tracers);
        if (slowestTracer == null) {
            return Collections.emptyList();
        }
        float percentDuration = this.computePercentDuration(slowestTracer, totalTimeNs);
        if (percentDuration < (float)localState.threshold) {
            return Collections.emptyList();
        }
        Tracer parentTracer = slowestTracer.getParentTracer();
        if (parentTracer != null && this.discoveredMethods.contains(methodState = new MethodState(classMethodSig = new ClassMethodSig(parentTracer.getClassMethodSignature()), localState.threshold)) && (double)(parentPercentDuration = this.computePercentDuration(parentTracer, totalTimeNs)) < 5.0) {
            this.removeInstrumentation(classMethodSig, parentPercentDuration);
        }
        ClassMethodSig sig = new ClassMethodSig(slowestTracer.getClassMethodSignature());
        Collection<ClassMethodSig> children = localState.callGraph.getMethodsCalledBy(sig);
        ArrayList<ClassMethodSig> possibleInstrumentation = new ArrayList<ClassMethodSig>();
        for (ClassMethodSig child : children) {
            if (this.instrumented(child)) continue;
            possibleInstrumentation.add(child);
        }
        this.visitedMethods.add(slowestTracer.getClassMethodSignature());
        return this.queueRetransformNewTrace(possibleInstrumentation);
    }

    private Tracer findSlowestTracer(Tracer rootTracer, Collection<Tracer> tracers) {
        Tracer slowestTracer = this.visitedMethods.contains(rootTracer.getClassMethodSignature()) ? null : rootTracer;
        for (Tracer tracer : tracers) {
            if (slowestTracer == null) {
                slowestTracer = this.visitedMethods.contains(tracer.getClassMethodSignature()) ? null : tracer;
                continue;
            }
            if (slowestTracer.getExclusiveDuration() >= tracer.getExclusiveDuration() || this.visitedMethods.contains(tracer.getClassMethodSignature())) continue;
            slowestTracer = tracer;
        }
        return slowestTracer;
    }

    @Override
    public Collection<ClassMethodSig> getFilteredTransactionStartPoints() {
        ConcurrentMap<String, ClassNode> classHierarchyGraph = this.getClassHierarchyGraph();
        Collection<ClassMethodSig> allTransactionStartPoints = this.getCallGraph().getTransactionStartPoints();
        Collection<ClassMethodSig> nonLeafNodeTransactionStartPoints = this.filterOutLeafNodes(allTransactionStartPoints);
        Set sources = classHierarchyGraph.keySet();
        HashSet<String> destinations = Sets.newHashSet();
        for (ClassNode clazz : classHierarchyGraph.values()) {
            destinations.addAll(clazz.getSubClasses());
        }
        HashSet classTransactionStartPoints = Sets.newHashSet();
        classTransactionStartPoints.addAll(Sets.difference(sources, destinations));
        HashSet<ClassMethodSig> filteredTransactionStartPoints = Sets.newHashSet();
        for (ClassMethodSig filteredTransactionStartPoint : nonLeafNodeTransactionStartPoints) {
            if (!classTransactionStartPoints.contains(filteredTransactionStartPoint.getClassName()) || this.shouldIgnore(filteredTransactionStartPoint.getMethodName(), filteredTransactionStartPoint.getClassName())) continue;
            filteredTransactionStartPoints.add(filteredTransactionStartPoint);
        }
        return filteredTransactionStartPoints;
    }

    private boolean instrumented(ClassMethodSig child) {
        Collection tracedMethods = (Collection)classToTracedMethods.get(child.getClassName());
        return tracedMethods != null && tracedMethods.contains(new Method(child.getMethodName(), child.getMethodDesc()));
    }

    private float computePercentDuration(Tracer tracer, long totalTimeNs) {
        return 100.0f * (float)tracer.getExclusiveDuration() / (float)totalTimeNs;
    }

    @Override
    public Collection<MethodState> getDiscoveredMethods() {
        return this.discoveredMethods;
    }

    public Collection<String> getConfiguredPackages() {
        return this.state.packages;
    }

    private static Collection<String> fixSeparators(Collection<String> packages, String replace, String with) {
        ArrayList<String> result = new ArrayList<String>(packages.size());
        for (String s : packages) {
            result.add(s.replaceAll(replace, with));
        }
        return result;
    }

    @Override
    public void initialize(int threshold, Collection<String> packages, boolean findTransactionStartPoints) {
        Agent.LOG.log(Level.FINEST, "Initializing discovery engine");
        this.state = new DiscoveryEngineState(threshold, packages, findTransactionStartPoints, null, null);
        this.retransformMatchingPackageClasses(packages);
    }

    @Override
    public void setState(int threshold, Collection<String> packages, boolean findTransactionStartPoints) {
        Agent.LOG.log(Level.FINEST, "Setting state for discovery engine");
        DiscoveryEngineState oldState = this.state;
        List<Set<String>> removedAndAddedPackages = this.getRemovedAndAddedPackages(oldState.packages, packages);
        Set<String> removedPackages = removedAndAddedPackages.get(0);
        Set<String> addedPackages = removedAndAddedPackages.get(1);
        CallGraph newGraph = (CallGraph)oldState.callGraph;
        ConcurrentMap<String, ClassNode> newClassHierarchy = oldState.classHierarchy;
        for (String s : removedPackages) {
            newGraph.filterRemovedPackages(s);
            this.removeClassesFromClassHierarchyGraph(newClassHierarchy, s);
        }
        if (oldState.threshold != threshold && oldState.packageEquals(packages) && oldState.findTransactionStartPoints == findTransactionStartPoints) {
            this.state = new DiscoveryEngineState(threshold, packages, findTransactionStartPoints, (CallGraph)oldState.callGraph, oldState.classHierarchy);
            this.visitedMethods.clear();
            return;
        }
        this.state = new DiscoveryEngineState(threshold, packages, findTransactionStartPoints, newGraph, newClassHierarchy);
        this.retransformMatchingPackageClasses(packages);
        this.visitedMethods.clear();
    }

    private void retransformMatchingPackageClasses(Collection<String> packages) {
        if (packages.isEmpty()) {
            return;
        }
        Class[] allLoadedClasses = ServiceFactory.getAgent().getInstrumentation().getAllLoadedClasses();
        HashSet<ClassMatchVisitorFactory> matchers = new HashSet<ClassMatchVisitorFactory>(2);
        matchers.add(new DiscoverableClassScanner(packages));
        ServiceFactory.getClassTransformerService().retransformMatchingClassesImmediately(allLoadedClasses, matchers);
    }

    private void removeClassesFromClassHierarchyGraph(ConcurrentMap<String, ClassNode> newClassHierarchy, String packageName) {
        Iterator i = newClassHierarchy.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            if (((String)next.getKey()).startsWith(packageName)) {
                i.remove();
                continue;
            }
            ClassNode node = (ClassNode)next.getValue();
            Collection<String> subClasses = node.getSubClasses();
            Iterator<String> j = subClasses.iterator();
            while (j.hasNext()) {
                String subClass = j.next();
                if (!subClass.startsWith(packageName)) continue;
                j.remove();
            }
        }
    }

    @Override
    public Graph getCallGraph() {
        return this.state.callGraph;
    }

    @Override
    public int getThreshold() {
        return this.state.threshold;
    }

    @Override
    public boolean inPackages(String className) {
        for (String prefix : this.getConfiguredPackages()) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConcurrentMap<String, ClassNode> getClassHierarchyGraph() {
        return this.state.classHierarchy;
    }

    private Collection<ClassMethodSig> queueRetransformNewTrace(Collection<ClassMethodSig> newInstrumentation) {
        if (newInstrumentation.isEmpty()) {
            return Collections.emptyList();
        }
        DiscoveryEngineState localState = this.state;
        HashSet<Class<?>> classesToRetransform = Sets.newHashSet();
        HashSet<ClassMethodSig> result = Sets.newHashSet();
        for (ClassMethodSig cms : newInstrumentation) {
            Set<Class<?>> classes;
            boolean retransformThisClass = true;
            ClassNode classNode = (ClassNode)localState.classHierarchy.get(cms.getClassName());
            if (classNode != null) {
                Collection<String> subClasses = classNode.getSubClasses();
                if (!subClasses.isEmpty()) {
                    ArrayList<ClassMethodSig> converted = new ArrayList<ClassMethodSig>();
                    for (String clazz : subClasses) {
                        ClassMethodSig newCms = new ClassMethodSig(clazz, cms.getMethodName(), cms.getMethodDesc());
                        converted.add(newCms);
                    }
                    result.addAll(this.queueRetransformNewTrace(converted));
                }
                if (((ClassNode)localState.classHierarchy.get(cms.getClassName())).isInterface()) {
                    retransformThisClass = false;
                }
            }
            if (!retransformThisClass) continue;
            Method method = new Method(cms.getMethodName(), cms.getMethodDesc());
            Set<Method> methods = Sets.newConcurrentHashSet();
            methods.add(method);
            Collection existing = classToTracedMethods.putIfAbsent(cms.getClassName(), methods);
            if (existing != null) {
                existing.addAll(methods);
            }
            if (!(classes = localState.callGraph.reloadClassInClassloaders(cms)).isEmpty()) {
                classesToRetransform.addAll(classes);
                this.discoveredMethods.add(new MethodState(cms, localState.threshold));
            }
            result.add(cms);
            Agent.LOG.log(Level.FINER, "Segment discovery found method to trace: {0}", cms);
        }
        if (!classesToRetransform.isEmpty()) {
            this.queueForRetransform(classesToRetransform);
        }
        return result;
    }

    @VisibleForTesting
    public void setRetransformer(Retransformer retransformer) {
        this.retransformer = retransformer;
    }

    @VisibleForTesting
    public void clearDiscoveredMethods() {
        this.discoveredMethods.clear();
    }

    @VisibleForTesting
    public void clearTracedMethods() {
        classToTracedMethods.clear();
    }

    private void queueForRetransform(Set<Class<?>> classes) {
        if (Agent.LOG.isFinerEnabled()) {
            for (Class<?> cl : classes) {
                Agent.LOG.log(Level.FINER, "Segment discovery queueing {0} for retransformation", cl.getName());
            }
        }
        this.retransformer.queueRetransform(classes);
    }

    private void removeInstrumentation(ClassMethodSig cms, float durationPercentageDifference) {
        DiscoveryEngineState localState = this.state;
        Collection methods = (Collection)classToTracedMethods.get(cms.getClassName());
        if (methods == null) {
            Agent.LOG.log(Level.FINEST, "Unable to remove instrumentation {0} not in list of traced methods.", cms);
            return;
        }
        boolean removed = methods.remove(new Method(cms.getMethodName(), cms.getMethodDesc()));
        if (!removed) {
            Agent.LOG.log(Level.FINEST, "Unable to schedule removal of instrumentation for method {0}.", cms);
            return;
        }
        Set<Class<?>> classes = localState.callGraph.reloadClassInClassloaders(cms);
        if (classes.isEmpty()) {
            Agent.LOG.log(Level.FINEST, "Unable to remove instrumentation from {0}", cms);
            return;
        }
        this.queueForRetransform(classes);
        this.discoveredMethods.remove(new MethodState(cms, localState.threshold));
        Agent.LOG.log(Level.FINEST, "Removed instrumentation from {0} due to duration percentage difference: {1} < threshold: {2}", cms, Float.valueOf(durationPercentageDifference), 5.0);
    }

    private Collection<ClassMethodSig> filterOutLeafNodes(Collection<ClassMethodSig> allTransactionStartPoints) {
        HashSet<ClassMethodSig> transactionStartPointsToRemove = Sets.newHashSet();
        for (ClassMethodSig sig : allTransactionStartPoints) {
            if (!this.getCallGraph().getMethodsCalledBy(sig).isEmpty()) continue;
            transactionStartPointsToRemove.add(sig);
        }
        HashSet<ClassMethodSig> filteredTransactionStartPoints = Sets.newHashSet(allTransactionStartPoints);
        filteredTransactionStartPoints.removeAll(transactionStartPointsToRemove);
        return filteredTransactionStartPoints;
    }

    private boolean shouldIgnore(String methodName, String className) {
        for (String prefix : this.ignoreTransactionDiscoveryMethodStartsWith) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        for (String subString : this.ignoreTransactionDiscoveryClassContains) {
            if (!methodName.contains(subString) && !className.contains(subString)) continue;
            return true;
        }
        return false;
    }

    private List<Set<String>> getRemovedAndAddedPackages(Collection<String> oldPackages, Collection<String> newPackages) {
        HashSet<String> removedPackages = new HashSet<String>(oldPackages);
        HashSet<String> addedPackages = new HashSet<String>(newPackages);
        removedPackages.removeAll(addedPackages);
        addedPackages.removeAll(oldPackages);
        ArrayList<Set<String>> removedAndAddedPackages = new ArrayList<Set<String>>(Arrays.asList(removedPackages, addedPackages));
        return removedAndAddedPackages;
    }

    private static class DiscoverableClassScanner
    implements ClassMatchVisitorFactory {
        private final Collection<String> packages;

        DiscoverableClassScanner(Collection<String> packages) {
            this.packages = DiscoveryEngineImpl.fixSeparators(packages, "/", ".");
        }

        @Override
        public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
            for (String p : this.packages) {
                if (!classBeingRedefined.getName().startsWith(p)) continue;
                context.putMatch(this, OptimizedClassMatcher.Match.NOOP_MATCH);
                break;
            }
            return null;
        }
    }

    private static class DiscoveryEngineState {
        final int threshold;
        final Collection<String> packages;
        final Graph callGraph;
        final ConcurrentMap<String, ClassNode> classHierarchy;
        final boolean findTransactionStartPoints;

        DiscoveryEngineState(int threshold, Collection<String> packages, boolean findEntryPoints, CallGraph oldCallGraph, ConcurrentMap<String, ClassNode> oldClassHierarchy) {
            this.threshold = threshold;
            this.packages = DiscoveryEngineImpl.fixSeparators(packages, "\\.", "/");
            this.findTransactionStartPoints = findEntryPoints;
            this.callGraph = oldCallGraph == null || oldCallGraph.getCallers().size() == 0 ? new CallGraph() : oldCallGraph;
            this.classHierarchy = oldClassHierarchy == null || oldClassHierarchy.size() == 0 ? new ConcurrentHashMap<String, ClassNode>() : oldClassHierarchy;
        }

        boolean packageEquals(Collection<String> otherPackages) {
            return this.packages.size() == otherPackages.size() && this.packages.containsAll(otherPackages);
        }
    }
}

