/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.graph;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.graph.ClassMethodSig;
import com.newrelic.agent.graph.MethodState;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;

public class ExtensionUtility {
    private static final String DISCOVERY_DIRECTORY = "discovered_instrumentation";
    private static final String DISCOVERED_FILE = "discovered-segments.xml";
    private static final String TRANSACTION_DISCOVERY_FILE = "discovered-transactions.xml";
    private static final String POINTCUT_NO_PARAMS_FORMAT = "  <pointcut transactionStartPoint=\"{0}\" ignoreTransaction=\"false\">\n    <className>{1}</className>\n    <method>\n      <name>{2}</name>\n      <parameters/>\n    </method>\n  </pointcut>\n";
    private static final String POINTCUT_WITH_PARAMS_FORMAT = "  <pointcut transactionStartPoint=\"{0}\" ignoreTransaction=\"false\">\n    <className>{1}</className>\n    <method>\n      <name>{2}</name>\n      <parameters>\n{3}      </parameters>\n    </method>\n  </pointcut>\n";
    private static final String THRESHOLD_COMMENT_FORMAT = "  <!-- threshold={0} -->\n";
    private static final String TRANSACTION_POINT_COMMENT_FORMAT = "  <!-- transactionStartPoint={0} -->\n";
    private static final String METHOD_PARAM_FORMAT = "        <type attributeName=\"\">{0}</type>\n";
    private static final String EXTENSION_FILE_FORMAT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<extension xmlns=\"https://newrelic.com/docs/java/xsd/v1.0\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n           xsi:schemaLocation=\"newrelic-extension extension.xsd\"\n           name=\"segment-discovery\" version=\"1.0\" enabled=\"true\">\n<instrumentation>\n{0}</instrumentation>\n</extension>\n";

    private static String getPointcutNoParams(boolean startTransaction, String className, String methodName) {
        return MessageFormat.format(POINTCUT_NO_PARAMS_FORMAT, startTransaction, className, methodName);
    }

    private static String getPointcutWithParams(boolean startTransaction, String className, String methodName, String params) {
        return MessageFormat.format(POINTCUT_WITH_PARAMS_FORMAT, startTransaction, className, methodName, params);
    }

    private static String getThresholdComment(int threshold) {
        return MessageFormat.format(THRESHOLD_COMMENT_FORMAT, threshold);
    }

    private static String getTransactionStartPointComment(boolean startPoint) {
        return MessageFormat.format(TRANSACTION_POINT_COMMENT_FORMAT, startPoint);
    }

    private static String getMethodParameter(String param) {
        return MessageFormat.format(METHOD_PARAM_FORMAT, param);
    }

    private static String getExtensionFile(String methods) {
        return MessageFormat.format(EXTENSION_FILE_FORMAT, methods);
    }

    private static String createPointcut(boolean startTransaction, int threshold, ClassMethodSig cms) {
        String[] convertedParams;
        StringBuffer pointcutBuffer = new StringBuffer();
        if (threshold > 0) {
            pointcutBuffer.append(ExtensionUtility.getThresholdComment(threshold));
        }
        if (cms.isTransactionStartPoint()) {
            pointcutBuffer.append(ExtensionUtility.getTransactionStartPointComment(cms.isTransactionStartPoint()));
        }
        if ((convertedParams = ExtensionUtility.convertMethodParameters(cms.getMethodDesc())).length == 0) {
            pointcutBuffer.append(ExtensionUtility.getPointcutNoParams(startTransaction, cms.getClassName(), cms.getMethodName()));
        } else {
            String params = ExtensionUtility.createMethodParameters(convertedParams);
            pointcutBuffer.append(ExtensionUtility.getPointcutWithParams(startTransaction, cms.getClassName(), cms.getMethodName(), params));
        }
        return pointcutBuffer.toString();
    }

    private static String createMethodParameters(String[] params) {
        StringBuffer paramsBuffer = new StringBuffer();
        for (String param : params) {
            paramsBuffer.append(ExtensionUtility.getMethodParameter(param));
        }
        return paramsBuffer.toString();
    }

    public static synchronized void writeExtensionFile(Collection<MethodState> methodStates) {
        String xmlBody = ExtensionUtility.getExtensionFileXml(methodStates);
        ExtensionUtility.writeFile(DISCOVERED_FILE, xmlBody);
    }

    @VisibleForTesting
    public static String getExtensionFileXml(Collection<MethodState> methodStates) {
        StringBuffer pointcutsBuffer = new StringBuffer();
        for (MethodState ms : methodStates) {
            pointcutsBuffer.append(ExtensionUtility.createPointcut(false, ms.getThreshold(), ms.getMethodSig()));
        }
        return ExtensionUtility.getExtensionFile(pointcutsBuffer.toString());
    }

    public static synchronized void writeTransactionDiscoveryExtensionFile(Collection<ClassMethodSig> methodSigs) {
        String xmlBody = ExtensionUtility.getTransactionDiscoveryFileXml(methodSigs);
        ExtensionUtility.writeFile(TRANSACTION_DISCOVERY_FILE, xmlBody);
    }

    @VisibleForTesting
    public static String getTransactionDiscoveryFileXml(Collection<ClassMethodSig> methodSigs) {
        StringBuffer pointcutsBuffer = new StringBuffer();
        for (ClassMethodSig cms : methodSigs) {
            pointcutsBuffer.append(ExtensionUtility.createPointcut(true, -1, cms));
        }
        return ExtensionUtility.getExtensionFile(pointcutsBuffer.toString());
    }

    public static String[] convertMethodParameters(String asmMethodSignature) {
        Type[] types = Type.getArgumentTypes(asmMethodSignature);
        String[] params = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            params[i] = ExtensionUtility.getExtensionType(types[i]);
        }
        return params;
    }

    private static String getExtensionType(Type asmType) {
        String type = asmType.toString().replace('/', '.').replace(";", "");
        int arrayDim = 0;
        while (type.charAt(arrayDim) == '[') {
            ++arrayDim;
        }
        type = arrayDim == 0 ? type : type.substring(arrayDim);
        StringBuffer newType = new StringBuffer();
        if (type.startsWith("L")) {
            newType.append(type.substring(1));
        } else if (type.equals("B")) {
            newType.append("byte");
        } else if (type.equals("C")) {
            newType.append("char");
        } else if (type.equals("D")) {
            newType.append("double");
        } else if (type.equals("F")) {
            newType.append("float");
        } else if (type.equals("I")) {
            newType.append("int");
        } else if (type.equals("J")) {
            newType.append("long");
        } else if (type.equals("S")) {
            newType.append("short");
        } else if (type.equals("Z")) {
            newType.append("boolean");
        }
        for (int i = 0; i < arrayDim; ++i) {
            newType.append("[]");
        }
        return newType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String fileName, String content) {
        File discoveryDirectory = ExtensionUtility.getNewRelicDiscoveryDirectory();
        if (discoveryDirectory != null) {
            String fullPath = discoveryDirectory + File.separator + fileName;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(new File(fullPath), false));
                writer.write(content);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.WARNING, "Couldn't write discovery service file: " + fullPath, e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        } else {
            Agent.LOG.log(Level.WARNING, "Couldn't create discovery directory");
        }
    }

    public static File getNewRelicDiscoveryDirectory() {
        File nrDir = ConfigFileHelper.getNewRelicDirectory();
        if (nrDir != null) {
            File discovery = new File(nrDir, DISCOVERY_DIRECTORY);
            if (!discovery.exists()) {
                discovery.mkdir();
            }
            return discovery;
        }
        return null;
    }
}

