/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.SegmentDiscoveryConfig;
import com.newrelic.agent.graph.DiscoveryEngine;
import com.newrelic.agent.graph.DiscoveryEngineImpl;
import com.newrelic.agent.graph.ExtensionUtility;
import com.newrelic.agent.instrumentation.DiscoveryService;
import com.newrelic.agent.reinstrument.PeriodicRetransformer;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.util.logging.Level;

public class DiscoveryServiceImpl
extends AbstractService
implements DiscoveryService,
HarvestListener {
    private volatile SegmentDiscoveryConfig segmentDiscoveryConfig = null;
    private final DiscoveryEngine discoveryEngine;
    private final DiscoveryConfigListener configListener = new DiscoveryConfigListener();

    public DiscoveryServiceImpl() {
        super(DiscoveryService.class.getSimpleName());
        AgentConfig defaultAgentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.segmentDiscoveryConfig = defaultAgentConfig.getSegmentDiscoveryConfig();
        Agent.LOG.log(Level.INFO, "Segment discovery is enabled: {0}", this.segmentDiscoveryConfig.enabled());
        if (this.segmentDiscoveryConfig.enabled()) {
            Agent.LOG.log(Level.INFO, "Segment discovery threshold: {0}", this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold());
            Agent.LOG.log(Level.INFO, "Segment discovery packages: {0}", this.segmentDiscoveryConfig.getDiscoveryPackages());
            Agent.LOG.log(Level.INFO, "Transaction discovery: {0}", this.segmentDiscoveryConfig.transactionDiscoveryEnabled());
            if (this.segmentDiscoveryConfig.transactionDiscoveryEnabled()) {
                Agent.LOG.log(Level.FINER, "Transaction discovery ignoring classes containing: {0}", this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryClassContains());
                Agent.LOG.log(Level.FINER, "Transaction discovery ignoring methods starting with: {0}", this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryMethodStartsWith());
            }
        }
        this.discoveryEngine = new DiscoveryEngineImpl(this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold(), this.segmentDiscoveryConfig.getDiscoveryPackages(), this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryClassContains(), this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryMethodStartsWith(), this.segmentDiscoveryConfig.transactionDiscoveryEnabled(), PeriodicRetransformer.INSTANCE);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        if (this.isEnabled()) {
            ExtensionUtility.writeExtensionFile(this.discoveryEngine.getDiscoveredMethods());
            if (this.segmentDiscoveryConfig.transactionDiscoveryEnabled()) {
                ExtensionUtility.writeTransactionDiscoveryExtensionFile(this.discoveryEngine.getFilteredTransactionStartPoints());
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
        AgentConfig defaultAgentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.segmentDiscoveryConfig = defaultAgentConfig.getSegmentDiscoveryConfig();
        this.discoveryEngine.initialize(this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold(), this.segmentDiscoveryConfig.getDiscoveryPackages(), this.segmentDiscoveryConfig.transactionDiscoveryEnabled());
        ServiceFactory.getConfigService().addIAgentConfigListener(this.configListener);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this.configListener);
    }

    @Override
    public boolean isEnabled() {
        return this.segmentDiscoveryConfig.enabled();
    }

    @Override
    public DiscoveryEngine getDiscoveryEngine() {
        return this.discoveryEngine;
    }

    private void refreshDiscoveryConfig(AgentConfig agentConfig) {
        SegmentDiscoveryConfig oldSegmentDiscoveryConfig = this.segmentDiscoveryConfig;
        this.segmentDiscoveryConfig = agentConfig.getSegmentDiscoveryConfig();
        if (oldSegmentDiscoveryConfig.enabled() == this.segmentDiscoveryConfig.enabled() && oldSegmentDiscoveryConfig.getSegmentDiscoveryThreshold() == this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold() && oldSegmentDiscoveryConfig.getDiscoveryPackages().equals(this.segmentDiscoveryConfig.getDiscoveryPackages()) && oldSegmentDiscoveryConfig.transactionDiscoveryEnabled() == this.segmentDiscoveryConfig.transactionDiscoveryEnabled() && oldSegmentDiscoveryConfig.getIgnoredTransactionDiscoveryClassContains().equals(this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryClassContains()) && oldSegmentDiscoveryConfig.getIgnoredTransactionDiscoveryMethodStartsWith().equals(this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryMethodStartsWith())) {
            return;
        }
        if (oldSegmentDiscoveryConfig.enabled() != this.segmentDiscoveryConfig.enabled()) {
            Agent.LOG.log(Level.INFO, "Segment discovery is now {0}", this.segmentDiscoveryConfig.enabled() ? "enabled" : "disabled");
        }
        if (this.segmentDiscoveryConfig.enabled()) {
            Agent.LOG.log(Level.INFO, "Segment discovery threshold is now {0}", this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold());
            Agent.LOG.log(Level.INFO, "Segment discovery packages are now {0}", this.segmentDiscoveryConfig.getDiscoveryPackages());
            Agent.LOG.log(Level.INFO, "Transaction discovery is now {0}", this.segmentDiscoveryConfig.transactionDiscoveryEnabled());
            if (this.segmentDiscoveryConfig.transactionDiscoveryEnabled()) {
                Agent.LOG.log(Level.INFO, "Transaction discovery now ignoring classes containing {0}", this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryClassContains());
                Agent.LOG.log(Level.INFO, "Transaction discovery now ignoring methods starting with {0}", this.segmentDiscoveryConfig.getIgnoredTransactionDiscoveryMethodStartsWith());
            }
        }
        this.discoveryEngine.setState(this.segmentDiscoveryConfig.getSegmentDiscoveryThreshold(), this.segmentDiscoveryConfig.getDiscoveryPackages(), this.segmentDiscoveryConfig.transactionDiscoveryEnabled());
    }

    private class DiscoveryConfigListener
    implements AgentConfigListener {
        private DiscoveryConfigListener() {
        }

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            if (appName != null && !appName.equals(ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName())) {
                Agent.LOG.log(Level.FINE, "DiscoveryServiceImpl: configuration update for {0} ignored.", appName);
                return;
            }
            DiscoveryServiceImpl.this.refreshDiscoveryConfig(agentConfig);
        }
    }
}

