/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.ClassMetadata;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.StopProcessingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class RequireMethodsAdapter
extends ClassVisitor {
    private final Set<Method> requiredMethods;
    private final ClassLoader classLoader;
    private final String className;
    private final String requiredInterface;
    private final ClassVisitor missingMethodsVisitor = new MissingMethodsVisitor();

    private RequireMethodsAdapter(ClassVisitor cv, Set<Method> requiredMethods, String requiredInterface, String className, ClassLoader loader) {
        super(393216, cv);
        this.className = className;
        this.requiredInterface = requiredInterface;
        this.classLoader = loader;
        this.requiredMethods = new HashSet<Method>(requiredMethods);
    }

    public static RequireMethodsAdapter getRequireMethodsAdaptor(ClassVisitor cv, String className, Class<?> type, ClassLoader loader) {
        Set<Method> requiredMethods = InstrumentationUtils.getDeclaredMethods(type);
        return new RequireMethodsAdapter(cv, requiredMethods, type.getName(), className, loader);
    }

    public static RequireMethodsAdapter getRequireMethodsAdaptor(ClassVisitor cv, Set<Method> requiredMethods, String className, String requiredInterface, ClassLoader loader) {
        return new RequireMethodsAdapter(cv, requiredMethods, requiredInterface, className, loader);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.requiredMethods.remove(new Method(name, desc));
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.requiredMethods.size() > 0) {
            this.visitSuperclassesOrInterfaces();
        }
        if (this.requiredMethods.size() > 0) {
            String msg = MessageFormat.format("{0} does not implement these methods: {1} declared in {2}", this.className, this.requiredMethods, this.requiredInterface);
            throw new StopProcessingException(msg);
        }
        super.visitEnd();
    }

    private void visitSuperclassesOrInterfaces() {
        ClassMetadata metadata = new ClassMetadata(this.className, this.classLoader);
        if (metadata.isInterface()) {
            this.visitInterfaces(metadata);
        } else {
            this.visitSuperclasses(metadata);
        }
    }

    private void visitSuperclasses(ClassMetadata metadata) {
        for (ClassMetadata superClassMetadata = metadata.getSuperclass(); superClassMetadata != null; superClassMetadata = superClassMetadata.getSuperclass()) {
            ClassReader cr = superClassMetadata.getClassReader();
            cr.accept(this.missingMethodsVisitor, 0);
            if (this.requiredMethods.size() != 0) continue;
            return;
        }
    }

    private void visitInterfaces(ClassMetadata metadata) {
        LinkedList<String> pendingInterfaces = new LinkedList<String>();
        pendingInterfaces.addAll(Arrays.asList(metadata.getInterfaceNames()));
        String interfaceName = (String)pendingInterfaces.poll();
        while (interfaceName != null) {
            ClassMetadata interfaceMetadata = new ClassMetadata(interfaceName, this.classLoader);
            ClassReader cr = interfaceMetadata.getClassReader();
            cr.accept(this.missingMethodsVisitor, 0);
            if (this.requiredMethods.size() == 0) {
                return;
            }
            pendingInterfaces.addAll(Arrays.asList(interfaceMetadata.getInterfaceNames()));
            interfaceName = (String)pendingInterfaces.poll();
        }
    }

    private class MissingMethodsVisitor
    extends ClassVisitor {
        private MissingMethodsVisitor() {
            super(393216);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            RequireMethodsAdapter.this.requiredMethods.remove(new Method(name, desc));
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

