/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.analytics.BaseInternalCustomEvent;

public class ClassHistogramRowEvent
extends BaseInternalCustomEvent {
    private static final String TYPE = "ClassHistogramRowEvent";
    private final long classInstances;
    private final long classBytes;
    private final long classInstancesDelta;
    private final long classBytesDelta;
    private final String className;
    private final String classType;

    public ClassHistogramRowEvent(String appName, long classInstances, long classBytes, long classInstancesDelta, long classBytesDelta, String className, String classType) {
        super(appName, TYPE, Maps.<String, Object>newHashMap());
        this.classInstances = classInstances;
        this.classBytes = classBytes;
        this.classInstancesDelta = classInstancesDelta;
        this.classBytesDelta = classBytesDelta;
        this.className = className;
        this.classType = classType;
        this.userAttributes.put("classInstances", classInstances);
        this.userAttributes.put("classBytes", classBytes);
        this.userAttributes.put("classInstancesDelta", classInstancesDelta);
        this.userAttributes.put("classBytesDelta", classBytesDelta);
        this.userAttributes.put("className", className);
        this.userAttributes.put("classType", classType);
    }

    public long getClassInstances() {
        return this.classInstances;
    }

    public long getClassBytes() {
        return this.classBytes;
    }

    public long getClassInstancesDelta() {
        return this.classInstancesDelta;
    }

    public long getClassBytesDelta() {
        return this.classBytesDelta;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassType() {
        return this.classType;
    }

    public String toString() {
        return "ClassHistogramRowEvent{classInstances=" + this.classInstances + ", classBytes=" + this.classBytes + ", classInstancesDelta=" + this.classInstancesDelta + ", classBytesDelta=" + this.classBytesDelta + ", className='" + this.className + '\'' + ", classType='" + this.classType + '\'' + '}';
    }
}

