/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.MinMaxPriorityQueue;
import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.agent.service.analytics.PriorityAware;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class DistributedSamplingPriorityQueue<E extends PriorityAware> {
    private final Queue<E> data;
    private final AtomicInteger numberOfTries = new AtomicInteger();
    private final AtomicInteger recorded;
    private final int seenLast;
    private final int target;
    private final Comparator<E> comparator;

    public DistributedSamplingPriorityQueue(int reservoirSize) {
        this(reservoirSize, 0, 0, null);
    }

    public DistributedSamplingPriorityQueue(int reservoirSize, int seenLast, int target) {
        this(reservoirSize, seenLast, target, null);
    }

    public DistributedSamplingPriorityQueue(int reservoirSize, int seenLast, int target, Comparator<E> comparator) {
        this.comparator = comparator == null ? this.getPriorityAwareComparator() : comparator;
        this.data = Queues.synchronizedQueue(MinMaxPriorityQueue.orderedBy(this.comparator).maximumSize(reservoirSize).create());
        this.recorded = new AtomicInteger(0);
        this.seenLast = seenLast;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAll(DistributedSamplingPriorityQueue<E> source) {
        Queue<E> queue = source.data;
        synchronized (queue) {
            for (PriorityAware element : source.data) {
                this.add(element);
            }
        }
    }

    public int getNumberOfTries() {
        return this.numberOfTries.get();
    }

    public boolean add(E element) {
        this.numberOfTries.incrementAndGet();
        boolean added = this.data.offer(element);
        if (added && element.decider() && DistributedTraceUtil.isSampledPriority(element.getPriority())) {
            this.recorded.incrementAndGet();
        }
        return added;
    }

    public E peek() {
        return (E)((PriorityAware)this.data.peek());
    }

    public E poll() {
        return (E)((PriorityAware)this.data.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> asList() {
        ArrayList<E> elements;
        Queue<E> queue = this.data;
        synchronized (queue) {
            elements = Lists.newArrayList(this.data);
        }
        Collections.sort(elements, this.comparator);
        return elements;
    }

    public int getSampled() {
        return this.recorded.get();
    }

    public int getSeenLast() {
        return this.seenLast;
    }

    public int getTarget() {
        return this.target;
    }

    public int size() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
    }

    private Comparator<E> getPriorityAwareComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E left, E right) {
                return Float.compare(right.getPriority(), left.getPriority());
            }
        };
    }
}

