/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.service.analytics.FixedSizeArrayList;
import java.util.Random;

public class ReservoirSampledArrayList<E>
extends FixedSizeArrayList<E> {
    static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    public ReservoirSampledArrayList(int reservoirSize) {
        super(reservoirSize);
    }

    @Override
    public Integer getSlot() {
        int currentCount = this.numberOfTries.incrementAndGet() - 1;
        int insertIndex = currentCount < this.size ? currentCount : RANDOM.get().nextInt(currentCount);
        if (insertIndex >= this.size) {
            return null;
        }
        return insertIndex;
    }

    void setRandomFixedSeed(long seed) {
        RANDOM.set(new Random(seed));
    }
}

