/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.service.analytics.SpanCategory;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.HttpParameters;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpanEvent
extends AnalyticsEvent {
    private static final String SPAN = "Span";
    private final String appName;
    private final Map<String, Object> intrinsics;
    private final Map<String, Object> userAttributes;
    private final Map<String, Object> agentAttributes;
    private final boolean decider;

    private SpanEvent(String appName, float priority, Map<String, Object> intrinsics, Map<String, Object> userAttributes, Map<String, Object> agentAttributes, boolean decider) {
        super(SPAN, System.currentTimeMillis(), priority);
        this.appName = appName;
        this.intrinsics = intrinsics;
        this.userAttributes = userAttributes;
        this.agentAttributes = agentAttributes;
        this.decider = decider;
    }

    public Map<String, Object> getIntrinsics() {
        return this.intrinsics;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    public boolean isDecider() {
        return this.decider;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        Map<String, ? extends Object> filteredUserAtts = this.getUserFilteredMap(this.userAttributes);
        Map<String, ? extends Object> filteredAgentAtts = this.getFilteredMap(this.agentAttributes);
        JSONArray.writeJSONString(Arrays.asList(this.intrinsics, filteredUserAtts, filteredAgentAtts), out);
    }

    private Map<String, ? extends Object> getFilteredMap(Map<String, Object> input) {
        return ServiceFactory.getAttributesService().filterEventAttributes(this.appName, input);
    }

    private Map<String, ? extends Object> getUserFilteredMap(Map<String, Object> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }

    public static SpanEventBuilder builder() {
        return SpanEventBuilder.builder();
    }

    public String getTraceId() {
        return (String)this.intrinsics.get("traceId");
    }

    public String getGuid() {
        return (String)this.intrinsics.get("guid");
    }

    public String getParentId() {
        return (String)this.intrinsics.get("parentId");
    }

    public String getName() {
        return (String)this.intrinsics.get("name");
    }

    public float getDuration() {
        return ((Float)this.intrinsics.get("duration")).floatValue();
    }

    public String getAppLocalRootId() {
        return (String)this.intrinsics.get("appLocalRootId");
    }

    public SpanCategory getCategory() {
        return SpanCategory.fromString((String)this.intrinsics.get("category"));
    }

    public static final class SpanEventBuilder {
        private String appName;
        private float priority;
        private Map<String, Object> userAttributes;
        private Map<String, Object> agentAttributes;
        private Map<String, Object> intrinsics = new HashMap<String, Object>();
        private boolean decider;

        private SpanEventBuilder() {
            this.intrinsics.put("type", SpanEvent.SPAN);
            this.intrinsics.put("category", SpanCategory.generic.name());
        }

        private static SpanEventBuilder builder() {
            return new SpanEventBuilder();
        }

        public SpanEventBuilder setPriority(float priority) {
            this.priority = priority;
            this.intrinsics.put("priority", Float.valueOf(priority));
            return this;
        }

        public SpanEventBuilder setParentType(String parentType) {
            if (parentType != null) {
                this.intrinsics.put("parent.type", parentType);
            }
            return this;
        }

        public SpanEventBuilder setParentAccount(String parentAccount) {
            if (parentAccount != null) {
                this.intrinsics.put("parent.account", parentAccount);
            }
            return this;
        }

        public SpanEventBuilder setParentAppId(String parentAppId) {
            if (parentAppId != null) {
                this.intrinsics.put("parent.app", parentAppId);
            }
            return this;
        }

        public SpanEventBuilder setParentId(String parentId) {
            if (parentId != null) {
                this.intrinsics.put("parentId", parentId);
            }
            return this;
        }

        public SpanEventBuilder setGuid(String guid) {
            if (guid != null) {
                this.intrinsics.put("guid", guid);
            }
            return this;
        }

        public SpanEventBuilder setTraceId(String traceId) {
            if (traceId != null) {
                this.intrinsics.put("traceId", traceId);
            }
            return this;
        }

        public SpanEventBuilder setSampled(boolean sampled) {
            this.intrinsics.put("sampled", sampled);
            return this;
        }

        public SpanEventBuilder setSpanTimestamp(long spanTimestamp) {
            this.intrinsics.put("timestamp", spanTimestamp);
            return this;
        }

        public SpanEventBuilder setGrandparentId(String grandparentId) {
            if (grandparentId != null) {
                this.intrinsics.put("grandparentId", grandparentId);
            }
            return this;
        }

        public SpanEventBuilder setParentTransportType(String parentTransportType) {
            this.intrinsics.put("parent.transportType", parentTransportType);
            return this;
        }

        public SpanEventBuilder setParentTransportDuration(float parentTransportDuration) {
            this.intrinsics.put("parent.transportDuration", Float.valueOf(parentTransportDuration));
            return this;
        }

        public SpanEventBuilder setDurationInSeconds(float duration) {
            this.intrinsics.put("duration", Float.valueOf(duration));
            return this;
        }

        public SpanEventBuilder setName(String name) {
            if (name != null) {
                this.intrinsics.put("name", name);
            }
            return this;
        }

        public SpanEventBuilder setAppName(String appName) {
            if (appName != null) {
                this.appName = appName;
            }
            return this;
        }

        public SpanEventBuilder setUserAttributes(Map<String, Object> userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        public SpanEventBuilder setAgentAttributes(Map<String, Object> agentAttributes) {
            this.agentAttributes = agentAttributes;
            return this;
        }

        public SpanEventBuilder setAppLocalRootId(String rootId) {
            if (rootId != null) {
                this.intrinsics.put("appLocalRootId", rootId);
            }
            return this;
        }

        public SpanEventBuilder setTimestamp(long startTime) {
            this.intrinsics.put("timestamp", startTime);
            return this;
        }

        public SpanEventBuilder setUri(URI uri) {
            if (uri != null) {
                this.intrinsics.put("externalUri", uri.toString());
            }
            return this;
        }

        public SpanEventBuilder setProcedure(String procedure) {
            if (procedure != null) {
                this.intrinsics.put("externalProcedure", procedure);
            }
            return this;
        }

        public SpanEventBuilder setLibrary(String library) {
            if (library != null) {
                this.intrinsics.put("externalLibrary", library);
            }
            return this;
        }

        public SpanEventBuilder setDatabaseName(String databaseName) {
            if (databaseName != null) {
                this.intrinsics.put("datastoreName", databaseName);
            }
            return this;
        }

        public SpanEventBuilder setProduct(String product) {
            if (product != null) {
                this.intrinsics.put("datastoreProduct", product);
            }
            return this;
        }

        public SpanEventBuilder setOperation(String operation) {
            if (operation != null) {
                this.intrinsics.put("datastoreOperation", operation);
            }
            return this;
        }

        public SpanEventBuilder setCategory(SpanCategory category) {
            if (category != null) {
                this.intrinsics.put("category", category.name());
            }
            return this;
        }

        public SpanEventBuilder setCollection(String collection) {
            if (collection != null) {
                this.intrinsics.put("datastoreCollection", collection);
            }
            return this;
        }

        public SpanEventBuilder setHost(String host) {
            if (host != null) {
                this.intrinsics.put("datastoreHost", host);
            }
            return this;
        }

        public SpanEventBuilder setDbPortPathOrId(String portPathOrId) {
            if (portPathOrId != null) {
                this.intrinsics.put("datastorePortPathOrId", portPathOrId);
            }
            return this;
        }

        public SpanEventBuilder setDecider(boolean decider) {
            this.decider = decider;
            return this;
        }

        public SpanEventBuilder setExternalParameterAttributes(ExternalParameters parameters) {
            if (parameters instanceof HttpParameters) {
                HttpParameters httpParameters = (HttpParameters)parameters;
                this.setCategory(SpanCategory.external);
                this.setUri(httpParameters.getUri());
                this.setProcedure(httpParameters.getProcedure());
                this.setLibrary(httpParameters.getLibrary());
            } else if (parameters instanceof DatastoreParameters) {
                DatastoreParameters datastoreParameters = (DatastoreParameters)parameters;
                this.setCategory(SpanCategory.datastore);
                this.setProduct(datastoreParameters.getProduct());
                this.setCollection(datastoreParameters.getCollection());
                this.setOperation(datastoreParameters.getOperation());
                this.setDatabaseName(datastoreParameters.getDatabaseName());
                this.setHost(datastoreParameters.getHost());
                if (datastoreParameters.getPort() != null) {
                    this.setDbPortPathOrId(String.valueOf(datastoreParameters.getPort()));
                } else {
                    this.setDbPortPathOrId(datastoreParameters.getPathOrId());
                }
            } else {
                this.setCategory(SpanCategory.generic);
            }
            return this;
        }

        public SpanEvent build() {
            return new SpanEvent(this.appName, this.priority, this.intrinsics, this.userAttributes, this.agentAttributes, this.decider);
        }
    }
}

