/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.deps.com.google.common.collect.ComparisonChain;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AdaptiveSampling;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.SpanEvent;
import com.newrelic.agent.service.analytics.SpanEventHarvestableImpl;
import com.newrelic.agent.service.analytics.SpanEventsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.HttpParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SpanEventsServiceImpl
extends AbstractService
implements AgentConfigListener,
SpanEventsService,
TransactionListener {
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<SpanEvent>> reservoirForApp = new ConcurrentHashMap();
    private List<Harvestable> harvestables = new ArrayList<Harvestable>();
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    private volatile SpanEventsConfig spanEventsConfig;
    private volatile int maxSamplesStored;
    private static final Comparator<SpanEvent> SPAN_EVENT_COMPARATOR = new Comparator<SpanEvent>(){

        @Override
        public int compare(SpanEvent left, SpanEvent right) {
            return ComparisonChain.start().compare(right.getPriority(), left.getPriority()).result();
        }
    };

    public SpanEventsServiceImpl() {
        super(SpanEventsServiceImpl.class.getName());
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.spanEventsConfig = agentConfig.getSpanEventsConfig();
        this.maxSamplesStored = this.spanEventsConfig.getMaxSamplesStored();
        this.isEnabledForApp.put(agentConfig.getApplicationName(), this.spanEventsConfig.isEnabled());
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
        ServiceFactory.getTransactionService().addTransactionListener(this);
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (transactionData.sampled() && this.spanEventsConfig.isEnabled()) {
            Tracer rootTracer = transactionData.getRootTracer();
            try {
                this.createAndStoreSpanEvent(rootTracer, transactionData);
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINER, t, "An error occurred creating span event for tracer: {0} in tx: {1}", rootTracer, transactionData);
            }
            Collection<Tracer> tracers = transactionData.getTracers();
            for (Tracer tracer : tracers) {
                if (!tracer.isTransactionSegment()) continue;
                try {
                    this.createAndStoreSpanEvent(tracer, transactionData);
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINER, t, "An error occurred creating span event for tracer: {0} in tx: {1}", tracer, transactionData);
                }
            }
        }
    }

    private void createAndStoreSpanEvent(Tracer tracer, TransactionData transactionData) {
        boolean crossProcessOnly = this.spanEventsConfig.isCrossProcessOnly();
        if (crossProcessOnly && !this.isCrossProcessTracer(tracer)) {
            return;
        }
        DistributedTracePayloadImpl inboundPayload = transactionData.getSpanProxy().getInboundDistributedTracePayload();
        SpanEvent.SpanEventBuilder builder = SpanEvent.builder().setAppName(transactionData.getApplicationName()).setGuid(tracer.getGuid()).setTraceId(inboundPayload != null ? inboundPayload.traceId : transactionData.getGuid()).setSampled(transactionData.sampled()).setParentId(this.getParentId(tracer, transactionData, crossProcessOnly)).setAppLocalRootId(transactionData.getGuid()).setDurationInSeconds((float)tracer.getDuration() / 1.0E9f).setName(tracer.getTransactionSegmentName()).setTimestamp(tracer.getStartTimeInMillis()).setGrandparentId(this.getGrandparentId(tracer, transactionData, inboundPayload, crossProcessOnly)).setPriority(transactionData.getPriority()).setExternalParameterAttributes(tracer.getExternalParameters()).setDecider(inboundPayload == null || inboundPayload.priority == null);
        this.storeEvent(builder.build());
    }

    private boolean isCrossProcessTracer(Tracer tracer) {
        return tracer.getExternalParameters() instanceof HttpParameters || tracer.getExternalParameters() instanceof DatastoreParameters;
    }

    private String getParentId(Tracer tracer, TransactionData transactionData, boolean crossProcessOnly) {
        if (crossProcessOnly) {
            return transactionData.getGuid();
        }
        Tracer parentSegment = this.getParentTracerWithSpan(tracer.getParentTracer());
        DistributedTracePayloadImpl inboundPayload = transactionData.getInboundDistributedTracePayload();
        if (parentSegment != null) {
            return parentSegment.getGuid();
        }
        return transactionData.getGuid();
    }

    private String getGrandparentId(Tracer tracer, TransactionData transactionData, DistributedTracePayloadImpl inboundPayload, boolean crossProcessOnly) {
        if (crossProcessOnly) {
            return inboundPayload != null ? inboundPayload.id : null;
        }
        Tracer parentSegment = this.getParentTracerWithSpan(tracer.getParentTracer());
        Tracer grandParentSegment = parentSegment != null ? this.getParentTracerWithSpan(parentSegment.getParentTracer()) : null;
        return grandParentSegment == null ? this.getTransactionParent(transactionData) : grandParentSegment.getGuid();
    }

    @Override
    public Tracer getParentTracerWithSpan(Tracer parentTracer) {
        while (parentTracer != null && !parentTracer.isTransactionSegment()) {
            parentTracer = parentTracer.getParentTracer();
        }
        return parentTracer;
    }

    private String getTransactionParent(TransactionData transactionData) {
        DistributedTracePayloadImpl inboundPayload = transactionData.getSpanProxy().getInboundDistributedTracePayload();
        if (inboundPayload != null) {
            return inboundPayload.id;
        }
        return null;
    }

    public void harvestEvents(final String appName) {
        if (!this.getIsEnabledForApp(appName)) {
            this.reservoirForApp.remove(appName);
            return;
        }
        if (this.maxSamplesStored <= 0) {
            return;
        }
        long startTimeInNanos = System.nanoTime();
        DistributedSamplingPriorityQueue<SpanEvent> currentReservoir = this.reservoirForApp.get(appName);
        int seenLast = AdaptiveSampling.seenLast(currentReservoir, this.spanEventsConfig.getTargetSamplesStored());
        final DistributedSamplingPriorityQueue<SpanEvent> toSend = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue<SpanEvent>(this.maxSamplesStored, seenLast, this.spanEventsConfig.getTargetSamplesStored(), SPAN_EVENT_COMPARATOR));
        if (toSend != null && toSend.size() > 0) {
            try {
                ServiceFactory.getRPMService(appName).sendSpanEvents(this.maxSamplesStored, toSend.getNumberOfTries(), Collections.unmodifiableList(toSend.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        SpanEventsServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, toSend);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                });
                if (toSend.size() < toSend.getNumberOfTries()) {
                    Agent.LOG.log(Level.WARNING, "Dropped {0} span events out of {1}.", toSend.getNumberOfTries() - toSend.size(), toSend.getNumberOfTries());
                }
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send span events. Unsent events will be included in the next harvest.");
                DistributedSamplingPriorityQueue<SpanEvent> newReservoir = this.reservoirForApp.get(appName);
                newReservoir.retryAll(toSend);
            }
        }
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, DistributedSamplingPriorityQueue<SpanEvent> reservoir) {
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSeen").incrementCallCount(reservoir.getNumberOfTries());
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/SpanEvent/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isEnabled() {
        return this.spanEventsConfig.isEnabled();
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.removeHarvestables();
        this.reservoirForApp.clear();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    @Override
    public void storeEvent(SpanEvent event) {
        DistributedSamplingPriorityQueue<SpanEvent> reservoir = this.getOrCreateDistributedSamplingReservoir(event.getAppName());
        reservoir.add(event);
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
    }

    public void clearReservoir() {
        this.reservoirForApp.clear();
    }

    @Override
    public void addHarvestableToService(String appName) {
        SpanEventHarvestableImpl harvestable = new SpanEventHarvestableImpl(this, appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestable);
        this.harvestables.add(harvestable);
    }

    private boolean getIsEnabledForApp(String currentAppName) {
        Boolean appEnabled = (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = this.isEnabled();
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.isEnabledForApp.remove(appName);
        this.spanEventsConfig = agentConfig.getSpanEventsConfig();
    }

    @Override
    public DistributedSamplingPriorityQueue<SpanEvent> getOrCreateDistributedSamplingReservoir(String appName) {
        DistributedSamplingPriorityQueue<SpanEvent> reservoir = this.reservoirForApp.get(appName);
        if (reservoir == null) {
            int target = this.spanEventsConfig.getTargetSamplesStored();
            reservoir = this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue<SpanEvent>(this.spanEventsConfig.getMaxSamplesStored(), target << 8, target, SPAN_EVENT_COMPARATOR));
            if (reservoir == null) {
                reservoir = this.reservoirForApp.get(appName);
            }
        }
        return reservoir;
    }
}

