/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.bridge.TransportType;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.stats.ApdexPerfZone;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.transaction.TimeoutCause;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TransactionEvent
extends AnalyticsEvent {
    static final float UNASSIGNED = Float.NEGATIVE_INFINITY;
    static final int UNASSIGNED_INT = Integer.MIN_VALUE;
    static final String TYPE = "Transaction";
    final String guid;
    final String referrerGuid;
    final String tripId;
    final Integer referringPathHash;
    Integer pathHash;
    final String alternatePathHashes;
    final ApdexPerfZone apdexPerfZone;
    final String syntheticsResourceId;
    final String syntheticsMonitorId;
    final String syntheticsJobId;
    final int port;
    final boolean error;
    final boolean decider;
    final String name;
    final float duration;
    final float totalTime;
    float timeToFirstByte = Float.NEGATIVE_INFINITY;
    float timeToLastByte = Float.NEGATIVE_INFINITY;
    float queueDuration = Float.NEGATIVE_INFINITY;
    float externalDuration = Float.NEGATIVE_INFINITY;
    float externalCallCount = Float.NEGATIVE_INFINITY;
    float databaseDuration = Float.NEGATIVE_INFINITY;
    float databaseCallCount = Float.NEGATIVE_INFINITY;
    float gcCumulative = Float.NEGATIVE_INFINITY;
    Map<String, Object> agentAttributes;
    String appName;
    final String timeoutCause;
    final float priority;
    final Map<String, Object> distributedTraceIntrinsics;

    public TransactionEvent(String appName, String subType, long timestamp, String name, float duration, String guid, String referringGuid, Integer port, String tripId, Integer referringPathHash, String alternatePathHashes, ApdexPerfZone apdexPerfZone, String syntheticsResourceId, String syntheticsMonitorId, String syntheticsJobId, boolean error, float pTotalTime, TimeoutCause timeoutCause, DistributedTracePayloadImpl payload, TransportType transportType, long transportDuration, long largestTransportDuration, String parentId, String grandparentId, float priority) {
        super(TYPE, timestamp);
        this.name = name;
        this.duration = duration;
        this.guid = guid;
        this.referrerGuid = referringGuid;
        this.tripId = tripId;
        this.referringPathHash = referringPathHash;
        this.alternatePathHashes = alternatePathHashes;
        this.port = port == null ? Integer.MIN_VALUE : port;
        this.appName = appName;
        this.apdexPerfZone = apdexPerfZone;
        this.syntheticsResourceId = syntheticsResourceId;
        this.syntheticsMonitorId = syntheticsMonitorId;
        this.syntheticsJobId = syntheticsJobId;
        this.error = error;
        this.totalTime = pTotalTime;
        this.timeoutCause = timeoutCause == null ? null : timeoutCause.cause;
        this.priority = priority;
        this.decider = payload == null || payload.priority == null;
        DistributedTracingConfig distributedTracingConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig();
        if (distributedTracingConfig.isEnabled()) {
            DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
            this.distributedTraceIntrinsics = distributedTraceService.getIntrinsics(payload, guid, tripId, transportType, transportDuration, largestTransportDuration, parentId, grandparentId, priority);
        } else {
            this.distributedTraceIntrinsics = null;
        }
    }

    public float getDuration() {
        return this.duration;
    }

    public float getTotalTime() {
        return this.totalTime;
    }

    public float getTTFB() {
        return this.timeToFirstByte;
    }

    public float getTTLB() {
        return this.timeToLastByte;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public float getExternalCallCount() {
        return this.externalCallCount;
    }

    public float getExternalDuration() {
        return this.externalDuration;
    }

    public float getDatabaseCallCount() {
        return this.databaseCallCount;
    }

    public float getDatabaseDuration() {
        return this.databaseDuration;
    }

    public boolean isError() {
        return this.error;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTripId() {
        return this.tripId;
    }

    public Integer getPathHash() {
        return this.pathHash;
    }

    public String getAlternatePathHashes() {
        return this.alternatePathHashes;
    }

    public String getReferrerGuid() {
        return this.referrerGuid;
    }

    public Integer getReferringPathHash() {
        return this.referringPathHash;
    }

    public String getApdexPerfZone() {
        if (this.apdexPerfZone != null) {
            return this.apdexPerfZone.getZone();
        }
        return null;
    }

    public String getTimeoutCause() {
        return this.timeoutCause;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Map<String, Object> getDistributedTraceIntrinsics() {
        return this.distributedTraceIntrinsics;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("type", this.type);
        obj.put("timestamp", this.timestamp);
        obj.put("name", this.name);
        obj.put("duration", Float.valueOf(this.duration));
        obj.put("error", this.error);
        obj.put("totalTime", Float.valueOf(this.totalTime));
        if (this.timeToFirstByte != Float.NEGATIVE_INFINITY) {
            obj.put("timeToFirstByte", Float.valueOf(this.timeToFirstByte));
        }
        if (this.timeToLastByte != Float.NEGATIVE_INFINITY) {
            obj.put("timeToLastByte", Float.valueOf(this.timeToLastByte));
        }
        if (this.apdexPerfZone != null) {
            obj.put("apdexPerfZone", this.apdexPerfZone.getZone());
        }
        if (this.guid != null) {
            obj.put("nr.guid", this.guid);
        }
        if (this.referrerGuid != null) {
            obj.put("nr.referringTransactionGuid", this.referrerGuid);
        }
        if (this.tripId != null) {
            obj.put("nr.tripId", this.tripId);
        }
        if (this.pathHash != null) {
            obj.put("nr.pathHash", ServiceUtils.intToHexString(this.pathHash));
        }
        if (this.referringPathHash != null) {
            obj.put("nr.referringPathHash", ServiceUtils.intToHexString(this.referringPathHash));
        }
        if (this.alternatePathHashes != null) {
            obj.put("nr.alternatePathHashes", this.alternatePathHashes);
        }
        if (this.syntheticsResourceId != null) {
            obj.put("nr.syntheticsResourceId", this.syntheticsResourceId);
        }
        if (this.syntheticsMonitorId != null) {
            obj.put("nr.syntheticsMonitorId", this.syntheticsMonitorId);
        }
        if (this.syntheticsJobId != null) {
            obj.put("nr.syntheticsJobId", this.syntheticsJobId);
        }
        if (this.port != Integer.MIN_VALUE) {
            obj.put("port", this.port);
        }
        if (this.queueDuration != Float.NEGATIVE_INFINITY) {
            obj.put("queueDuration", Float.valueOf(this.queueDuration));
        }
        if (this.externalDuration != Float.NEGATIVE_INFINITY) {
            obj.put("externalDuration", Float.valueOf(this.externalDuration));
        }
        if (this.externalCallCount > 0.0f) {
            obj.put("externalCallCount", Float.valueOf(this.externalCallCount));
        }
        if (this.databaseDuration != Float.NEGATIVE_INFINITY) {
            obj.put("databaseDuration", Float.valueOf(this.databaseDuration));
        }
        if (this.databaseCallCount > 0.0f) {
            obj.put("databaseCallCount", Float.valueOf(this.databaseCallCount));
        }
        if (this.gcCumulative != Float.NEGATIVE_INFINITY) {
            obj.put("gcCumulative", Float.valueOf(this.gcCumulative));
        }
        if (this.timeoutCause != null) {
            obj.put("nr.timeoutCause", this.timeoutCause);
        }
        if (this.distributedTraceIntrinsics != null && !this.distributedTraceIntrinsics.isEmpty()) {
            obj.putAll(this.distributedTraceIntrinsics);
        }
        Map<String, ? extends Object> filteredUserAtts = this.getUserFilteredMap(this.userAttributes);
        Map<String, ? extends Object> filteredAgentAtts = this.getFilteredMap(this.agentAttributes);
        if (filteredAgentAtts.isEmpty()) {
            if (filteredUserAtts.isEmpty()) {
                JSONArray.writeJSONString(Collections.singletonList(obj), out);
            } else {
                JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts), out);
            }
        } else {
            JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts, filteredAgentAtts), out);
        }
    }

    private Map<String, ? extends Object> getFilteredMap(Map<String, Object> input) {
        return ServiceFactory.getAttributesService().filterEventAttributes(this.appName, input);
    }

    private Map<String, ? extends Object> getUserFilteredMap(Map<String, Object> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean decider() {
        return this.decider;
    }

    @Override
    public Map<String, Object> getAttributesCopy() {
        HashMap<String, Object> map = Maps.newHashMap(super.getAttributesCopy());
        map.putAll(this.agentAttributes);
        return map;
    }
}

