/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.datastore.DatastoreMetrics;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.BoundedConcurrentCache;
import com.newrelic.agent.sql.SlowQueryInfo;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.QueryConverter;
import com.newrelic.api.agent.SlowQueryDatastoreParameters;
import com.newrelic.api.agent.SlowQueryWithInputDatastoreParameters;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DefaultSlowQueryListener
implements SlowQueryListener {
    private static final int MAX_SQL_TRACERS = 175;
    private final double thresholdInMillis;
    private volatile BoundedConcurrentCache<String, SlowQueryInfo> slowQueryInfoCache;
    private final SqlObfuscator sqlObfuscator;

    public DefaultSlowQueryListener(String appName, double thresholdInMillis) {
        this.thresholdInMillis = thresholdInMillis;
        SqlObfuscator sqlObfuscator = ServiceFactory.getDatabaseService().getSqlObfuscator(appName);
        this.sqlObfuscator = SqlObfuscator.getCachingSqlObfuscator(sqlObfuscator);
    }

    @Override
    public <T> void noticeTracer(Tracer tracer, SlowQueryDatastoreParameters<T> slowQueryDatastoreParameters) {
        if ((double)tracer.getDurationInMilliseconds() > this.thresholdInMillis) {
            SlowQueryInfo existingInfo;
            boolean allUnknown;
            Object rawQuery = slowQueryDatastoreParameters.getRawQuery();
            QueryConverter queryConverter = slowQueryDatastoreParameters.getQueryConverter();
            if (rawQuery == null || queryConverter == null) {
                return;
            }
            String rawQueryString = queryConverter.toRawQueryString(rawQuery);
            if (rawQueryString == null || rawQueryString.trim().isEmpty()) {
                return;
            }
            String obfuscatedQueryString = queryConverter.toObfuscatedQueryString(rawQuery);
            if (obfuscatedQueryString == null) {
                return;
            }
            if (slowQueryDatastoreParameters instanceof SlowQueryWithInputDatastoreParameters) {
                this.handleInputQuery(tracer, (SlowQueryWithInputDatastoreParameters)slowQueryDatastoreParameters);
            }
            tracer.setAttribute("sql", rawQueryString);
            tracer.setAttribute("sql_obfuscated", obfuscatedQueryString);
            DatastoreConfig datastoreConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDatastoreConfig();
            boolean bl = allUnknown = slowQueryDatastoreParameters.getHost() == null && slowQueryDatastoreParameters.getPort() == null && slowQueryDatastoreParameters.getPathOrId() == null;
            if (datastoreConfig.isInstanceReportingEnabled() && !allUnknown) {
                tracer.setAttribute("host", DatastoreMetrics.replaceLocalhost(slowQueryDatastoreParameters.getHost()));
                tracer.setAttribute("port_path_or_id", DatastoreMetrics.getIdentifierOrPort(slowQueryDatastoreParameters.getPort(), slowQueryDatastoreParameters.getPathOrId()));
            }
            if (datastoreConfig.isDatabaseNameReportingEnabled() && slowQueryDatastoreParameters.getDatabaseName() != null) {
                tracer.setAttribute("database_name", slowQueryDatastoreParameters.getDatabaseName());
            }
            if (this.slowQueryInfoCache == null) {
                this.slowQueryInfoCache = new BoundedConcurrentCache(175);
            }
            if ((existingInfo = this.slowQueryInfoCache.get(obfuscatedQueryString)) != null) {
                existingInfo.aggregate(tracer);
                this.slowQueryInfoCache.putReplace(obfuscatedQueryString, existingInfo);
            } else {
                SlowQueryInfo sqlInfo = new SlowQueryInfo(null, tracer, rawQueryString, obfuscatedQueryString, tracer.getTransactionActivity().getTransaction().getAgentConfig().getSqlTraceConfig());
                sqlInfo.aggregate(tracer);
                this.slowQueryInfoCache.putIfAbsent(obfuscatedQueryString, sqlInfo);
            }
        }
    }

    @Override
    public List<SlowQueryInfo> getSlowQueries() {
        if (this.slowQueryInfoCache == null) {
            return Collections.emptyList();
        }
        return this.slowQueryInfoCache.asList();
    }

    private <T, I> void handleInputQuery(Tracer tracer, SlowQueryWithInputDatastoreParameters<T, I> slowQueryWithInputDatastoreParameters) {
        String inputQueryLabel = slowQueryWithInputDatastoreParameters.getInputQueryLabel();
        Object rawInputQuery = slowQueryWithInputDatastoreParameters.getRawInputQuery();
        QueryConverter inputQueryConverter = slowQueryWithInputDatastoreParameters.getRawInputQueryConverter();
        if (inputQueryLabel == null || rawInputQuery == null || inputQueryConverter == null) {
            return;
        }
        String rawInputQueryString = inputQueryConverter.toRawQueryString(rawInputQuery);
        if (rawInputQueryString == null || rawInputQueryString.trim().isEmpty()) {
            return;
        }
        String obfuscatedInputQueryString = null;
        if (this.sqlObfuscator.isObfuscating() && (obfuscatedInputQueryString = inputQueryConverter.toObfuscatedQueryString(rawInputQuery)) == null) {
            return;
        }
        if (obfuscatedInputQueryString != null && obfuscatedInputQueryString.equals(rawInputQueryString)) {
            return;
        }
        HashMap<String, String> inputQueryParameterValue = Maps.newHashMap();
        inputQueryParameterValue.put("label", inputQueryLabel);
        if (this.sqlObfuscator.isObfuscating()) {
            inputQueryParameterValue.put("query", obfuscatedInputQueryString);
        } else {
            inputQueryParameterValue.put("query", rawInputQueryString);
        }
        tracer.setAttribute("input_query", inputQueryParameterValue);
    }
}

