/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Map;

public class HttpError
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> RESPONSE_MESSAGES = ImmutableMap.of(413, "The data post was too large ({1})", 415, "An error occurred serializing data ({1})", 500, "{0} encountered an internal error ({1})", 503, "{0} is temporarily unavailable ({1})");
    private final int statusCode;
    private final int entitySizeInBytes;

    public HttpError(String message, int statusCode, int entitySizeInBytes) {
        super(message == null ? Integer.toString(statusCode) : message);
        this.statusCode = statusCode;
        this.entitySizeInBytes = entitySizeInBytes;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getEntitySizeInBytes() {
        return this.entitySizeInBytes;
    }

    public static HttpError create(int statusCode, String host, int entitySizeInBytes) {
        String messageFormat = RESPONSE_MESSAGES.get(statusCode);
        if (messageFormat == null) {
            messageFormat = "Received a {1} response from {0}";
        }
        String message = MessageFormat.format(messageFormat, host, statusCode);
        return new HttpError(message, statusCode, entitySizeInBytes);
    }

    public boolean isRetryableError() {
        return this.statusCode != 413 && this.statusCode != 415;
    }
}

