/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.bootstrap.EmbeddedJarFilesImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class ClassResolvers {
    private ClassResolvers() {
    }

    public static ClassResolver getEmbeddedJarsClassResolver() {
        ArrayList<ClassResolver> resolvers = Lists.newArrayList();
        for (String name : EmbeddedJarFilesImpl.INSTANCE.getEmbeddedAgentJarFileNames()) {
            try {
                resolvers.add(ClassResolvers.getJarClassResolver(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(name)));
            }
            catch (IOException e) {
                Agent.LOG.log(Level.SEVERE, e, "Unable to load {0} : {1}", name, e.getMessage());
            }
        }
        return ClassResolvers.getMultiResolver(resolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassResolver getJarClassResolver(final File jarFile) throws IOException {
        final HashSet<String> classNames = Sets.newHashSet();
        JarFile jar = new JarFile(jarFile);
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                classNames.add(jarEntry.getName());
            }
        }
        finally {
            jar.close();
        }
        return new ClassResolver(){

            @Override
            public InputStream getClassResource(String internalClassName) throws IOException {
                String resourceName = internalClassName + ".class";
                if (classNames.contains(resourceName)) {
                    final JarFile jar = new JarFile(jarFile);
                    JarEntry entry = jar.getJarEntry(resourceName);
                    return new BufferedInputStream(jar.getInputStream(entry)){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            jar.close();
                        }
                    };
                }
                return null;
            }

            public String toString() {
                return jarFile.getAbsolutePath();
            }
        };
    }

    public static ClassResolver getClassLoaderResolver(final ClassLoader classLoader) {
        return new ClassResolver(){

            @Override
            public InputStream getClassResource(String internalClassName) throws IOException {
                URL resource = Utils.getClassResource(classLoader, internalClassName);
                return resource == null ? null : resource.openStream();
            }
        };
    }

    public static ClassResolver getMultiResolver(final ClassResolver ... resolvers) {
        return new ClassResolver(){

            @Override
            public InputStream getClassResource(String internalClassName) throws IOException {
                for (ClassResolver resolver : resolvers) {
                    InputStream classResource = resolver.getClassResource(internalClassName);
                    if (classResource == null) continue;
                    return classResource;
                }
                return null;
            }
        };
    }

    public static ClassResolver getMultiResolver(final Collection<ClassResolver> resolvers) {
        return new ClassResolver(){

            @Override
            public InputStream getClassResource(String internalClassName) throws IOException {
                for (ClassResolver resolver : resolvers) {
                    InputStream classResource = resolver.getClassResource(internalClassName);
                    if (classResource == null) continue;
                    return classResource;
                }
                return null;
            }
        };
    }
}

