/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.bootstrap.EmbeddedJarFilesImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class BootstrapLoader {
    public static final String AGENT_BRIDGE_JAR_NAME = "agent-bridge";
    public static final String AGENT_BRIDGE_DATASTORE_JAR_NAME = "agent-bridge-datastore";
    private static final String NEWRELIC_TEMPDIR = "newrelic.tempdir";
    public static final String API_JAR_NAME = "newrelic-api";
    public static final String WEAVER_API_JAR_NAME = "newrelic-weaver-api";
    public static final String OPEN_TRACING_API_JAR_NAME = "newrelic-opentracing-api";
    private static final String NEWRELIC_API_INTERNAL_CLASS_NAME = "com/newrelic/api/agent/NewRelic";

    private static void addBridgeJarToClassPath(Instrumentation instrProxy, String jar) throws ClassNotFoundException, IOException {
        JarFile jarFileInAgent = new JarFile(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(jar));
        BootstrapLoader.addJarToClassPath(instrProxy, jarFileInAgent);
    }

    public static void forceCorrectNewRelicApi(Instrumentation instrProxy) throws IOException {
        JarFile bridgeJarFile = new JarFile(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(AGENT_BRIDGE_JAR_NAME));
        JarEntry jarEntry = bridgeJarFile.getJarEntry("com/newrelic/api/agent/NewRelic.class");
        byte[] bytes = BootstrapLoader.read(bridgeJarFile.getInputStream(jarEntry), true);
        instrProxy.addTransformer(new ApiClassTransformer(bytes), true);
    }

    private static void addJarToClassPath(Instrumentation instrProxy, JarFile jarfile) {
        instrProxy.appendToBootstrapClassLoaderSearch(jarfile);
    }

    public static URL getDatastoreJarURL() throws ClassNotFoundException, IOException {
        File jarFileInAgent = EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(AGENT_BRIDGE_DATASTORE_JAR_NAME);
        return jarFileInAgent.toURI().toURL();
    }

    public static Collection<URL> getJarURLs() throws ClassNotFoundException, IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String name : new String[]{AGENT_BRIDGE_JAR_NAME, AGENT_BRIDGE_DATASTORE_JAR_NAME, API_JAR_NAME, WEAVER_API_JAR_NAME, OPEN_TRACING_API_JAR_NAME}) {
            File jarFileInAgent = EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(name);
            urls.add(jarFileInAgent.toURI().toURL());
        }
        return urls;
    }

    static void load(Instrumentation inst) {
        try {
            String javaSpecVersion = JavaVersionUtils.getJavaSpecificationVersion();
            if (!javaSpecVersion.startsWith("9")) {
                BootstrapLoader.addBridgeJarToClassPath(inst, AGENT_BRIDGE_DATASTORE_JAR_NAME);
            }
            BootstrapLoader.addBridgeJarToClassPath(inst, AGENT_BRIDGE_JAR_NAME);
            BootstrapLoader.addJarToClassPath(inst, new JarFile(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(API_JAR_NAME)));
            BootstrapLoader.addJarToClassPath(inst, new JarFile(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(WEAVER_API_JAR_NAME)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadOpenTracingJar(Instrumentation inst) {
        try {
            BootstrapLoader.addJarToClassPath(inst, new JarFile(EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent(OPEN_TRACING_API_JAR_NAME)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                input.close();
                output.close();
            }
        }
    }

    static byte[] read(InputStream input, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BootstrapLoader.copy(input, outStream, input.available(), closeInputStream);
        return outStream.toByteArray();
    }

    public static File getTempDir() {
        String tempDir = System.getProperty(NEWRELIC_TEMPDIR);
        if (null != tempDir) {
            File tempDirFile = new File(tempDir);
            if (tempDirFile.exists()) {
                return tempDirFile;
            }
            System.err.println("Temp directory specified by newrelic.tempdir does not exist - " + tempDir);
        }
        return null;
    }

    static final class ApiClassTransformer
    implements ClassFileTransformer {
        private final byte[] bytes;

        ApiClassTransformer(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (className == null) {
                return null;
            }
            if (BootstrapLoader.NEWRELIC_API_INTERNAL_CLASS_NAME.equals(className)) {
                return this.bytes;
            }
            return null;
        }
    }
}

