/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.bridge.datastore.RecordSql;
import com.newrelic.agent.database.DefaultExplainPlanExecutor;
import com.newrelic.agent.tracers.SqlTracerExplainInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PreparedStatementExplainPlanExecutor
extends DefaultExplainPlanExecutor {
    private final Object[] sqlParameters;

    public PreparedStatementExplainPlanExecutor(SqlTracerExplainInfo tracer, String originalSqlStatement, Object[] sqlParameters, RecordSql recordSql) {
        super(tracer, originalSqlStatement, recordSql);
        this.sqlParameters = sqlParameters;
    }

    @Override
    protected Statement createStatement(Connection connection, String sql) throws SQLException {
        return connection.prepareStatement(sql);
    }

    @Override
    protected ResultSet executeStatement(Statement statement, String sql) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        this.setSqlParameters(preparedStatement);
        return preparedStatement.executeQuery();
    }

    private void setSqlParameters(PreparedStatement preparedStatement) throws SQLException {
        if (null == this.sqlParameters) {
            return;
        }
        int length = 0;
        for (Object sqlParameter : this.sqlParameters) {
            if (sqlParameter == null) break;
            ++length;
        }
        try {
            for (int i = 0; i < length; ++i) {
                preparedStatement.setObject(i + 1, this.sqlParameters[i]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

