/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.environment;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.management.ManagementFactory;

public class EnvironmentServiceImpl
extends AbstractService
implements EnvironmentService {
    private final int processPID = this.initProcessPID();
    private final Environment environment;

    public EnvironmentServiceImpl() {
        super(EnvironmentService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.environment = this.initEnvironment(config);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getProcessPID() {
        return this.processPID;
    }

    private int initProcessPID() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = runtimeName.split("@");
        if (split.length > 1) {
            return Integer.parseInt(split[0]);
        }
        return 0;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    private Environment initEnvironment(AgentConfig config) {
        String logFilePath = AgentLogManager.getLogFilePath();
        if (logFilePath == null) {
            logFilePath = "";
        }
        return new Environment(config, logFilePath);
    }
}

