/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.preprocessors;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.bridge.datastore.QueryConverter;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.bridge.external.ExternalParametersFactory;
import com.newrelic.agent.bridge.reflect.ClassReflection;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Handle;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.ClassRemapper;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Remapper;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.tracing.Annotation;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.instrumentation.weaver.preprocessors.ReflectionHelper;
import com.newrelic.agent.instrumentation.weaver.preprocessors.TracedWeaveInstrumentationTracker;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.Trace;
import com.newrelic.api.agent.weaver.CatchAndLog;
import com.newrelic.api.agent.weaver.SkipIfPresent;
import com.newrelic.api.agent.weaver.Weave;
import com.newrelic.api.agent.weaver.WeaveWithAnnotation;
import com.newrelic.weave.UtilityClass;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePreprocessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class AgentPreprocessors
implements WeavePreprocessor {
    private static final Type EXTERNAL_PARAMETERS_FACTORY_TYPE = Type.getType(ExternalParametersFactory.class);
    private static final Type DATASTORE_PARAMETERS_SLOW_QUERY_TYPE = Type.getType(DatastoreParameters.SlowQueryParameter.class);
    private static final Type DATASTORE_PARAMETERS_SLOW_QUERY_INPUT_TYPE = Type.getType(DatastoreParameters.SlowQueryWithInputParameter.class);
    private static final Method createForDatastoreMethod = new Method("createForDatastore", Type.getType(ExternalParameters.class), new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Integer.class)});
    private static final Method createForDatastoreSlowQueryMethod = new Method("createForDatastore", Type.getType(ExternalParameters.class), new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Integer.class), Type.getType(Object.class), Type.getType(QueryConverter.class)});
    private static final Method createForDatastoreSlowQueryInputMethod = new Method("createForDatastore", Type.getType(ExternalParameters.class), new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Integer.class), Type.getType(Object.class), Type.getType(QueryConverter.class), Type.getType(String.class), Type.getType(Object.class), Type.getType(QueryConverter.class)});
    private static final Method createForDatastoreSlowQueryBuilderMethod = new Method("slowQuery", Type.getType(DatastoreParameters.SlowQueryWithInputParameter.class), new Type[]{Type.getType(Object.class), Type.getType(com.newrelic.api.agent.QueryConverter.class)});
    private static final Method noSlowQueryBuilderMethod = new Method("noSlowQuery", Type.getType(DatastoreParameters.SlowQueryWithInputParameter.class), new Type[0]);
    private static final Method createForDatastoreSlowQueryInputBuilderMethod = new Method("slowQueryWithInput", Type.getType(DatastoreParameters.Build.class), new Type[]{Type.getType(String.class), Type.getType(Object.class), Type.getType(com.newrelic.api.agent.QueryConverter.class)});
    private static final String CATCH_AND_LOG_DESC = Type.getDescriptor(CatchAndLog.class);
    private String weavePackageName = "Unknown";
    private ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> tracedWeaveInstrumentationDetails;
    private final boolean captureSqlQueries;
    private final Set<String> collectSlowQueriesFromModules;

    public AgentPreprocessors(AgentConfig agentConfig, ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> tracedWeaveInstrumentationDetails) {
        this.tracedWeaveInstrumentationDetails = tracedWeaveInstrumentationDetails;
        this.captureSqlQueries = !agentConfig.isHighSecurity() && !agentConfig.laspEnabled();
        this.collectSlowQueriesFromModules = agentConfig.getTransactionTracerConfig().getCollectSlowQueriesFromModules();
    }

    public static AgentPreprocessors createWithInstrumentationTitle(AgentConfig agentConfig, String instrumentationTitle) {
        AgentPreprocessors result = new AgentPreprocessors(agentConfig, new ConcurrentHashMap<String, Set<TracedWeaveInstrumentationTracker>>());
        result.setInstrumentationTitle(instrumentationTitle);
        return result;
    }

    public void setInstrumentationTitle(String instrumentationTitle) {
        this.weavePackageName = instrumentationTitle;
    }

    public ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> getTracedWeaveInstrumentationDetails() {
        return this.tracedWeaveInstrumentationDetails;
    }

    @Override
    public ClassVisitor preprocess(ClassVisitor cv, Set<String> utilityClassesInternalNames, WeavePackage weavePackage) {
        if (System.getSecurityManager() != null) {
            cv = AgentPreprocessors.handleElevatePermissions(cv);
        }
        cv = this.handleCatchAndLog(cv);
        cv = this.gatherTraceInfo(cv);
        cv = this.markUtilityClasses(cv);
        cv = this.rewriteSlowQueryIfRequired(cv);
        cv = this.nullOutTokenAfterExpire(cv);
        cv = this.instrumentationPackageRemapper(cv, utilityClassesInternalNames);
        return cv;
    }

    private ClassVisitor handleCatchAndLog(ClassVisitor cv) {
        return new ClassVisitor(589824, cv){
            String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new AdviceAdapter(589824, mv, access, name, desc){
                    boolean isCatchAndLog;
                    Label start;
                    Label end;
                    Label handler;
                    {
                        super(x0, x1, x2, x3, x4);
                        this.start = this.newLabel();
                        this.end = this.newLabel();
                        this.handler = this.newLabel();
                    }

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                        AnnotationVisitor av = super.visitAnnotation(desc2, visible);
                        this.isCatchAndLog = this.isCatchAndLog || desc2.equals(CATCH_AND_LOG_DESC);
                        return av;
                    }

                    @Override
                    protected void onMethodEnter() {
                        super.onMethodEnter();
                        if (!this.isCatchAndLog) {
                            return;
                        }
                        this.visitLabel(this.start);
                    }

                    @Override
                    public void visitMaxs(int maxStack, int maxLocals) {
                        if (!this.isCatchAndLog) {
                            super.visitMaxs(maxStack, maxLocals);
                            return;
                        }
                        super.visitLabel(this.handler);
                        final int throwableLocal = this.newLocal(Type.getType(Throwable.class));
                        this.storeLocal(throwableLocal);
                        Runnable throwableMessage = new Runnable(){

                            @Override
                            public void run() {
                                this.loadLocal(throwableLocal);
                            }
                        };
                        BridgeUtils.getLogger(this).logToChild(AgentPreprocessors.this.weavePackageName, Level.FINE, "{0}.{1}{2} threw an exception: {3}", (Object)className, (Object)name, (Object)desc, (Object)throwableMessage);
                        BridgeUtils.loadLogger(this);
                        this.getStatic(Type.getType(Level.class), Level.FINEST.getName(), Type.getType(Level.class));
                        this.loadLocal(throwableLocal);
                        this.push("Exception stack:");
                        BridgeUtils.getLoggerBuilder(this, false).build().log(Level.FINEST, (Throwable)null, null);
                        this.visitInsn(177);
                        super.visitLabel(this.end);
                        super.visitTryCatchBlock(this.start, this.end, this.handler, Type.getInternalName(Throwable.class));
                        super.visitMaxs(maxStack, maxLocals);
                    }
                };
            }
        };
    }

    static ClassVisitor handleElevatePermissions(ClassVisitor cv) {
        return new ClassVisitor(589824, cv){
            private final ReflectionHelper reflection = ReflectionHelper.get();
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                if (version < 50) {
                    version = 50;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                return new GeneratorAdapter(589824, mv, access, methodName, methodDesc){

                    @Override
                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof Type && !className.equals(((Type)cst).getInternalName())) {
                            this.loadClass((Type)cst);
                        } else {
                            super.visitLdcInsn(cst);
                        }
                    }

                    private void loadClass(Type typeToLoad) {
                        super.visitLdcInsn(Type.getObjectType(className));
                        super.invokeStatic(Type.getType(ClassReflection.class), new Method("getClassLoader", "(Ljava/lang/Class;)Ljava/lang/ClassLoader;"));
                        this.push(typeToLoad.getClassName());
                        super.invokeStatic(Type.getType(ClassReflection.class), new Method("loadClass", "(Ljava/lang/ClassLoader;Ljava/lang/String;)Ljava/lang/Class;"));
                    }

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        Type objectType = Type.getObjectType(type);
                        if (193 == opcode) {
                            this.loadClass(objectType);
                            super.swap();
                            super.invokeVirtual(Type.getType(Class.class), new Method("isInstance", "(Ljava/lang/Object;)Z"));
                        } else {
                            super.visitTypeInsn(opcode, type);
                        }
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (reflection.process(owner, name, desc, this)) {
                            return;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                };
            }
        };
    }

    ClassVisitor gatherTraceInfo(ClassVisitor cv) {
        Set initial = Sets.newConcurrentHashSet();
        this.tracedWeaveInstrumentationDetails.putIfAbsent(this.weavePackageName, initial);
        return new ClassVisitor(589824, cv){
            private boolean isWeave;
            private boolean isWeaveWithAnnotation;
            private String originalName;
            {
                this.isWeave = false;
                this.isWeaveWithAnnotation = false;
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.originalName = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (Type.getDescriptor(Weave.class).equals(desc)) {
                    this.isWeave = true;
                    return new AnnotationVisitor(589824, av){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("originalName")) {
                                originalName = ((String)value).replace('.', '/');
                            }
                            super.visit(name, value);
                        }
                    };
                }
                if (Type.getDescriptor(WeaveWithAnnotation.class).equals(desc)) {
                    this.isWeaveWithAnnotation = true;
                }
                return av;
            }

            @Override
            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                return new MethodVisitor(589824, mv){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        AnnotationVisitor av = super.visitAnnotation(desc, visible);
                        if (Type.getDescriptor(Trace.class).equals(desc)) {
                            Agent.LOG.log(Level.FINER, "Storing TracedWeaveInstrumentation: {0} - {1}.{2}({3})", AgentPreprocessors.this.weavePackageName, originalName, methodName, methodDesc);
                            TraceDetailsBuilder builder = TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.TracedWeaveInstrumentation).setInstrumentationSourceName(AgentPreprocessors.this.weavePackageName);
                            av = new Annotation(av, desc, builder){

                                @Override
                                public void visitEnd() {
                                    ((Set)AgentPreprocessors.this.tracedWeaveInstrumentationDetails.get(AgentPreprocessors.this.weavePackageName)).add(new TracedWeaveInstrumentationTracker(AgentPreprocessors.this.weavePackageName, originalName, new Method(methodName, methodDesc), isWeaveWithAnnotation, this.getTraceDetails(false)));
                                    super.visitEnd();
                                }
                            };
                        }
                        return av;
                    }
                };
            }
        };
    }

    ClassVisitor markUtilityClasses(ClassVisitor cv) {
        return new ClassVisitor(589824, cv){
            private boolean isUtilityClass;
            {
                this.isUtilityClass = true;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (Type.getDescriptor(Weave.class).equals(desc) || Type.getDescriptor(SkipIfPresent.class).equals(desc) || Type.getDescriptor(WeaveWithAnnotation.class).equals(desc)) {
                    this.isUtilityClass = false;
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public void visitEnd() {
                if (this.isUtilityClass) {
                    this.addUtilityClassAnnotation(this.cv);
                }
                super.visitEnd();
            }

            private ClassVisitor addUtilityClassAnnotation(ClassVisitor cv) {
                AnnotationVisitor av = cv.visitAnnotation(Type.getDescriptor(UtilityClass.class), true);
                av.visit("weavePackageName", AgentPreprocessors.this.weavePackageName);
                av.visitEnd();
                return cv;
            }
        };
    }

    ClassVisitor rewriteSlowQueryIfRequired(ClassVisitor cv) {
        if (this.captureSqlQueries) {
            return cv;
        }
        if (this.collectSlowQueriesFromModules.contains(this.weavePackageName)) {
            return cv;
        }
        return new ClassVisitor(589824, cv){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                return new GeneratorAdapter(589824, mv, access, methodName, methodDesc){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (AgentPreprocessors.isDatastoreSlowQueryBuilderMethod(owner, name, desc)) {
                            this.pop2();
                            super.visitMethodInsn(opcode, owner, noSlowQueryBuilderMethod.getName(), noSlowQueryBuilderMethod.getDescriptor(), itf);
                        } else if (AgentPreprocessors.isDatastoreSlowQueryInputBuilderMethod(owner, name, desc)) {
                            this.pop2();
                            this.pop();
                        } else if (AgentPreprocessors.isDatastoreSlowQueryMethod(owner, name, desc)) {
                            this.pop2();
                            super.visitMethodInsn(opcode, owner, name, createForDatastoreMethod.getDescriptor(), itf);
                        } else if (AgentPreprocessors.isDatastoreSlowQueryInputMethod(owner, name, desc)) {
                            this.pop2();
                            this.pop2();
                            this.pop();
                            super.visitMethodInsn(opcode, owner, name, createForDatastoreMethod.getDescriptor(), itf);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    }
                };
            }
        };
    }

    private static boolean isDatastoreSlowQueryMethod(String owner, String name, String desc) {
        return owner.equals(EXTERNAL_PARAMETERS_FACTORY_TYPE.getInternalName()) && name.equals(createForDatastoreSlowQueryMethod.getName()) && desc.equals(createForDatastoreSlowQueryMethod.getDescriptor());
    }

    private static boolean isDatastoreSlowQueryInputMethod(String owner, String name, String desc) {
        return owner.equals(EXTERNAL_PARAMETERS_FACTORY_TYPE.getInternalName()) && name.equals(createForDatastoreSlowQueryInputMethod.getName()) && desc.equals(createForDatastoreSlowQueryInputMethod.getDescriptor());
    }

    private static boolean isDatastoreSlowQueryBuilderMethod(String owner, String name, String desc) {
        return owner.equals(DATASTORE_PARAMETERS_SLOW_QUERY_TYPE.getInternalName()) && name.equals(createForDatastoreSlowQueryBuilderMethod.getName()) && desc.equals(createForDatastoreSlowQueryBuilderMethod.getDescriptor());
    }

    private static boolean isDatastoreSlowQueryInputBuilderMethod(String owner, String name, String desc) {
        return owner.equals(DATASTORE_PARAMETERS_SLOW_QUERY_INPUT_TYPE.getInternalName()) && name.equals(createForDatastoreSlowQueryInputBuilderMethod.getName()) && desc.equals(createForDatastoreSlowQueryInputBuilderMethod.getDescriptor());
    }

    TokenNullCheckClassVisitor nullOutTokenAfterExpire(ClassVisitor cv) {
        return new TokenNullCheckClassVisitor(589824, cv);
    }

    ClassVisitor instrumentationPackageRemapper(ClassVisitor cv, Set<String> utilityClasses) {
        return new InstrumentationPackageNameRewriter(589824, cv, utilityClasses);
    }

    public class InstrumentationPackageNameRewriter
    extends ClassRemapper {
        public InstrumentationPackageNameRewriter(int api, ClassVisitor cv, Set<String> utilityClasses) {
            super(api, cv, new InstrumentationPackageRemapper(AgentPreprocessors.this.weavePackageName, utilityClasses));
        }
    }

    public static class InstrumentationPackageRemapper
    extends Remapper {
        final Set<String> conflictingUtilityClasses = new HashSet<String>();

        public InstrumentationPackageRemapper(String weavePackageName, Set<String> utilityClasses) {
            for (String utilityClass : utilityClasses) {
                if (!utilityClass.startsWith("com/newrelic/agent/")) continue;
                String renameTo = utilityClass.replaceFirst("^com/newrelic/agent", "com/nr/instrumentation");
                if (utilityClass.contains(renameTo)) {
                    AgentBridge.getAgent().getLogger().log(Level.INFO, "Failed to remap reference for weave module {0}: {1} already exists.", (Object)weavePackageName, (Object)renameTo);
                    this.conflictingUtilityClasses.clear();
                    break;
                }
                this.conflictingUtilityClasses.add(utilityClass);
            }
        }

        @Override
        public String map(String typeName) {
            if (this.conflictingUtilityClasses.contains(typeName)) {
                String newTypeName = typeName.replaceFirst("^com/newrelic/agent", "com/nr/instrumentation");
                AgentBridge.getAgent().getLogger().log(Level.FINE, "Weave package class uses the agents package namespace. Consider changing this. Remapping reference from {0} to {1}", (Object)typeName, (Object)newTypeName);
                return newTypeName;
            }
            return super.map(typeName);
        }
    }

    private static class TokenNullCheckMethodVisitor
    extends MethodVisitor {
        private static final Type API_TOKEN_TYPE = Type.getType(com.newrelic.api.agent.Token.class);
        private static final Type BRIDGE_TOKEN_TYPE = Type.getType(Token.class);
        private static final Set<String> TOKEN_EXPIRE_METHODS = Sets.newHashSet("expire", "linkAndExpire");
        private final String packageName;
        private final String className;
        private final String methodName;
        private State state = State.INIT;
        private String lastGetOwner;
        private String lastGetName;
        private int lastGetVarSlot;
        private int lastLineNumber = 0;
        private int expireLineNumber = 0;
        public int numNullOpsAdded = 0;

        public TokenNullCheckMethodVisitor(int api, MethodVisitor mv, String packageName, String className, String methodName) {
            super(api, mv);
            this.packageName = packageName;
            this.className = className;
            this.methodName = methodName;
        }

        private void checkState() {
            if (this.state == State.EXPIRE_TOKEN || this.state == State.POP_TOKEN_EXP_RES || this.state == State.PUSH_FIELD_OWNER_FOR_PUT || this.state == State.PUSH_NULL_FOR_PUT) {
                String msg = MessageFormat.format("WARNING: Instrumentation {0}-{1}.{2}{3}: token newfield expired but not set to null. To prevent high GC churn the agent has inserted bytecode to null out this field.  This may cause NPEs in the instrumentation code. To avoid this, explicitly null the NewField after calling expire().", this.packageName, this.className, this.methodName, 0 == this.expireLineNumber ? "" : ":" + this.expireLineNumber);
                AgentBridge.getAgent().getLogger().log(Level.FINE, msg);
                this.state = State.INIT;
                this.visitVarInsn(25, this.lastGetVarSlot);
                this.visitInsn(1);
                this.visitFieldInsn(181, this.lastGetOwner, this.lastGetName, API_TOKEN_TYPE.getDescriptor());
                ++this.numNullOpsAdded;
            }
            this.state = State.INIT;
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack + this.numNullOpsAdded * 2, maxLocals);
        }

        @Override
        public void visitInsn(int opcode) {
            if (87 == opcode && this.state == State.EXPIRE_TOKEN) {
                this.state = State.POP_TOKEN_EXP_RES;
            } else if (1 == opcode && this.state == State.PUSH_FIELD_OWNER_FOR_PUT) {
                this.state = State.PUSH_NULL_FOR_PUT;
            } else {
                this.checkState();
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (API_TOKEN_TYPE.getDescriptor().equals(desc) || BRIDGE_TOKEN_TYPE.getDescriptor().equals(desc)) {
                if (180 == opcode && this.state == State.PUSH_FIELD_OWNER_FOR_GET) {
                    this.state = State.GETFIELD_TOKEN;
                    this.lastGetOwner = owner;
                    this.lastGetName = name;
                } else if (181 == opcode && this.state == State.PUSH_NULL_FOR_PUT && owner.equals(this.lastGetOwner) && name.equals(this.lastGetName)) {
                    this.state = State.INIT;
                } else {
                    this.checkState();
                }
            } else {
                this.checkState();
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.state == State.GETFIELD_TOKEN && (API_TOKEN_TYPE.getInternalName().equals(owner) || BRIDGE_TOKEN_TYPE.getInternalName().equals(owner)) && TOKEN_EXPIRE_METHODS.contains(name)) {
                this.expireLineNumber = this.lastLineNumber;
                this.state = State.EXPIRE_TOKEN;
            } else {
                this.checkState();
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (this.state == State.INIT && 25 == opcode) {
                this.state = State.PUSH_FIELD_OWNER_FOR_GET;
                this.lastGetVarSlot = var;
            } else if (this.state == State.POP_TOKEN_EXP_RES && 25 == opcode && var == this.lastGetVarSlot) {
                this.state = State.PUSH_FIELD_OWNER_FOR_PUT;
            } else {
                this.checkState();
            }
            super.visitVarInsn(opcode, var);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.lastLineNumber = line;
            super.visitLineNumber(line, start);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            this.checkState();
            super.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            this.checkState();
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.checkState();
            super.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            this.checkState();
            super.visitTypeInsn(opcode, type);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.checkState();
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            this.checkState();
            super.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.checkState();
            super.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min2, int max, Label dflt, Label ... labels) {
            this.checkState();
            super.visitTableSwitchInsn(min2, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
            this.checkState();
            super.visitLookupSwitchInsn(dflt, keys2, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.checkState();
            super.visitMultiANewArrayInsn(desc, dims);
        }

        private static enum State {
            INIT,
            PUSH_FIELD_OWNER_FOR_GET,
            GETFIELD_TOKEN,
            EXPIRE_TOKEN,
            POP_TOKEN_EXP_RES,
            PUSH_FIELD_OWNER_FOR_PUT,
            PUSH_NULL_FOR_PUT;

        }
    }

    public class TokenNullCheckClassVisitor
    extends ClassVisitor {
        private String className;
        private List<TokenNullCheckMethodVisitor> methodVisitors;

        public TokenNullCheckClassVisitor(int api, ClassVisitor cv) {
            super(api, cv);
            this.methodVisitors = new ArrayList<TokenNullCheckMethodVisitor>();
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            TokenNullCheckMethodVisitor tmv = new TokenNullCheckMethodVisitor(589824, mv, AgentPreprocessors.this.weavePackageName, this.className, name);
            this.methodVisitors.add(tmv);
            return tmv;
        }

        public Map<String, Integer> getExpireRewriteCounts() {
            HashMap<String, Integer> counts = new HashMap<String, Integer>(this.methodVisitors.size());
            for (TokenNullCheckMethodVisitor mv : this.methodVisitors) {
                counts.put(mv.methodName, mv.numNullOpsAdded);
            }
            return counts;
        }
    }
}

