/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.deps.org.apache.logging.log4j.Marker;
import com.newrelic.agent.logging.Log4jMarkers;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

final class Log4jLevel
extends Enum<Log4jLevel> {
    public static final /* enum */ Log4jLevel OFF;
    public static final /* enum */ Log4jLevel ALL;
    public static final /* enum */ Log4jLevel FATAL;
    public static final /* enum */ Log4jLevel SEVERE;
    public static final /* enum */ Log4jLevel ERROR;
    public static final /* enum */ Log4jLevel WARN;
    public static final /* enum */ Log4jLevel WARNING;
    public static final /* enum */ Log4jLevel INFO;
    public static final /* enum */ Log4jLevel CONFIG;
    public static final /* enum */ Log4jLevel FINE;
    public static final /* enum */ Log4jLevel FINER;
    public static final /* enum */ Log4jLevel FINEST;
    public static final /* enum */ Log4jLevel DEBUG;
    public static final /* enum */ Log4jLevel TRACE;
    private final String name;
    private final com.newrelic.agent.deps.org.apache.logging.log4j.Level log4jLevel;
    private final Level javaLevel;
    private final Marker marker;
    private static final Map<String, Log4jLevel> CONVERSION;
    private static final Map<Level, Log4jLevel> JAVA_TO_LOG4J;
    private static final /* synthetic */ Log4jLevel[] $VALUES;

    public static Log4jLevel[] values() {
        return (Log4jLevel[])$VALUES.clone();
    }

    public static Log4jLevel valueOf(String name) {
        return Enum.valueOf(Log4jLevel.class, name);
    }

    private Log4jLevel(String pName, com.newrelic.agent.deps.org.apache.logging.log4j.Level pLog4jLevel, Level pJavaLevel, Marker pMarker) {
        this.name = pName;
        this.log4jLevel = pLog4jLevel;
        this.javaLevel = pJavaLevel;
        this.marker = pMarker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public com.newrelic.agent.deps.org.apache.logging.log4j.Level getLog4jLevel() {
        return this.log4jLevel;
    }

    public Level getJavaLevel() {
        return this.javaLevel;
    }

    public static Log4jLevel getLevel(String pName, Log4jLevel pDefault) {
        Log4jLevel level = CONVERSION.get(pName);
        return level == null ? pDefault : level;
    }

    public static Log4jLevel getLevel(Level pName) {
        return JAVA_TO_LOG4J.get(pName);
    }

    static {
        Log4jLevel[] levels;
        OFF = new Log4jLevel("off", com.newrelic.agent.deps.org.apache.logging.log4j.Level.OFF, Level.OFF, null);
        ALL = new Log4jLevel("all", com.newrelic.agent.deps.org.apache.logging.log4j.Level.ALL, Level.ALL, null);
        FATAL = new Log4jLevel("fatal", com.newrelic.agent.deps.org.apache.logging.log4j.Level.ERROR, Level.SEVERE, Log4jMarkers.ERROR_MARKER);
        SEVERE = new Log4jLevel("severe", com.newrelic.agent.deps.org.apache.logging.log4j.Level.ERROR, Level.SEVERE, Log4jMarkers.ERROR_MARKER);
        ERROR = new Log4jLevel("error", com.newrelic.agent.deps.org.apache.logging.log4j.Level.ERROR, Level.SEVERE, Log4jMarkers.ERROR_MARKER);
        WARN = new Log4jLevel("warn", com.newrelic.agent.deps.org.apache.logging.log4j.Level.WARN, Level.WARNING, Log4jMarkers.WARN_MARKER);
        WARNING = new Log4jLevel("warning", com.newrelic.agent.deps.org.apache.logging.log4j.Level.WARN, Level.WARNING, Log4jMarkers.WARN_MARKER);
        INFO = new Log4jLevel("info", com.newrelic.agent.deps.org.apache.logging.log4j.Level.INFO, Level.INFO, Log4jMarkers.INFO_MARKER);
        CONFIG = new Log4jLevel("config", com.newrelic.agent.deps.org.apache.logging.log4j.Level.INFO, Level.CONFIG, Log4jMarkers.INFO_MARKER);
        FINE = new Log4jLevel("fine", com.newrelic.agent.deps.org.apache.logging.log4j.Level.DEBUG, Level.FINE, Log4jMarkers.FINE_MARKER);
        FINER = new Log4jLevel("finer", com.newrelic.agent.deps.org.apache.logging.log4j.Level.DEBUG, Level.FINER, Log4jMarkers.FINER_MARKER);
        FINEST = new Log4jLevel("finest", com.newrelic.agent.deps.org.apache.logging.log4j.Level.TRACE, Level.FINEST, Log4jMarkers.FINEST_MARKER);
        DEBUG = new Log4jLevel("debug", com.newrelic.agent.deps.org.apache.logging.log4j.Level.DEBUG, Level.FINE, Log4jMarkers.DEBUG_MARKER);
        TRACE = new Log4jLevel("trace", com.newrelic.agent.deps.org.apache.logging.log4j.Level.TRACE, Level.FINEST, Log4jMarkers.TRACE_MARKER);
        $VALUES = new Log4jLevel[]{OFF, ALL, FATAL, SEVERE, ERROR, WARN, WARNING, INFO, CONFIG, FINE, FINER, FINEST, DEBUG, TRACE};
        CONVERSION = new HashMap<String, Log4jLevel>();
        JAVA_TO_LOG4J = new HashMap<Level, Log4jLevel>();
        for (Log4jLevel level : levels = Log4jLevel.values()) {
            CONVERSION.put(level.name, level);
        }
        JAVA_TO_LOG4J.put(Level.ALL, ALL);
        JAVA_TO_LOG4J.put(Level.FINER, FINER);
        JAVA_TO_LOG4J.put(Level.FINEST, FINEST);
        JAVA_TO_LOG4J.put(Level.FINE, FINE);
        JAVA_TO_LOG4J.put(Level.WARNING, WARNING);
        JAVA_TO_LOG4J.put(Level.SEVERE, SEVERE);
        JAVA_TO_LOG4J.put(Level.CONFIG, CONFIG);
        JAVA_TO_LOG4J.put(Level.INFO, INFO);
        JAVA_TO_LOG4J.put(Level.OFF, OFF);
    }
}

