/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.interfaces.ReservoirManager;
import com.newrelic.agent.interfaces.SamplingPriorityQueue;
import com.newrelic.agent.model.SpanEvent;
import java.util.function.Consumer;

public class ReservoirAddingSpanEventConsumer
implements Consumer<SpanEvent> {
    private final ReservoirManager<SpanEvent> reservoirManager;
    private final ConfigService configService;

    public ReservoirAddingSpanEventConsumer(ReservoirManager<SpanEvent> reservoirManager, ConfigService configService) {
        this.reservoirManager = reservoirManager;
        this.configService = configService;
    }

    @Override
    public void accept(SpanEvent spanEvent) {
        if (this.isSpanEventsEnabled()) {
            String appName = spanEvent.getAppName();
            SamplingPriorityQueue<SpanEvent> reservoir = this.reservoirManager.getOrCreateReservoir(appName);
            reservoir.add(spanEvent);
        }
    }

    private boolean isSpanEventsEnabled() {
        SpanEventsConfig spanEventsConfig = this.configService.getDefaultAgentConfig().getSpanEventsConfig();
        return spanEventsConfig.isEnabled() && this.reservoirManager.getMaxSamplesStored() > 0;
    }
}

