/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.config.JarCollectorConfigImpl;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.module.JarCollectorService;
import com.newrelic.agent.service.module.JarData;
import com.newrelic.agent.service.module.TrackedAddSet;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.NewRelic;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class JarCollectorServiceImpl
extends AbstractService
implements JarCollectorService {
    private final Logger logger;
    private final boolean enabled;
    private final AtomicBoolean shouldSendAllJars;
    private final TrackedAddSet<JarData> analyzedJars;
    private final ClassMatchVisitorFactory classMatchVisitorFactory;
    private volatile List<JarData> jarsNotSentLastHarvest = Collections.emptyList();

    public JarCollectorServiceImpl(Logger logger, boolean enabled, AtomicBoolean shouldSendAllJars, TrackedAddSet<JarData> analyzedJars, ClassMatchVisitorFactory classNoticingFactory) {
        super(JarCollectorService.class.getSimpleName());
        this.shouldSendAllJars = shouldSendAllJars;
        this.analyzedJars = analyzedJars;
        this.logger = logger;
        this.classMatchVisitorFactory = classNoticingFactory;
        this.enabled = enabled;
        if (JarCollectorConfigImpl.isUsingDeprecatedConfigSettings()) {
            String deprecatedConfigMsg = "Jar Collector system properties prefixed with 'newrelic.config.module.' and environment variables prefixed with 'NEW_RELIC_MODULE_' are deprecated and will be removed in a future agent release. Instead use the 'newrelic.config.jar_collector.' and 'NEW_RELIC_JAR_COLLECTOR_' prefixes.";
            this.logger.log(Level.INFO, deprecatedConfigMsg);
            NewRelic.incrementCounter((String)"Supportability/Deprecated/Config/JarCollector");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public ClassMatchVisitorFactory getSourceVisitor() {
        return this.classMatchVisitorFactory;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public void harvest(String appName) {
        this.logger.log(Level.FINER, "Harvesting Modules");
        List<JarData> jarsToSend = this.getJars();
        if (!jarsToSend.isEmpty()) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendModules(jarsToSend);
                this.jarsNotSentLastHarvest = Collections.emptyList();
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, MessageFormat.format("Unable to send {0} jar(s). Will attempt next harvest.", jarsToSend.size()));
                this.jarsNotSentLastHarvest = jarsToSend;
            }
        }
    }

    private List<JarData> getJars() {
        if (this.shouldSendAllJars.getAndSet(false)) {
            return new ArrayList<JarData>(this.analyzedJars.resetReturningAll());
        }
        Set<JarData> newJarsToSend = this.analyzedJars.resetReturningAdded();
        if (newJarsToSend.isEmpty()) {
            return this.jarsNotSentLastHarvest;
        }
        ArrayList<JarData> jarData = new ArrayList<JarData>(newJarsToSend);
        jarData.addAll(this.jarsNotSentLastHarvest);
        return jarData;
    }
}

