/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.ForceRestartException;
import com.newrelic.agent.LicenseException;
import com.newrelic.agent.MaxPayloadException;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.DataSenderConfig;
import com.newrelic.agent.config.LaspPolicies;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.deps.org.json.simple.JSONValue;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.model.AnalyticsEvent;
import com.newrelic.agent.model.CustomInsightsEvent;
import com.newrelic.agent.model.ErrorEvent;
import com.newrelic.agent.model.LogEvent;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.profile.ProfileData;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderListener;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.transport.HttpClientWrapper;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.transport.InitialSizedJsonArray;
import com.newrelic.agent.transport.ReadResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.rmi.UnexpectedException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;

public class DataSenderImpl
implements DataSender {
    private static final String MODULE_TYPE = "Jars";
    private static final int PROTOCOL_VERSION = 17;
    private static final String PROTOCOL = "https";
    private static final String BEFORE_LICENSE_KEY_URI_PATTERN = "/agent_listener/invoke_raw_method?method={0}";
    private static final String AFTER_LICENSE_KEY_URI_PATTERN = "&marshal_format=json&protocol_version=";
    private static final String LICENSE_KEY_URI_PATTERN = "&license_key={0}";
    private static final String RUN_ID_PATTERN = "&run_id={1}";
    public static final String DEFLATE_ENCODING = "deflate";
    public static final String GZIP_ENCODING = "gzip";
    private static final String IDENTITY_ENCODING = "identity";
    private static final String EXCEPTION_MAP_RETURN_VALUE_KEY = "return_value";
    private static final Object NO_AGENT_RUN_ID = null;
    private static final String NULL_RESPONSE = "null";
    private static final int COMPRESSION_LEVEL = -1;
    private static final String REDIRECT_HOST = "redirect_host";
    private static final String SECURITY_POLICIES = "security_policies";
    private static final String MAX_PAYLOAD_SIZE_IN_BYTES = "max_payload_size_in_bytes";
    private static final String METADATA_PREFIX = "NEW_RELIC_METADATA_";
    private static final String ENV_METADATA = "metadata";
    private static final int DEFAULT_MAX_PAYLOAD_SIZE_IN_BYTES = 1000000;
    private static final String COLLECTOR = "Collector";
    private static final Set<String> METHODS_WITH_RESPONSE_BODY = ImmutableSet.of("preconnect", "connect", "get_agent_commands", "profile_data");
    private final HttpClientWrapper httpClientWrapper;
    private final String originalHost;
    private volatile String redirectHost;
    private final int port;
    private volatile boolean auditMode;
    private Set<String> auditModeEndpoints;
    private final IAgentLogger logger;
    private final ConfigService configService;
    private volatile Object agentRunId = NO_AGENT_RUN_ID;
    private final String agentRunIdUriPattern;
    private final String noAgentRunIdUriPattern;
    private final DataSenderListener dataSenderListener;
    private final String compressedEncoding;
    private final boolean putForDataSend;
    private Map<String, Boolean> policiesJson;
    private volatile int maxPayloadSizeInBytes = 1000000;
    private volatile Map<String, String> requestMetadata;
    private volatile Map<String, String> metadata;

    public DataSenderImpl(DataSenderConfig config, HttpClientWrapper httpClientWrapper, DataSenderListener dataSenderListener, IAgentLogger logger, ConfigService configService) {
        this.auditMode = config.isAuditMode();
        this.auditModeEndpoints = config.getAuditModeConfig().getEndpoints();
        this.logger = logger;
        this.configService = configService;
        logger.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        this.originalHost = config.getHost();
        this.redirectHost = config.getHost();
        this.port = config.getPort();
        String licenseKeyUri = MessageFormat.format(LICENSE_KEY_URI_PATTERN, config.getLicenseKey());
        this.noAgentRunIdUriPattern = BEFORE_LICENSE_KEY_URI_PATTERN + licenseKeyUri + AFTER_LICENSE_KEY_URI_PATTERN + 17;
        this.agentRunIdUriPattern = this.noAgentRunIdUriPattern + RUN_ID_PATTERN;
        this.dataSenderListener = dataSenderListener;
        this.compressedEncoding = config.getCompressedContentEncoding();
        this.putForDataSend = config.isPutForDataSend();
        this.metadata = new HashMap<String, String>();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().startsWith(METADATA_PREFIX)) continue;
            this.metadata.put(entry.getKey(), entry.getValue());
        }
        this.httpClientWrapper = httpClientWrapper;
    }

    private void checkAuditMode() {
        Set<String> auditModeEndpoints2;
        boolean auditMode2 = this.configService.getLocalAgentConfig().isAuditMode();
        if (this.auditMode != auditMode2) {
            this.auditMode = auditMode2;
            this.logger.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        }
        if (this.auditModeEndpoints != (auditModeEndpoints2 = this.configService.getLocalAgentConfig().getAuditModeConfig().getEndpoints())) {
            this.auditModeEndpoints = auditModeEndpoints2;
            this.logger.info(MessageFormat.format("Setting audit_mode.endpoints to {0}", this.auditModeEndpoints));
        }
    }

    @VisibleForTesting
    void setAgentRunId(Object runId) {
        this.agentRunId = runId;
        if (runId != NO_AGENT_RUN_ID) {
            this.logger.info("Agent run id: " + runId);
        }
    }

    @VisibleForTesting
    Object getAgentRunId() {
        return this.agentRunId;
    }

    @Override
    public Map<String, Object> connect(Map<String, Object> startupOptions) throws Exception {
        String redirectHost = this.parsePreconnectAndReturnHost();
        if (redirectHost != null) {
            this.redirectHost = redirectHost;
            this.logger.info(MessageFormat.format("Collector redirection to {0}:{1}", this.redirectHost, Integer.toString(this.port)));
        } else if (this.configService.getDefaultAgentConfig().laspEnabled()) {
            throw new ForceDisconnectException("The agent did not receive one or more security policies that it expected and will shut down. Please contact support.");
        }
        return this.doConnect(startupOptions);
    }

    private String parsePreconnectAndReturnHost() throws Exception {
        AgentConfig agentConfig = this.configService.getDefaultAgentConfig();
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        JSONObject token = new JSONObject();
        if (agentConfig.laspEnabled()) {
            token.put("security_policies_token", agentConfig.securityPoliciesToken());
        }
        token.put("high_security", agentConfig.isHighSecurity());
        params.add(token);
        Object response = this.invokeNoRunId(this.originalHost, "preconnect", this.compressedEncoding, params);
        if (response != null) {
            Map returnValue = (Map)response;
            String host = returnValue.get(REDIRECT_HOST).toString();
            JSONObject policies = (JSONObject)returnValue.get(SECURITY_POLICIES);
            this.policiesJson = LaspPolicies.validatePolicies(policies);
            return host;
        }
        return null;
    }

    private Map<String, Object> doConnect(Map<String, Object> startupOptions) throws Exception {
        Object maxPayloadSize;
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        if (this.policiesJson != null && !this.policiesJson.isEmpty()) {
            startupOptions.put(SECURITY_POLICIES, LaspPolicies.convertToConnectPayload(this.policiesJson));
        }
        startupOptions.put(ENV_METADATA, this.metadata);
        params.add(startupOptions);
        Object response = this.invokeNoRunId(this.redirectHost, "connect", this.compressedEncoding, params);
        if (!(response instanceof Map)) {
            throw new UnexpectedException(MessageFormat.format("Expected a map of connection data, got {0}", response));
        }
        Map data = (Map)response;
        if (data.containsKey(MAX_PAYLOAD_SIZE_IN_BYTES) && (maxPayloadSize = data.get(MAX_PAYLOAD_SIZE_IN_BYTES)) instanceof Number) {
            this.maxPayloadSizeInBytes = ((Number)maxPayloadSize).intValue();
            this.logger.log(Level.INFO, "Max payload size is {0} bytes", this.maxPayloadSizeInBytes);
        }
        if (data.containsKey("request_headers_map")) {
            Object requestMetadata = data.get("request_headers_map");
            if (requestMetadata instanceof Map) {
                this.requestMetadata = (Map)requestMetadata;
            } else {
                this.logger.log(Level.WARNING, "Expected a map but got {0}. Not setting requestMetadata", requestMetadata);
            }
        } else {
            this.logger.log(Level.WARNING, "Did not receive requestMetadata on connect");
        }
        if (!data.containsKey("agent_run_id")) {
            throw new UnexpectedException(MessageFormat.format("Missing {0} connection parameter", "agent_run_id"));
        }
        Object runId = data.get("agent_run_id");
        this.setAgentRunId(runId);
        this.configService.setLaspPolicies(this.policiesJson);
        return data;
    }

    @Override
    public List<List<?>> getAgentCommands() throws Exception {
        this.checkAuditMode();
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID) {
            return Collections.emptyList();
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        params.add(runId);
        Object response = this.invokeRunId("get_agent_commands", this.compressedEncoding, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            this.logger.warning(MessageFormat.format("Invalid response from New Relic when getting agent commands: {0}", e));
            throw e;
        }
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || commandResults.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(commandResults);
        this.invokeRunId("agent_command_results", this.compressedEncoding, runId, params);
    }

    @Override
    public void sendErrorData(List<TracedError> errors) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || errors.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(errors);
        this.invokeRunId("error_data", this.compressedEncoding, runId, params);
    }

    @Override
    public void sendErrorEvents(int reservoirSize, int eventsSeen, Collection<ErrorEvent> errorEvents) throws Exception {
        this.sendAnalyticEventsForReservoir("error_event_data", this.compressedEncoding, reservoirSize, eventsSeen, errorEvents);
    }

    @Override
    public <T extends AnalyticsEvent> void sendAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<T> events) throws Exception {
        this.sendAnalyticEventsForReservoir("analytic_event_data", this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    @Override
    public void sendCustomAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<? extends CustomInsightsEvent> events) throws Exception {
        this.sendAnalyticEventsForReservoir("custom_event_data", this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    @Override
    public void sendLogEvents(Collection<? extends LogEvent> events) throws Exception {
        this.sendLogEventsForReservoir("log_event_data", this.compressedEncoding, events);
    }

    @Override
    public void sendSpanEvents(int reservoirSize, int eventsSeen, Collection<SpanEvent> events) throws Exception {
        this.sendAnalyticEventsForReservoir("span_event_data", this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    private <T extends AnalyticsEvent> void sendAnalyticEventsForReservoir(String method, String encoding, int reservoirSize, int eventsSeen, Collection<T> events) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || events.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(3);
        params.add(runId);
        JSONObject metadata = new JSONObject();
        metadata.put("reservoir_size", reservoirSize);
        metadata.put("events_seen", eventsSeen);
        params.add(metadata);
        params.add(events);
        this.invokeRunId(method, encoding, runId, params);
    }

    private <T extends AnalyticsEvent> void sendLogEventsForReservoir(String method, String encoding, Collection<T> events) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || events.isEmpty()) {
            return;
        }
        JSONObject commonAttributes = new JSONObject();
        JSONObject attributes = new JSONObject();
        attributes.put("attributes", commonAttributes);
        JSONObject common = new JSONObject();
        common.put("common", attributes);
        JSONObject logs = new JSONObject();
        logs.put("logs", events);
        InitialSizedJsonArray params = new InitialSizedJsonArray(3);
        params.add(common);
        params.add(logs);
        this.invokeRunId(method, encoding, runId, params);
    }

    @Override
    public void sendMetricData(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || metricData.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(4);
        params.add(runId);
        params.add(beginTimeMillis / 1000L);
        params.add(endTimeMillis / 1000L);
        params.add(metricData);
        this.invokeRunId("metric_data", this.compressedEncoding, runId, params);
    }

    @Override
    public List<Long> sendProfileData(List<ProfileData> profiles) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || profiles.isEmpty()) {
            return Collections.emptyList();
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(profiles);
        Object response = this.invokeRunId("profile_data", this.getEncodingForComplexCompression(), runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            this.logger.warning(MessageFormat.format("Invalid response from New Relic sending profiles: {0}", e));
            throw e;
        }
    }

    @Override
    public void sendModules(List<? extends JSONStreamAware> jarDataList) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || jarDataList == null || jarDataList.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(MODULE_TYPE);
        params.add(jarDataList);
        this.invokeRunId("update_loaded_modules", this.compressedEncoding, runId, params);
    }

    private String getEncodingForComplexCompression() {
        return this.configService.getDefaultAgentConfig().isSimpleCompression() ? this.compressedEncoding : IDENTITY_ENCODING;
    }

    @Override
    public void sendSqlTraceData(List<SqlTrace> sqlTraces) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || sqlTraces.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        params.add(sqlTraces);
        this.invokeRunId("sql_trace_data", this.getEncodingForComplexCompression(), runId, params);
    }

    @Override
    public void sendTransactionTraceData(List<TransactionTrace> traces) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || traces.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(traces);
        this.invokeRunId("transaction_sample_data", this.getEncodingForComplexCompression(), runId, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long timeMillis) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(timeMillis);
        try {
            this.invokeRunId("shutdown", this.compressedEncoding, runId, params);
        }
        finally {
            this.setAgentRunId(NO_AGENT_RUN_ID);
            this.httpClientWrapper.shutdown();
        }
    }

    @VisibleForTesting
    void setMaxPayloadSizeInBytes(int payloadSizeInBytes) {
        this.maxPayloadSizeInBytes = payloadSizeInBytes;
    }

    private Object invokeRunId(String method, String encoding, Object runId, JSONStreamAware params) throws Exception {
        String uri = MessageFormat.format(this.agentRunIdUriPattern, method, runId.toString());
        return this.invoke(this.redirectHost, method, encoding, uri, params);
    }

    private Object invokeNoRunId(String host, String method, String encoding, JSONStreamAware params) throws Exception {
        String uri = MessageFormat.format(this.noAgentRunIdUriPattern, method);
        return this.invoke(host, method, encoding, uri, params);
    }

    private Object invoke(String host, String method, String encoding, String uri, JSONStreamAware params) throws Exception {
        ReadResult readResult = this.send(host, method, encoding, uri, params);
        Map<?, ?> responseMap = null;
        String responseBody = readResult.getResponseBody();
        if (responseBody != null && !responseBody.isEmpty()) {
            try {
                responseMap = this.getResponseMap(responseBody);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Error parsing response JSON({0}) from NewRelic: {1}", method, e.toString());
                this.logger.log(Level.FINEST, "Invalid response JSON({0}): {1}", method, responseBody);
                throw e;
            }
        } else if (METHODS_WITH_RESPONSE_BODY.contains(method)) {
            this.logger.log(Level.FINER, "Response was null ({0})", method);
        }
        if (responseMap != null) {
            if (this.dataSenderListener != null) {
                this.dataSenderListener.dataReceived(method, encoding, uri, responseMap);
            }
            try {
                return responseMap.get(EXCEPTION_MAP_RETURN_VALUE_KEY);
            }
            catch (ClassCastException ex) {
                this.logger.log(Level.WARNING, "Error parsing response JSON({0}) from NewRelic: {1}", method, ex.toString());
                return null;
            }
        }
        return null;
    }

    private ReadResult connectAndSend(String host, String method, String encoding, String uri, JSONStreamAware params) throws Exception {
        byte[] data = this.writeData(encoding, params);
        if (data.length > this.maxPayloadSizeInBytes && !method.equals("error_data")) {
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Agent/Collector/MaxPayloadSizeLimit/{0}", method), 1), "Supportability/Agent/Collector/MaxPayloadSizeLimit/{0}");
            String msg = MessageFormat.format("Payload of size {0} exceeded maximum size {1} for {2} method ", data.length, this.maxPayloadSizeInBytes, method);
            this.logger.log(Level.WARNING, msg);
            throw new MaxPayloadException(msg);
        }
        URL url = new URL(PROTOCOL, host, this.port, uri);
        HttpClientWrapper.Request request = this.createRequest(method, encoding, url, data);
        this.httpClientWrapper.captureSupportabilityMetrics(ServiceFactory.getStatsService(), host);
        ReadResult result = this.httpClientWrapper.execute(request, new TimingEventHandler(method, ServiceFactory.getStatsService()));
        String payloadJsonSent = DataSenderWriter.toJSONString(params);
        if (this.auditMode && this.methodShouldBeAudited(method)) {
            String msg = MessageFormat.format("Sent JSON({0}) to: {1}, with payload: {2}", method, url, payloadJsonSent);
            this.logger.info(msg);
        }
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Collector/HttpCode/{0}", result.getStatusCode()), 1), "Supportability/Collector/HttpCode/{0}");
        if (result.getStatusCode() != 200 && result.getStatusCode() != 202) {
            this.throwExceptionFromStatusCode(method, result, data, request);
        }
        String payloadJsonReceived = result.getResponseBody();
        if (this.auditMode && this.methodShouldBeAudited(method)) {
            this.logger.info(MessageFormat.format("Received JSON({0}): {1}", method, payloadJsonReceived));
        }
        this.recordDataUsageMetrics(method, payloadJsonSent, payloadJsonReceived);
        if (this.dataSenderListener != null) {
            this.dataSenderListener.dataSent(method, encoding, uri, data);
        }
        return result;
    }

    private void recordDataUsageMetrics(String method, String payloadJsonSent, String payloadJsonReceived) {
        int payloadBytesSent = payloadJsonSent.getBytes().length;
        int payloadBytesReceived = payloadJsonReceived.getBytes().length;
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordDataUsageMetricWork(MessageFormat.format("Supportability/Java/{0}/Output/Bytes", COLLECTOR), payloadBytesSent, payloadBytesReceived), "Supportability/Java/{0}/Output/Bytes Collector");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordDataUsageMetricWork(MessageFormat.format("Supportability/Java/{0}/{1}/Output/Bytes", COLLECTOR, method), payloadBytesSent, payloadBytesReceived), "Supportability/Java/{0}/{1}/Output/Bytes Collector");
    }

    private void throwExceptionFromStatusCode(String method, ReadResult result, byte[] data, HttpClientWrapper.Request request) throws HttpError, LicenseException, ForceRestartException, ForceDisconnectException {
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Agent/Collector/HTTPError/{0}", result.getStatusCode()), 1), "Supportability/Agent/Collector/HTTPError/{0}");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Agent/Collector/{0}/Attempts", method), 1), "Supportability/Agent/Collector/{0}/Attempts");
        switch (result.getStatusCode()) {
            case 407: {
                String authField = result.getProxyAuthenticateHeader();
                if (authField != null) {
                    throw new HttpError("Proxy Authentication Mechanism Failed: " + authField, result.getStatusCode(), data.length);
                }
                throw new HttpError("Proxy Authentication Mechanism Failed: null Proxy-Authenticate header", result.getStatusCode(), data.length);
            }
            case 401: {
                throw new LicenseException(this.parseExceptionMessage(result.getResponseBody()));
            }
            case 409: {
                throw new ForceRestartException(this.parseExceptionMessage(result.getResponseBody()));
            }
            case 410: {
                throw new ForceDisconnectException(this.parseExceptionMessage(result.getResponseBody()));
            }
        }
        this.logger.log(Level.FINER, "Connection http status code: {0}", result.getStatusCode());
        throw HttpError.create(result.getStatusCode(), request.getURL().getHost(), data.length);
    }

    private String parseExceptionMessage(String responseBody) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject responseMessageObject = (JSONObject)parser.parse(responseBody);
            JSONObject exception = (JSONObject)responseMessageObject.get("exception");
            return exception.get("message").toString();
        }
        catch (Exception ignored) {
            return responseBody;
        }
    }

    private boolean methodShouldBeAudited(String method) {
        if (this.auditModeEndpoints != null && this.auditModeEndpoints.size() > 0) {
            return this.auditModeEndpoints.contains(method);
        }
        return true;
    }

    private ReadResult send(String host, String method, String encoding, String uri, JSONStreamAware params) throws Exception {
        try {
            return this.connectAndSend(host, method, encoding, uri, params);
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, "You have requested a connection to New Relic via a protocol which is unavailable in your runtime: {0}", e.toString());
            throw new ForceDisconnectException(e.toString());
        }
        catch (SocketException e) {
            if (e.getCause() instanceof NoSuchAlgorithmException) {
                String msg = MessageFormat.format("You have requested a connection to New Relic via an algorithm which is unavailable in your runtime: {0}. This may also be indicative of a corrupted keystore or trust store on your server.", e.getCause().toString());
                this.logger.error(msg);
            } else {
                this.logger.log(Level.INFO, "A socket exception was encountered while sending data to New Relic ({0}). Please check your network / proxy settings.", e.toString());
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Error sending JSON({0}): {1}", method, DataSenderWriter.toJSONString(params));
                }
                this.logger.log(Level.FINEST, e, e.toString());
            }
            throw e;
        }
        catch (HttpError e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof SSLHandshakeException) {
                this.logger.log(Level.INFO, "Unable to connect to New Relic due to an SSL error. Consider enabling -Djavax.net.debug=all to debug your SSL configuration such as your trust store.", e);
            }
            this.logger.log(Level.INFO, "Remote {0} call failed : {1}.", method, e.toString());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Error sending JSON({0}): {1}", method, DataSenderWriter.toJSONString(params));
            }
            this.logger.log(Level.FINEST, e, e.toString());
            throw e;
        }
    }

    private HttpClientWrapper.Request createRequest(String method, String encoding, URL url, byte[] data) {
        boolean isConnectOrPreconnect = method.equals("connect") || method.equals("preconnect");
        Map<String, String> requestMetadata = this.requestMetadata != null && !isConnectOrPreconnect ? this.requestMetadata : Collections.emptyMap();
        return new HttpClientWrapper.Request().setURL(url).setVerb(this.putForDataSend ? HttpClientWrapper.Verb.PUT : HttpClientWrapper.Verb.POST).setEncoding(encoding).setData(data).setRequestMetadata(requestMetadata);
    }

    private byte[] writeData(String encoding, JSONStreamAware params) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try (OutputStream os = this.getOutputStream(outStream, encoding);
             OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            JSONValue.writeJSONString(params, out);
            ((Writer)out).flush();
        }
        return outStream.toByteArray();
    }

    private OutputStream getOutputStream(OutputStream out, String encoding) throws IOException {
        if (DEFLATE_ENCODING.equals(encoding)) {
            return new DeflaterOutputStream(out, new Deflater(-1));
        }
        if (GZIP_ENCODING.equals(encoding)) {
            return new GZIPOutputStream(out);
        }
        return out;
    }

    private Map<?, ?> getResponseMap(String responseBody) throws Exception {
        JSONParser parser = new JSONParser();
        Object response = parser.parse(responseBody);
        return (Map)response;
    }

    private static class TimingEventHandler
    implements HttpClientWrapper.ExecuteEventHandler {
        private final String method;
        private final StatsService statsService;
        private long requestSent;

        TimingEventHandler(String method, StatsService statsService) {
            this.method = method;
            this.statsService = statsService;
        }

        @Override
        public void requestStarted() {
            this.requestSent = System.currentTimeMillis();
        }

        @Override
        public void requestEnded() {
            long requestDuration = System.currentTimeMillis() - this.requestSent;
            this.statsService.doStatsWork(StatsWorks.getRecordResponseTimeWork(MessageFormat.format("Supportability/Agent/Collector/{0}/Duration", this.method), requestDuration), "Supportability/Agent/Collector/{0}/Duration " + this.method);
        }
    }
}

