/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpGet;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpPut;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpUriRequest;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.ConnectTimeoutException;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.StrictHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.util.EntityUtils;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.function.Function;

public class CloudUtility {
    private static final int MIN_CHAR_CODEPOINT = "\u007f".codePointAt(0);
    private final Function<Integer, CloseableHttpClient> httpClientCreator;

    public CloudUtility() {
        this(new Function<Integer, CloseableHttpClient>(){

            @Override
            public CloseableHttpClient apply(Integer requestTimeoutMillis) {
                return CloudUtility.configureHttpClient(requestTimeoutMillis);
            }
        });
    }

    CloudUtility(Function<Integer, CloseableHttpClient> httpClientCreator) {
        this.httpClientCreator = httpClientCreator;
    }

    public String httpGet(String url, int requestTimeoutMillis, String ... headers) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        return this.makeHttpRequest(httpGet, requestTimeoutMillis, headers);
    }

    public String httpPut(String url, int requestTimeoutMillis, String ... headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        return this.makeHttpRequest(httpPut, requestTimeoutMillis, headers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String makeHttpRequest(HttpUriRequest request, int requestTimeoutMillis, String[] headers) throws IOException {
        try (CloseableHttpClient httpclient = this.httpClientCreator.apply(requestTimeoutMillis);){
            for (String header : headers) {
                String[] parts = header.split(":");
                request.addHeader(parts[0].trim(), parts[1].trim());
            }
            CloseableHttpResponse response = httpclient.execute(request);
            if (response.getStatusLine().getStatusCode() > 207) return null;
            String string = EntityUtils.toString(response.getEntity(), "UTF-8");
            return string;
        }
        catch (ConnectTimeoutException | SocketException | SocketTimeoutException | UnknownHostException iOException) {
            // empty catch block
        }
        return null;
    }

    private static CloseableHttpClient configureHttpClient(int requestTimeoutInMillis) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setHostnameVerifier(new StrictHostnameVerifier());
        return builder.build();
    }

    public void recordError(String metricName) {
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(metricName, 1), metricName);
    }

    boolean isInvalidValue(String value) {
        if (value == null) {
            return true;
        }
        if (value.getBytes().length > 255) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ' || c == '_' || c == '.' || c == '/' || c == '-' || c > MIN_CHAR_CODEPOINT) continue;
            return true;
        }
        return false;
    }
}

