/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.instrumentation.AbstractClassTransformer;
import com.newrelic.agent.instrumentation.AddInterfaceAdapter;
import com.newrelic.agent.instrumentation.FieldAccessorGeneratingClassAdapter;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.RequireMethodsAdapter;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMixin;
import com.newrelic.agent.util.Annotations;
import com.newrelic.agent.util.Strings;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class InterfaceMixinClassTransformer
extends AbstractClassTransformer {
    private final Map<String, List<Class<?>>> interfaceVisitors = new HashMap();

    public InterfaceMixinClassTransformer(int classreaderFlags) {
        super(classreaderFlags);
    }

    @Override
    protected void start() {
        this.addInterfaceMixins();
    }

    private void addInterfaceMixins() {
        Collection<Class<?>> classes = new Annotations().getInterfaceMixinClasses();
        for (Class<?> clazz : classes) {
            this.addInterfaceMixin(clazz);
        }
    }

    protected void addInterfaceMixin(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        InterfaceMixin mixin = clazz.getAnnotation(InterfaceMixin.class);
        if (mixin == null) {
            Agent.LOG.log(Level.FINER, "InterfaceMixin access failed: " + clazz.getName());
            return;
        }
        for (String className : mixin.originalClassName()) {
            String key = Strings.fixInternalClassName(className);
            List<Class<?>> value = this.interfaceVisitors.get(key);
            if (value == null) {
                value = new ArrayList(1);
            }
            value.add(clazz);
            this.interfaceVisitors.put(key, value);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (!PointCutClassTransformer.isValidClassName(className)) {
                return null;
            }
            if (!this.matches(loader, className, classBeingRedefined, protectionDomain, classfileBuffer)) {
                return null;
            }
            if (!this.isAbleToResolveAgent(loader, className)) {
                return null;
            }
            List<Class<?>> clazzes = this.interfaceVisitors.get(className);
            if (clazzes == null || clazzes.size() == 0) {
                return null;
            }
            return this.transform(classfileBuffer, clazzes, loader, className);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, t, "Instrumentation error for {0}", className);
            return null;
        }
    }

    private byte[] transform(byte[] classBytesWithUID, List<Class<?>> clazzes, ClassLoader loader, String className) throws Exception {
        byte[] classBytes = classBytesWithUID;
        byte[] oldClassBytes = classBytesWithUID;
        for (Class<?> clazz : clazzes) {
            try {
                oldClassBytes = classBytes = this.transform(classBytes, clazz, loader, className);
            }
            catch (StopProcessingException e) {
                String msg = MessageFormat.format("Failed to append {0} to {1}: {2}", clazz.getName(), className, e);
                Agent.LOG.fine(msg);
                classBytes = oldClassBytes;
            }
        }
        String msg = MessageFormat.format("Instrumenting {0}", className);
        Agent.LOG.finer(msg);
        return classBytes;
    }

    private byte[] transform(byte[] classBytes, Class<?> clazz, ClassLoader loader, String className) throws Exception {
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = InstrumentationUtils.getClassWriter(cr, loader);
        ClassVisitor classVisitor = this.getClassVisitor(cw, className, clazz, loader);
        cr.accept(classVisitor, this.getClassReaderFlags());
        Agent.LOG.log(Level.FINEST, "InterfaceMixingClassTransformer.transform(bytes, clazz, {0}, {1})", loader, className);
        return cw.toByteArray();
    }

    private ClassVisitor getClassVisitor(ClassVisitor classVisitor, String className, Class<?> clazz, ClassLoader loader) {
        ClassVisitor adapter = new AddInterfaceAdapter(classVisitor, className, clazz);
        adapter = RequireMethodsAdapter.getRequireMethodsAdaptor(adapter, className, clazz, loader);
        adapter = new FieldAccessorGeneratingClassAdapter(adapter, className, clazz);
        return adapter;
    }

    @Override
    protected boolean isRetransformSupported() {
        return false;
    }

    @Override
    protected boolean matches(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return this.interfaceVisitors.containsKey(className);
    }

    @Override
    protected ClassVisitor getClassVisitor(ClassReader cr, ClassWriter cw, String className, ClassLoader loader) {
        return null;
    }
}

