/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.threads;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.AbstractMetricAggregator;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import com.newrelic.api.agent.MetricAggregator;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ThreadStateSampler
implements Runnable {
    private final LoadingCache<Long, ThreadTracker> threads = Caffeine.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build(threadId -> new ThreadTracker());
    private final ThreadMXBean threadMXBean;
    private final ThreadNameNormalizer threadNameNormalizer;
    private final MetricAggregator metricAggregator;

    public ThreadStateSampler(ThreadMXBean threadMXBean, ThreadNameNormalizer nameNormalizer) {
        this.threadMXBean = threadMXBean;
        this.metricAggregator = new ThreadStatsMetricAggregator(ServiceFactory.getStatsService());
        this.threadNameNormalizer = nameNormalizer;
    }

    @Override
    public void run() {
        ThreadInfo[] threadInfos;
        long[] allThreadIds = this.threadMXBean.getAllThreadIds();
        for (ThreadInfo thread2 : threadInfos = this.threadMXBean.getThreadInfo(allThreadIds, 0)) {
            if (thread2 != null) {
                this.threads.get(thread2.getThreadId()).update(thread2);
                continue;
            }
            Agent.LOG.finer("ThreadStateSampler: Skipping null thread.");
        }
    }

    private final class RecordResponseTimeMetricWorker
    implements StatsWork {
        private String appName;
        private final long totalInMillis;
        private final long exclusiveTimeInMillis;
        private final String name;
        private final TimeUnit timeUnit;

        public RecordResponseTimeMetricWorker(String appName, long millis, String name, TimeUnit timeUnit) {
            this(appName, millis, millis, name, timeUnit);
        }

        public RecordResponseTimeMetricWorker(String appName, long totalInMillis, long exclusiveTimeInMillis, String name, TimeUnit timeUnit) {
            this.appName = appName;
            this.exclusiveTimeInMillis = exclusiveTimeInMillis;
            this.totalInMillis = totalInMillis;
            this.timeUnit = timeUnit;
            this.name = name;
        }

        @Override
        public void doWork(StatsEngine statsEngine) {
            statsEngine.getResponseTimeStats(this.name).recordResponseTime(this.totalInMillis, this.exclusiveTimeInMillis, this.timeUnit);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }

    private final class IncrementCounterWorker
    implements StatsWork {
        private String appName;
        private final String name;
        private final int count;

        public IncrementCounterWorker(String appName, String name, int count) {
            this.appName = appName;
            this.name = name;
            this.count = count;
        }

        @Override
        public void doWork(StatsEngine statsEngine) {
            statsEngine.getStats(this.name).incrementCallCount(this.count);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }

    private final class RecordMetricWorker
    implements StatsWork {
        private String appName;
        private final String name;
        private final float value;

        public RecordMetricWorker(String appName, String name, float value) {
            this.appName = appName;
            this.name = name;
            this.value = value;
        }

        @Override
        public void doWork(StatsEngine statsEngine) {
            statsEngine.getStats(this.name).recordDataPoint(this.value);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }

    private class ThreadStatsMetricAggregator
    extends AbstractMetricAggregator {
        private final StatsService statsService;
        private final boolean isAutoAppNamingEnabled;

        public ThreadStatsMetricAggregator(StatsService statsService) {
            AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
            this.isAutoAppNamingEnabled = config.isAutoAppNamingEnabled();
            this.statsService = statsService;
        }

        @Override
        protected void doRecordResponseTimeMetric(String name, long totalTime, long exclusiveTime, TimeUnit timeUnit) {
            if (!this.isAutoAppNamingEnabled) {
                this.statsService.doStatsWork(new RecordResponseTimeMetricWorker(null, totalTime, exclusiveTime, name, timeUnit));
            } else {
                List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
                RecordResponseTimeMetricWorker responseTimeWorker = new RecordResponseTimeMetricWorker(null, totalTime, exclusiveTime, name, timeUnit);
                for (IRPMService rpmService : rpmServices) {
                    String appName = rpmService.getApplicationName();
                    responseTimeWorker.setAppName(appName);
                    this.statsService.doStatsWork(responseTimeWorker);
                }
            }
        }

        @Override
        protected void doRecordMetric(String name, float value) {
            if (!this.isAutoAppNamingEnabled) {
                this.statsService.doStatsWork(new RecordMetricWorker(null, name, value));
            } else {
                List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
                RecordMetricWorker metricWorker = new RecordMetricWorker(null, name, value);
                for (IRPMService rpmService : rpmServices) {
                    String appName = rpmService.getApplicationName();
                    metricWorker.setAppName(appName);
                    this.statsService.doStatsWork(metricWorker);
                }
            }
        }

        @Override
        protected void doIncrementCounter(String name, int count) {
            if (!this.isAutoAppNamingEnabled) {
                this.statsService.doStatsWork(new IncrementCounterWorker(null, name, count));
            } else {
                List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
                IncrementCounterWorker incrementCounterWorker = new IncrementCounterWorker(null, name, count);
                for (IRPMService rpmService : rpmServices) {
                    String appName = rpmService.getApplicationName();
                    incrementCounterWorker.setAppName(appName);
                    this.statsService.doStatsWork(incrementCounterWorker);
                }
            }
        }
    }

    private class ThreadTracker {
        private long lastThreadTotalCpuTime = -1L;
        private long lastThreadUserTime = -1L;
        private long lastThreadSystemTime = -1L;
        private long lastBlockedTime = -1L;
        private long lastWaitedTime = -1L;
        private long lastBlockedCount = -1L;
        private long lastWaitedCount = -1L;

        public void update(ThreadInfo thread2) {
            String name = ThreadStateSampler.this.threadNameNormalizer.getNormalizedThreadName(new BasicThreadInfo(thread2));
            ThreadStateSampler.this.metricAggregator.recordMetric("Threads/State/" + name + "/" + thread2.getThreadState().toString() + "/Count", 1.0f);
            ThreadStateSampler.this.metricAggregator.recordMetric("Threads/SummaryState/" + thread2.getThreadState().toString() + "/Count", 1.0f);
            if (ThreadStateSampler.this.threadMXBean.isThreadCpuTimeSupported() && ThreadStateSampler.this.threadMXBean.isThreadCpuTimeEnabled()) {
                long totalCpuTime = ThreadStateSampler.this.threadMXBean.getThreadCpuTime(thread2.getThreadId());
                long userCpuTime = ThreadStateSampler.this.threadMXBean.getThreadUserTime(thread2.getThreadId());
                long systemCpuTime = totalCpuTime - userCpuTime;
                this.lastThreadTotalCpuTime = this.recordAccumulatingValue("Threads/TotalTime/" + name + "/CpuTime", totalCpuTime, this.lastThreadTotalCpuTime, TimeUnit.NANOSECONDS);
                this.lastThreadUserTime = this.recordAccumulatingValue("Threads/Time/CPU/" + name + "/UserTime", userCpuTime, this.lastThreadUserTime, TimeUnit.NANOSECONDS);
                this.lastThreadSystemTime = this.recordAccumulatingValue("Threads/Time/CPU/" + name + "/SystemTime", systemCpuTime, this.lastThreadSystemTime, TimeUnit.NANOSECONDS);
            }
            if (ThreadStateSampler.this.threadMXBean.isThreadContentionMonitoringEnabled()) {
                this.lastWaitedTime = this.recordAccumulatingValue("Threads/Time/State/" + name + "/WaitedTime", thread2.getWaitedTime(), this.lastWaitedTime, TimeUnit.MILLISECONDS);
                this.lastBlockedTime = this.recordAccumulatingValue("Threads/Time/State/" + name + "/BlockedTime", thread2.getBlockedTime(), this.lastBlockedTime, TimeUnit.MILLISECONDS);
            }
            this.lastBlockedCount = this.recordAccumulatingCount("Threads/Count/" + name + "/BlockedCount", thread2.getBlockedCount(), this.lastBlockedCount);
            this.lastWaitedCount = this.recordAccumulatingCount("Threads/Count/" + name + "/WaitedCount", thread2.getWaitedCount(), this.lastWaitedCount);
        }

        private long recordAccumulatingCount(String name, long currentCount, long lastCount) {
            try {
                if (currentCount == -1L || lastCount == -1L) {
                    return currentCount;
                }
                ThreadStateSampler.this.metricAggregator.recordMetric(name, (float)Math.max(currentCount - lastCount, 0L));
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, e, e.getMessage());
            }
            return currentCount;
        }

        private long recordAccumulatingValue(String name, long currentTime, long lastTime, TimeUnit timeUnit) {
            try {
                if (currentTime == -1L || lastTime == -1L) {
                    return currentTime;
                }
                ThreadStateSampler.this.metricAggregator.recordResponseTimeMetric(name, timeUnit.toMillis(Math.max(currentTime - lastTime, 0L)));
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, e, e.getMessage());
            }
            return currentTime;
        }
    }
}

