/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelManager;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.SpanConverter;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.io.grpc.stub.ClientCallStreamObserver;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.V1;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class SpanEventSender
implements Runnable {
    private final Logger logger;
    private final BlockingQueue<SpanEvent> queue;
    private final MetricAggregator aggregator;
    private final ChannelManager channelManager;

    SpanEventSender(InfiniteTracingConfig config, BlockingQueue<SpanEvent> queue, MetricAggregator aggregator, ChannelManager channelManager) {
        this.logger = config.getLogger();
        this.queue = queue;
        this.aggregator = aggregator;
        this.channelManager = channelManager;
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "Initializing {0}", (Object)this.getClass().getSimpleName());
        try {
            while (true) {
                this.pollAndWrite();
            }
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, t2, "A problem occurred and no further spans will be sent.");
            return;
        }
    }

    @VisibleForTesting
    void pollAndWrite() {
        ClientCallStreamObserver<V1.Span> observer = this.channelManager.getSpanObserver();
        if (!this.awaitReadyObserver(observer)) {
            return;
        }
        SpanEvent span = this.pollSafely();
        if (span == null) {
            return;
        }
        V1.Span convertedSpan = SpanConverter.convert(span);
        this.writeToObserver(observer, convertedSpan);
    }

    @VisibleForTesting
    boolean awaitReadyObserver(ClientCallStreamObserver<V1.Span> observer) {
        if (observer.isReady()) {
            return true;
        }
        try {
            this.logger.log(Level.FINE, "Waiting for gRPC span observer to be ready.");
            this.aggregator.incrementCounter("Supportability/InfiniteTracing/NotReady");
            Thread.sleep(250L);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while awaiting ready gRPC span observer.");
        }
        return false;
    }

    @VisibleForTesting
    SpanEvent pollSafely() {
        try {
            return this.queue.poll(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while polling for spans.");
        }
    }

    @VisibleForTesting
    void writeToObserver(ClientCallStreamObserver<V1.Span> observer, V1.Span span) {
        try {
            observer.onNext(span);
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, t2, "Unable to send span.");
            throw t2;
        }
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/Sent");
    }
}

