/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.JfrConfig;
import java.util.Collections;
import java.util.Map;

class JfrConfigImpl
extends BaseConfig
implements JfrConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.jfr.";
    public static final String ENABLED = "enabled";
    public static final Boolean ENABLED_DEFAULT = Boolean.FALSE;
    public static final String AUDIT_LOGGING = "audit_logging";
    public static final Boolean AUDIT_LOGGING_DEFAULT = Boolean.FALSE;
    public static final Boolean USE_LICENSE_KEY_DEFAULT = Boolean.TRUE;
    private final boolean isEnabled = this.getProperty("enabled", ENABLED_DEFAULT);

    public JfrConfigImpl(Map<String, Object> pProps) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
    }

    static JfrConfigImpl createJfrConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new JfrConfigImpl(settings);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean auditLoggingEnabled() {
        return this.getProperty(AUDIT_LOGGING, AUDIT_LOGGING_DEFAULT);
    }

    @Override
    public boolean useLicenseKey() {
        return USE_LICENSE_KEY_DEFAULT;
    }
}

