/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.okhttp3.internal.platform.android;

import com.newrelic.agent.deps.android.util.Log;
import com.newrelic.agent.deps.kotlin.Metadata;
import com.newrelic.agent.deps.kotlin.TypeCastException;
import com.newrelic.agent.deps.kotlin.collections.MapsKt;
import com.newrelic.agent.deps.kotlin.jvm.internal.Intrinsics;
import com.newrelic.agent.deps.kotlin.text.StringsKt;
import com.newrelic.agent.deps.okhttp3.OkHttpClient;
import com.newrelic.agent.deps.okhttp3.internal.SuppressSignatureCheck;
import com.newrelic.agent.deps.okhttp3.internal.concurrent.TaskRunner;
import com.newrelic.agent.deps.okhttp3.internal.http2.Http2;
import com.newrelic.agent.deps.okhttp3.internal.platform.android.AndroidLogHandler;
import com.newrelic.agent.deps.org.jetbrains.annotations.NotNull;
import com.newrelic.agent.deps.org.jetbrains.annotations.Nullable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/newrelic/agent/deps/okhttp3/internal/platform/android/AndroidLog;", "", "()V", "MAX_LOG_LENGTH", "", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "knownLoggers", "", "", "com.newrelic.agent.deps.androidLog", "", "loggerName", "logLevel", "message", "t", "", "com.newrelic.agent.deps.androidLog$okhttp", "enable", "enableLogging", "logger", "tag", "loggerTag", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    private static final Map<String, String> knownLoggers;
    public static final AndroidLog INSTANCE;

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message, @Nullable Throwable t2) {
        Intrinsics.checkParameterIsNotNull(loggerName, "loggerName");
        Intrinsics.checkParameterIsNotNull(message, "message");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage = message;
            if (t2 != null) {
                logMessage = logMessage + "\n" + Log.getStackTraceString((Throwable)t2);
            }
            int length = logMessage.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, '\n', i, false, 4, null);
                newline = newline != -1 ? newline : length;
                do {
                    String string;
                    int n = i + 4000;
                    boolean bl = false;
                    end = Math.min(newline, n);
                    String string2 = logMessage;
                    String string3 = tag;
                    int n2 = logLevel;
                    bl = false;
                    String string4 = string2;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull(string4.substring(i, end), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Log.println((int)n2, (String)string3, (String)string);
                } while ((i = end) < newline);
            }
        }
    }

    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        if (string == null) {
            string = StringsKt.take(loggerName, 23);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void enable() {
        Object object = knownLoggers;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void logger;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String tag = entry2.getValue();
            this.enableLogging((String)logger, tag);
        }
    }

    private final void enableLogging(String logger, String tag) {
        Logger logger2 = Logger.global;
        if (configuredLoggers.add(logger2)) {
            Logger logger3 = logger2;
            Intrinsics.checkExpressionValueIsNotNull(logger3, "logger");
            logger3.setUseParentHandlers(false);
            logger2.setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)tag, (int)4) ? Level.INFO : Level.WARNING));
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    private AndroidLog() {
    }

    static {
        String packageName;
        AndroidLog androidLog;
        INSTANCE = androidLog = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashMap $this$apply = linkedHashMap;
        boolean bl3 = false;
        Package package_ = OkHttpClient.class.getPackage();
        String string = packageName = package_ != null ? package_.getName() : null;
        if (packageName != null) {
            ((Map)$this$apply).put(packageName, "OkHttp");
        }
        Map map = $this$apply;
        String string2 = OkHttpClient.class.getName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "OkHttpClient::class.java.name");
        map.put(string2, "okhttp.OkHttpClient");
        Map map2 = $this$apply;
        String string3 = Http2.class.getName();
        Intrinsics.checkExpressionValueIsNotNull(string3, "Http2::class.java.name");
        map2.put(string3, "okhttp.Http2");
        Map map3 = $this$apply;
        String string4 = TaskRunner.class.getName();
        Intrinsics.checkExpressionValueIsNotNull(string4, "TaskRunner::class.java.name");
        map3.put(string4, "okhttp.TaskRunner");
        knownLoggers = MapsKt.toMap(linkedHashMap);
    }
}

