/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.WeavedMethod;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassChecker;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.CurrentTransactionRewriter;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.MarkWeaverMethodsVisitor;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.PatchedClassWriter;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;

public class FinalClassTransformer
implements ContextClassTransformer {
    private static final Set<String> CLASSES_TO_SKIP_VERSION_UPGRADE = ImmutableSet.of("org/eclipse/core/runtime/internal/adaptor/ContextFinder");
    private static final Set<String> ANNOTATIONS_TO_REMOVE = ImmutableSet.of(Type.getDescriptor(InstrumentedClass.class), Type.getDescriptor(InstrumentedMethod.class), Type.getDescriptor(WeavedMethod.class));
    private static ClassChecker CLASS_CHECKER = null;

    public static void setClassChecker(ClassChecker classChecker) {
        CLASS_CHECKER = classChecker;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        try {
            if (!PointCutClassTransformer.isValidClassName(className)) {
                return null;
            }
            return this.getFinalTransformation(loader, className, classBeingRedefined, classfileBuffer, context);
        }
        catch (Throwable ex) {
            Agent.LOG.log(Level.FINE, "Unable to transform " + className, ex);
            return null;
        }
    }

    private byte[] getFinalTransformation(ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, InstrumentationContext context) {
        PatchedClassWriter writer;
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassVisitor cv = writer = new PatchedClassWriter(2, context.getClassResolver(loader));
        if (!context.getWeavedMethods().isEmpty()) {
            cv = new MarkWeaverMethodsVisitor(cv, context);
        }
        cv = this.addModifiedClassAnnotation(cv, context);
        cv = this.addModifiedMethodAnnotation(cv, context, loader);
        cv = new ClassVisitor(589824, cv){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (version < 49 || version > 100) {
                    int newVersion = WeaveUtils.RUNTIME_MAX_SUPPORTED_CLASS_VERSION;
                    if (CLASSES_TO_SKIP_VERSION_UPGRADE.contains(name)) {
                        newVersion = 50;
                    }
                    Agent.LOG.log(Level.FINEST, "Converting {0} from version {1} to {2}", name, version, newVersion);
                    version = newVersion;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new JSRInlinerAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc, signature, exceptions);
            }
        };
        cv = this.skipExistingAnnotations(cv);
        cv = CurrentTransactionRewriter.rewriteCurrentTransactionReferences(cv, reader);
        reader.accept(cv, 4);
        byte[] classBytes = writer.toByteArray();
        if (CLASS_CHECKER != null) {
            CLASS_CHECKER.check(classBytes);
        }
        if (Agent.isDebugEnabled()) {
            this.writeClassFiles(className, context, classBytes);
        }
        this.addSupportabilityMetrics(reader, className, context);
        Agent.LOG.finer("Final transformation of class " + className);
        return classBytes;
    }

    private void writeClassFiles(String className, InstrumentationContext context, byte[] classBytes) {
        try {
            File old = File.createTempFile(className.replace('/', '_'), ".old", BootstrapLoader.getTempDir());
            Utils.print(context.bytes, new PrintWriter(old));
            Agent.LOG.debug("Wrote " + old.getAbsolutePath());
            File newFile = File.createTempFile(className.replace('/', '_'), ".new", BootstrapLoader.getTempDir());
            Utils.print(classBytes, new PrintWriter(newFile));
            Agent.LOG.debug("Wrote " + newFile.getAbsolutePath());
            File newClassFile = File.createTempFile(className.replace('/', '_'), ".new.class", BootstrapLoader.getTempDir());
            try (FileOutputStream fos = new FileOutputStream(newClassFile);){
                fos.write(classBytes);
            }
            Agent.LOG.debug("Wrote " + newClassFile.getAbsolutePath());
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINEST, t2, "Error writing debug bytecode for {0}", className);
        }
    }

    private ClassVisitor skipExistingAnnotations(ClassVisitor cv) {
        return new ClassVisitor(589824, cv){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (ANNOTATIONS_TO_REMOVE.contains(desc)) {
                    return null;
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(589824, super.visitMethod(access, name, desc, signature, exceptions)){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (ANNOTATIONS_TO_REMOVE.contains(desc)) {
                            return null;
                        }
                        return super.visitAnnotation(desc, visible);
                    }
                };
            }
        };
    }

    private void addSupportabilityMetrics(ClassReader reader, String className, InstrumentationContext context) {
        StatsService statsService = ServiceFactory.getStatsService();
        if (statsService != null) {
            for (Method m4 : context.getTimedMethods()) {
                TraceDetails traceDetails = context.getTraceInformation().getTraceAnnotations().get(m4);
                if (traceDetails == null || !traceDetails.isCustom()) continue;
                statsService.doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format("Supportability/Instrumented/{0}/{1}{2}", className.replace('/', '.'), m4.getName(), m4.getDescriptor()), 1.0f));
            }
        }
    }

    private ClassVisitor addModifiedClassAnnotation(ClassVisitor cv, InstrumentationContext context) {
        AnnotationVisitor visitAnnotation = cv.visitAnnotation(Type.getDescriptor(InstrumentedClass.class), true);
        if (context.isUsingLegacyInstrumentation()) {
            visitAnnotation.visit("legacy", Boolean.TRUE);
        }
        if (context.hasModifiedClassStructure()) {
            visitAnnotation.visit("classStructureModified", Boolean.TRUE);
        }
        visitAnnotation.visitEnd();
        return cv;
    }

    private ClassVisitor addModifiedMethodAnnotation(ClassVisitor cv, final InstrumentationContext context, final ClassLoader loader) {
        return new ClassVisitor(589824, cv){
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                Method method = new Method(name, desc);
                if (context.isModified(method) && loader != null) {
                    Collection<String> instrumentationPackages;
                    PointCut pointCut;
                    TraceDetails traceDetails = context.getTraceInformation().getTraceAnnotations().get(method);
                    boolean dispatcher = false;
                    if (traceDetails != null) {
                        dispatcher = traceDetails.dispatcher();
                    }
                    AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(InstrumentedMethod.class), true);
                    av.visit("dispatcher", dispatcher);
                    ArrayList<String> instrumentationNames = new ArrayList<String>();
                    ArrayList<InstrumentationType> instrumentationTypes = new ArrayList<InstrumentationType>();
                    Level logLevel = Level.FINER;
                    if (traceDetails != null) {
                        if (traceDetails.instrumentationSourceNames() != null) {
                            instrumentationNames.addAll(traceDetails.instrumentationSourceNames());
                        }
                        if (traceDetails.instrumentationTypes() != null) {
                            for (InstrumentationType type : traceDetails.instrumentationTypes()) {
                                instrumentationTypes.add(type);
                            }
                        }
                        if (traceDetails.isCustom()) {
                            logLevel = Level.FINE;
                        }
                    }
                    if ((pointCut = context.getOldStylePointCut(method)) != null) {
                        instrumentationNames.add(pointCut.getClass().getName());
                        instrumentationTypes.add(InstrumentationType.Pointcut);
                    }
                    if ((instrumentationPackages = context.getMergeInstrumentationPackages(method)) != null && !instrumentationPackages.isEmpty()) {
                        for (String string : instrumentationPackages) {
                            instrumentationNames.add(string);
                            instrumentationTypes.add(InstrumentationType.WeaveInstrumentation);
                        }
                    }
                    if (instrumentationNames.size() == 0) {
                        instrumentationNames.add("Unknown");
                        Agent.LOG.finest("Unknown instrumentation source for " + this.className + '.' + method);
                    }
                    if (instrumentationTypes.size() == 0) {
                        instrumentationTypes.add(InstrumentationType.Unknown);
                        Agent.LOG.finest("Unknown instrumentation type for " + this.className + '.' + method);
                    }
                    AnnotationVisitor visitArrayName = av.visitArray("instrumentationNames");
                    for (String string : instrumentationNames) {
                        visitArrayName.visit("", string);
                    }
                    visitArrayName.visitEnd();
                    AnnotationVisitor annotationVisitor = av.visitArray("instrumentationTypes");
                    for (InstrumentationType type : instrumentationTypes) {
                        annotationVisitor.visitEnum("", Type.getDescriptor(InstrumentationType.class), type.toString());
                    }
                    annotationVisitor.visitEnd();
                    av.visitEnd();
                    if (Agent.LOG.isLoggable(logLevel)) {
                        Agent.LOG.log(logLevel, "Instrumented " + Type.getObjectType(this.className).getClassName() + '.' + method + ", " + instrumentationTypes + ", " + instrumentationNames);
                    }
                }
                return mv;
            }
        };
    }
}

