/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScalaTraitMatcher
implements ClassMatchVisitorFactory {
    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(589824, cv){
            private boolean isScalaSource;
            private List<String> interfaces;
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.interfaces = interfaces != null ? Arrays.asList(interfaces) : new ArrayList<String>();
                this.className = name;
            }

            @Override
            public void visitSource(String source2, String debug) {
                super.visitSource(source2, debug);
                this.isScalaSource = source2.endsWith(".scala");
            }

            @Override
            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                if (this.isScalaSource && this.interfaces.size() > 0) {
                    mv = new MethodVisitor(589824, mv){

                        @Override
                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (itf && opcode == 184 && (methodName + "$").equals(name) && !owner.equalsIgnoreCase(className)) {
                                context.putMatch(ScalaTraitMatcher.this, null);
                                context.addSkipMethod(new Method(methodName, methodDesc), owner);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        };
    }
}

