/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Remapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.Weave;
import com.newrelic.api.agent.weaver.WeaveIntoAllMethods;
import com.newrelic.api.agent.weaver.WeaveWithAnnotation;
import com.newrelic.api.agent.weaver.Weaver;
import com.newrelic.weave.MethodKey;
import com.newrelic.weave.utils.ClassFinder;
import com.newrelic.weave.utils.ClassInformationFinder;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.utils.PatchedClassWriter;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.SynchronizedMethodNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class WeaveUtils {
    public static final int ASM_API_LEVEL = 589824;
    public static final Remapper NO_OP_REMAPPER = new Remapper(){};
    public static final String INIT_NAME = "<init>";
    public static final String INIT_DESC = "()V";
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final Type WEAVER_TYPE = Type.getType(Weaver.class);
    public static final Method CALL_ORIGINAL_METHOD = new Method("callOriginal", Type.getType(Object.class), new Type[0]);
    public static final Method CLASS_ANNOTATION_GETTER = new Method("getClassAnnotation", Type.getType(Annotation.class), new Type[]{Type.getType(Class.class)});
    public static final Method METHOD_ANNOTATION_GETTER = new Method("getMethodAnnotation", Type.getType(Annotation.class), new Type[]{Type.getType(Class.class)});
    public static final String ANNOTATION_CLASSES_ATTRIBUTE_KEY = "annotationClasses";
    public static final String ANNOTATION_MATCH_TYPE_ATTRIBUTE_KEY = "type";
    public static final Type WEAVE_ALL_METHODS_TYPE = Type.getType(WeaveIntoAllMethods.class);
    public static final Type WEAVE_WITH_ANNOTATION_TYPE = Type.getType(WeaveWithAnnotation.class);
    public static final Method CLASS_INIT_METHOD = new Method("<clinit>", "()V");
    public static final Method DEFAULT_CONSTRUCTOR = new Method("<init>", "()V");
    public static final String JAVA_LANG_OBJECT_NAME = Type.getInternalName(Object.class);
    public static final ClassLoader BOOTSTRAP_PLACEHOLDER = new ClassLoader(null){};
    public static final Pattern SYNTHETIC_ACCESSOR_PATTERN = Pattern.compile("^access\\$[0-9]+$");
    public static final String INLINER_PREFIX = "INLINER_";
    public static final int RUNTIME_MAX_SUPPORTED_CLASS_VERSION = WeaveUtils.getRuntimeMaxSupportedClassVersion();
    public static final int JAVA_6_CLASS_VERSION = 50;
    public static final Set<MethodKey> METHODS_WE_NEVER_INSTRUMENT = ImmutableSet.of(new MethodKey("equals", "(Ljava/lang/Object;)Z"), new MethodKey("toString", "()Ljava/lang/String;"), new MethodKey("finalize", "()V"), new MethodKey("hashCode", "()I"), new MethodKey("clone", "()Ljava/lang/Object;"));
    private static final Map<Integer, String> HUMAN_READABLE_OPCODES = ImmutableMap.builder().put(1, "public").put(2, "private").put(4, "protected").put(8, "static").put(16, "final").put(32, "(synchronized|super)").put(64, "(bridge|volatile)").put(256, "native").put(512, "interface").put(1024, "abstract").put(2048, "strict").put(4096, "synthetic").put(8192, "annotation").put(16384, "enum").build();

    private static int getRuntimeMaxSupportedClassVersion() {
        try {
            double jvmSpecVersion = Double.valueOf(System.getProperty("java.specification.version"));
            if (jvmSpecVersion >= 11.0) {
                return 55;
            }
            if (jvmSpecVersion >= 1.8) {
                return 52;
            }
            if (jvmSpecVersion == 1.7) {
                return 51;
            }
            if (jvmSpecVersion == 1.6) {
                return 50;
            }
            if (jvmSpecVersion == 1.5) {
                return 49;
            }
            if (jvmSpecVersion == 1.4) {
                return 48;
            }
            if (jvmSpecVersion == 1.3) {
                return 47;
            }
            if (jvmSpecVersion == 1.2) {
                return 46;
            }
            if (jvmSpecVersion <= 1.1) {
                return 45;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private WeaveUtils() {
    }

    public static MethodNode findMatch(Collection<MethodNode> methodNodes, MethodNode queryNode) {
        return WeaveUtils.findMatch(methodNodes, queryNode.name, queryNode.desc);
    }

    public static MethodNode findMatch(Collection<MethodNode> methodNodes, Method queryMethod) {
        return WeaveUtils.findMatch(methodNodes, queryMethod.getName(), queryMethod.getDescriptor());
    }

    public static MethodNode findMatch(Collection<MethodNode> methodNodes, String name, String desc) {
        for (MethodNode searchNode : methodNodes) {
            if (!searchNode.name.equals(name) || !searchNode.desc.equals(desc)) continue;
            return searchNode;
        }
        return null;
    }

    public static FieldNode findMatch(Collection<FieldNode> fieldNodes, String name) {
        for (FieldNode fieldNode : fieldNodes) {
            if (!fieldNode.name.equals(name)) continue;
            return fieldNode;
        }
        return null;
    }

    public static FieldNode findRequiredMatch(Collection<FieldNode> fieldNodes, String name) {
        FieldNode result = WeaveUtils.findMatch(fieldNodes, name);
        if (result == null) {
            throw new IllegalArgumentException("Could not find required field name: " + name + " in specified collection.");
        }
        return result;
    }

    public static boolean isOriginalMethodInvocation(String owner, String name, String desc) {
        return owner.equals(WEAVER_TYPE.getInternalName()) && name.equals(CALL_ORIGINAL_METHOD.getName()) && desc.equals(CALL_ORIGINAL_METHOD.getDescriptor());
    }

    public static boolean isClassAnnotationGetter(String owner, String name, String desc) {
        return owner.equals(WEAVER_TYPE.getInternalName()) && name.equals(CLASS_ANNOTATION_GETTER.getName()) && desc.equals(CLASS_ANNOTATION_GETTER.getDescriptor());
    }

    public static boolean isMethodAnnotationGetter(String owner, String name, String desc) {
        return owner.equals(WEAVER_TYPE.getInternalName()) && name.equals(METHOD_ANNOTATION_GETTER.getName()) && desc.equals(METHOD_ANNOTATION_GETTER.getDescriptor());
    }

    public static boolean isNonstaticInnerClass(ClassNode classNode) {
        if (classNode.innerClasses != null) {
            for (InnerClassNode innerClassNode : classNode.innerClasses) {
                if ((innerClassNode.access & 8) != 0 || !innerClassNode.name.equals(classNode.name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnonymousInnerClass(InnerClassNode innerClassNode) {
        return innerClassNode.innerName == null;
    }

    public static boolean isSyntheticAccessor(String methodName) {
        return SYNTHETIC_ACCESSOR_PATTERN.matcher(methodName).matches();
    }

    public static Type getOuterClassType(ClassNode nestedClassNode) {
        if (nestedClassNode.innerClasses != null) {
            for (InnerClassNode innerClassNode : nestedClassNode.innerClasses) {
                if (!innerClassNode.name.equals(nestedClassNode.name)) continue;
                return Type.getType("L" + innerClassNode.outerName + ";");
            }
        }
        return null;
    }

    public static boolean isEmptyConstructor(MethodNode method) {
        if (!method.name.equals(INIT_NAME) || !method.desc.equals(INIT_DESC) || method.visibleAnnotations != null || method.invisibleAnnotations != null) {
            return false;
        }
        boolean init = false;
        boolean aload0 = true;
        int invokespecial = 2;
        int state = 0;
        InsnList instructions = method.instructions;
        int size = instructions.size();
        block5: for (int i = 0; i < size; ++i) {
            AbstractInsnNode node = instructions.get(i);
            switch (node.getOpcode()) {
                case 25: {
                    if (state != 0) {
                        return false;
                    }
                    state = 1;
                    continue block5;
                }
                case 183: {
                    if (state != 1) {
                        return false;
                    }
                    state = 2;
                    continue block5;
                }
                case 177: {
                    return state == 2;
                }
                default: {
                    if (node.getType() == 15 || node.getType() == 8 || node.getType() == 14) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    public static MethodNode newMethodNode(MethodNode source2) {
        return new SynchronizedMethodNode(589824, source2.access, source2.name, source2.desc, source2.signature, source2.exceptions.toArray(new String[source2.exceptions.size()]));
    }

    public static ClassNode copyWithoutJSRInstructions(ClassNode source2) {
        SynchronizedClassNode result = new SynchronizedClassNode(589824);
        source2.accept(new ClassVisitor(589824, result){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
            }
        });
        return result;
    }

    public static MethodNode copy(MethodNode source2) {
        MethodNode result = WeaveUtils.newMethodNode(source2);
        source2.accept(result);
        return result;
    }

    public static ClassNode copyAndRename(ClassNode source2, final String oldName, final String newName) {
        SynchronizedClassNode result = new SynchronizedClassNode(589824);
        source2.accept(new ClassVisitor(589824, result){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name.equals(oldName) ? newName : name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(589824, methodVisitor){

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        super.visitFieldInsn(opcode, owner.equals(oldName) ? newName : owner, name, desc);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        super.visitMethodInsn(opcode, owner.equals(oldName) ? newName : owner, name, desc, itf);
                    }

                    @Override
                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof Type && oldName.equals(((Type)cst).getInternalName())) {
                            super.visitLdcInsn(Type.getType("L" + newName + ";"));
                            return;
                        }
                        super.visitLdcInsn(cst);
                    }

                    @Override
                    public void visitTypeInsn(int opcode, String type) {
                        if (oldName.equals(type)) {
                            super.visitTypeInsn(opcode, newName);
                            return;
                        }
                        super.visitTypeInsn(opcode, type);
                    }
                };
            }
        });
        return result;
    }

    public static ClassNode convertToClassNode(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        SynchronizedClassNode result = new SynchronizedClassNode(589824);
        reader.accept(result, 4);
        return result;
    }

    public static byte[] convertToClassBytes(ClassNode classNode, ClassInformationFinder classInfoFinder) {
        PatchedClassWriter cw = new PatchedClassWriter(2, classInfoFinder);
        classNode.accept(cw);
        return cw.toByteArray();
    }

    public static byte[] getClassBytesFromClassFinder(String classname, ClassFinder finder) throws IOException {
        URL location = finder.findResource(classname);
        if (null == location) {
            return null;
        }
        InputStream is = location.openStream();
        return Streams.read(is, true);
    }

    public static byte[] getClassBytesFromClassLoaderResource(String classname, ClassLoader classloader) throws IOException {
        ClassLoaderFinder cf = new ClassLoaderFinder(classloader);
        return WeaveUtils.getClassBytesFromClassFinder(classname, cf);
    }

    public static boolean isPrivateOrProtected(int access) {
        return (access & 4) != 0 || (access & 2) != 0;
    }

    public static LabelNode makeLabelNode() {
        LabelNode labelNode = new LabelNode();
        labelNode.getLabel().info = labelNode;
        return labelNode;
    }

    public static MethodNode getMethodNode(ClassNode classnode, String methodName, String methodDesc) {
        for (MethodNode method : classnode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static boolean flagsMatch(int access1, int access2, int ... opcodes) {
        for (int opcode : opcodes) {
            if ((opcode & access1) != 0 == ((opcode & access2) != 0)) continue;
            return false;
        }
        return true;
    }

    public static String humanReadableAccessFlags(int[] opcodes) {
        int sum = 0;
        for (int opcode : opcodes) {
            sum += opcode;
        }
        return WeaveUtils.humanReadableAccessFlags(sum);
    }

    public static String humanReadableAccessFlags(int opcodes) {
        String humanReadableFlags = "";
        for (int supportedOpcode : HUMAN_READABLE_OPCODES.keySet()) {
            if (!WeaveUtils.flagsMatch(supportedOpcode, opcodes, supportedOpcode)) continue;
            if (humanReadableFlags.length() > 0) {
                humanReadableFlags = humanReadableFlags + ",";
            }
            humanReadableFlags = humanReadableFlags + HUMAN_READABLE_OPCODES.get(supportedOpcode);
            opcodes ^= supportedOpcode;
        }
        if (opcodes != 0) {
            if (humanReadableFlags.length() > 0) {
                humanReadableFlags = humanReadableFlags + ",";
            }
            humanReadableFlags = humanReadableFlags + "UnknownRemaingFlags=" + opcodes;
        }
        return humanReadableFlags;
    }

    public static boolean isWeavedClass(ClassReader reader) {
        final boolean[] weaved = new boolean[]{false};
        reader.accept(new ClassVisitor(589824){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (Type.getDescriptor(Weave.class).equals(desc)) {
                    weaved[0] = true;
                }
                return null;
            }
        }, 1);
        return weaved[0];
    }

    public static void updateClassVersion(ClassNode node) {
        if (node.version < RUNTIME_MAX_SUPPORTED_CLASS_VERSION) {
            node.version = RUNTIME_MAX_SUPPORTED_CLASS_VERSION;
        }
    }

    public static String getClassResourceName(String binaryName) {
        if (binaryName.endsWith(".class")) {
            return binaryName;
        }
        return binaryName.replace('.', '/') + ".class";
    }

    public static String getClassInternalName(String binaryName) {
        return binaryName.replaceFirst("\\.class$", "").replace('.', '/');
    }

    public static String getClassBinaryName(String resourceName) {
        return resourceName.replaceFirst("\\.class$", "").replace('/', '.');
    }

    public static boolean isConstructor(String methodName) {
        return INIT_NAME.equals(methodName);
    }

    public static boolean isMain(int access, String methodName, String methodDesc) {
        return (access & 1) == 1 && (access & 8) == 8 && "main".equals(methodName) && "([Ljava/lang/String;)V".equals(methodDesc);
    }

    public static boolean isStaticInitializer(String methodName) {
        return CLASS_INIT_NAME.equals(methodName);
    }

    public static MethodInsnNode getUnboxingInstruction(Type returnType) {
        if (Type.INT_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Integer.class), "intValue", "()I", false);
        }
        if (Type.BOOLEAN_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", "()Z", false);
        }
        if (Type.CHAR_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Character.class), "charValue", "()C", false);
        }
        if (Type.BYTE_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Byte.class), "byteValue", "()B", false);
        }
        if (Type.SHORT_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Short.class), "shortValue", "()S", false);
        }
        if (Type.FLOAT_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Float.class), "floatValue", "()F", false);
        }
        if (Type.LONG_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Long.class), "longValue", "()J", false);
        }
        if (Type.DOUBLE_TYPE.equals(returnType)) {
            return new MethodInsnNode(182, Type.getInternalName(Double.class), "doubleValue", "()D", false);
        }
        return null;
    }

    public static String getClassInternalName(Type type) {
        if (Type.INT_TYPE.equals(type)) {
            return Type.getInternalName(Integer.class);
        }
        if (Type.BOOLEAN_TYPE.equals(type)) {
            return Type.getInternalName(Boolean.class);
        }
        if (Type.CHAR_TYPE.equals(type)) {
            return Type.getInternalName(Character.class);
        }
        if (Type.BYTE_TYPE.equals(type)) {
            return Type.getInternalName(Byte.class);
        }
        if (Type.SHORT_TYPE.equals(type)) {
            return Type.getInternalName(Short.class);
        }
        if (Type.FLOAT_TYPE.equals(type)) {
            return Type.getInternalName(Float.class);
        }
        if (Type.LONG_TYPE.equals(type)) {
            return Type.getInternalName(Long.class);
        }
        if (Type.DOUBLE_TYPE.equals(type)) {
            return Type.getInternalName(Double.class);
        }
        return type.getInternalName();
    }

    public static int getReturnOpcodeForReturnType(Type returnType) {
        if (Type.INT_TYPE.equals(returnType)) {
            return 172;
        }
        if (Type.BOOLEAN_TYPE.equals(returnType)) {
            return 172;
        }
        if (Type.CHAR_TYPE.equals(returnType)) {
            return 172;
        }
        if (Type.BYTE_TYPE.equals(returnType)) {
            return 172;
        }
        if (Type.SHORT_TYPE.equals(returnType)) {
            return 172;
        }
        if (Type.FLOAT_TYPE.equals(returnType)) {
            return 174;
        }
        if (Type.LONG_TYPE.equals(returnType)) {
            return 173;
        }
        if (Type.DOUBLE_TYPE.equals(returnType)) {
            return 175;
        }
        if (Type.VOID_TYPE.equals(returnType)) {
            return 177;
        }
        return 176;
    }

    public static AbstractInsnNode getCheckCastInstruction(String classInternalName) {
        if (Type.getInternalName(Object.class).equals(classInternalName)) {
            return null;
        }
        return new TypeInsnNode(192, classInternalName);
    }

    public static List<LabelNode> findLabels(InsnList instructions) {
        ArrayList<LabelNode> labels = new ArrayList<LabelNode>();
        for (AbstractInsnNode instructionNode = instructions.getFirst(); instructionNode != null; instructionNode = instructionNode.getNext()) {
            if (!(instructionNode instanceof LabelNode)) continue;
            labels.add((LabelNode)instructionNode);
        }
        return labels;
    }

    public static List<AnnotationNode> getMethodAnnotations(MethodNode method) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (method.invisibleAnnotations != null) {
            annotations.addAll(method.invisibleAnnotations);
        }
        if (method.visibleAnnotations != null) {
            annotations.addAll(method.visibleAnnotations);
        }
        return annotations;
    }

    public static List<AnnotationNode> getClassAnnotations(ClassNode classNode) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (classNode.invisibleAnnotations != null) {
            annotations.addAll(classNode.invisibleAnnotations);
        }
        if (classNode.visibleAnnotations != null) {
            annotations.addAll(classNode.visibleAnnotations);
        }
        return annotations;
    }

    public static List<AnnotationNode> getMethodAnnotations(ClassNode classNode) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.invisibleAnnotations != null) {
                annotations.addAll(methodNode.invisibleAnnotations);
            }
            if (methodNode.visibleAnnotations == null) continue;
            annotations.addAll(methodNode.visibleAnnotations);
        }
        return annotations;
    }

    public static Set<String> getMethodRequiredAnnotations(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (AnnotationNode visibleAnnotation : annotations) {
            if (!WEAVE_WITH_ANNOTATION_TYPE.getDescriptor().equals(visibleAnnotation.desc)) continue;
            List<Object> values2 = visibleAnnotation.values;
            for (int i = 0; i < values2.size(); i += 2) {
                if (!values2.get(i).equals(ANNOTATION_CLASSES_ATTRIBUTE_KEY)) continue;
                result.addAll((List)values2.get(i + 1));
            }
        }
        return result;
    }

    public static boolean isWeaveWithAnnotationInterfaceMatch(ClassNode classNode) {
        List<AnnotationNode> classAnnotationNodes = WeaveUtils.getClassAnnotations(classNode);
        for (AnnotationNode classAnnotationNode : classAnnotationNodes) {
            if (!WEAVE_WITH_ANNOTATION_TYPE.getDescriptor().equals(classAnnotationNode.desc)) continue;
            List<Object> values2 = classAnnotationNode.values;
            for (int i = 0; i < values2.size(); i += 2) {
                if (!values2.get(i).equals(ANNOTATION_MATCH_TYPE_ATTRIBUTE_KEY) || !MatchType.Interface.name().equals(((String[])values2.get(i + 1))[1])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasWeaveIntoAllMethodsAnnotation(MethodNode methodNode) {
        List<AnnotationNode> methodAnnotations = WeaveUtils.getMethodAnnotations(methodNode);
        for (AnnotationNode methodAnnotation : methodAnnotations) {
            if (!WEAVE_ALL_METHODS_TYPE.getDescriptor().equals(methodAnnotation.desc)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRequiredAnnotations(MethodNode originalMethod, Set<String> requiredMethodAnnotationClassNames) {
        List<AnnotationNode> methodAnnotations = WeaveUtils.getMethodAnnotations(originalMethod);
        HashSet<String> methodAnnotationClassNames = new HashSet<String>();
        for (AnnotationNode methodAnnotation : methodAnnotations) {
            methodAnnotationClassNames.add(Type.getType(methodAnnotation.desc).getClassName());
        }
        return WeaveUtils.hasRequiredAnnotations(methodAnnotationClassNames, requiredMethodAnnotationClassNames);
    }

    public static boolean hasRequiredAnnotations(Set<String> methodAnnotationClassNames, Set<String> requiredMethodAnnotationClassNames) {
        methodAnnotationClassNames.retainAll(requiredMethodAnnotationClassNames);
        return !methodAnnotationClassNames.isEmpty();
    }

    public static boolean isMethodWeNeverInstrument(MethodNode originalMethod) {
        return METHODS_WE_NEVER_INSTRUMENT.contains(new MethodKey(originalMethod.name, originalMethod.desc));
    }
}

