/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.ServerCommandException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.metric.MetricIdRegistry;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class HarvestServiceImpl
extends AbstractService
implements HarvestService {
    public static final String HARVEST_THREAD_NAME = "New Relic Harvest Service";
    public static final String FASTER_HARVEST_THREAD_NAME = "New Relic Faster Harvest Service";
    private static final long INITIAL_DELAY_IN_MILLISECONDS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private static final long REPORTING_PERIOD_IN_MILLISECONDS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private static final long MIN_HARVEST_INTERVAL_IN_NANOSECONDS = TimeUnit.NANOSECONDS.convert(55L, TimeUnit.SECONDS);
    private static final String HARVEST_LIMITS = "harvest_limits";
    private static final String REPORT_PERIOD_MS = "report_period_ms";
    private final ScheduledExecutorService scheduledHarvestExecutor;
    private final ScheduledExecutorService scheduledFasterHarvestExecutor;
    private final List<HarvestListener> harvestListeners = new CopyOnWriteArrayList<HarvestListener>();
    private final Map<IRPMService, HarvestTask> harvestTasks = new HashMap<IRPMService, HarvestTask>();
    private final ConcurrentMap<Harvestable, HarvestableTracker> harvestables = new ConcurrentHashMap<Harvestable, HarvestableTracker>();
    private long overrideInitialDelay = -1L;

    public HarvestServiceImpl() {
        super(HarvestService.class.getSimpleName());
        this.scheduledHarvestExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory(HARVEST_THREAD_NAME, true));
        this.scheduledFasterHarvestExecutor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory(FASTER_HARVEST_THREAD_NAME, true));
        ServiceFactory.getRPMServiceManager().addConnectionListener(new ConnectionListenerImpl());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void startHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.getOrCreateHarvestTask(rpmService);
        harvestTask.start();
    }

    @VisibleForTesting
    public void startHarvestables(IRPMService rpmService, AgentConfig config) {
        Map eventHarvestConfig = (Map)config.getProperty("event_harvest_config");
        Map spanHarvestConfig = (Map)config.getProperty("span_event_harvest_config");
        if (eventHarvestConfig == null) {
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/Agent/Collector/MissingEventHarvestConfig", 1), "Supportability/Agent/Collector/MissingEventHarvestConfig");
        }
        for (HarvestableTracker tracker : this.harvestables.values()) {
            if (!tracker.harvestable.getAppName().equals(rpmService.getApplicationName())) continue;
            int maxSamplesStored = tracker.harvestable.getMaxSamplesStored();
            long reportPeriodInMillis = REPORTING_PERIOD_IN_MILLISECONDS;
            boolean isSpanEventEndpoint = tracker.harvestable.getEndpointMethodName().equals("span_event_data");
            if (eventHarvestConfig != null && !isSpanEventEndpoint) {
                Agent.LOG.log(Level.FINE, "event_harvest_config from collector for {0} is: {1} max samples stored per minute", tracker.harvestable.getEndpointMethodName(), maxSamplesStored);
                Map harvestLimits = (Map)eventHarvestConfig.get(HARVEST_LIMITS);
                Long harvestLimit = (Long)harvestLimits.get(tracker.harvestable.getEndpointMethodName());
                if (harvestLimit != null) {
                    maxSamplesStored = harvestLimit.intValue();
                    reportPeriodInMillis = (Long)eventHarvestConfig.get(REPORT_PERIOD_MS);
                    float reportPeriodInSeconds = reportPeriodInMillis / 1000L;
                    if (maxSamplesStored == 0) {
                        Agent.LOG.log(Level.INFO, "harvest limit has been disabled by the collector for {0}", tracker.harvestable.getEndpointMethodName());
                    }
                    Agent.LOG.log(Level.FINE, "harvest limit from collector for {0} is: {1} max samples stored per every {2} second harvest", tracker.harvestable.getEndpointMethodName(), harvestLimit, Float.valueOf(reportPeriodInSeconds));
                    ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/EventHarvest/ReportPeriod", reportPeriodInSeconds), "Supportability/EventHarvest/ReportPeriod");
                }
            } else if (!isSpanEventEndpoint) {
                Agent.LOG.log(Level.FINE, "event_harvest_config from collector for {0} was null. Using default value: {1} max samples stored per minute", tracker.harvestable.getEndpointMethodName(), maxSamplesStored);
            }
            if (spanHarvestConfig != null && isSpanEventEndpoint) {
                Agent.LOG.log(Level.FINE, "span_event_harvest_config from collector for {0} is: {1} max samples stored per minute", tracker.harvestable.getEndpointMethodName(), maxSamplesStored);
                Long harvestLimit = (Long)spanHarvestConfig.get("harvest_limit");
                if (harvestLimit != null) {
                    maxSamplesStored = harvestLimit.intValue();
                    reportPeriodInMillis = (Long)spanHarvestConfig.get(REPORT_PERIOD_MS);
                    float reportPeriodInSeconds = reportPeriodInMillis / 1000L;
                    Agent.LOG.log(Level.FINE, "harvest limit from collector for {0} is: {1} max samples stored per every {2} second harvest", tracker.harvestable.getEndpointMethodName(), harvestLimit, Float.valueOf(reportPeriodInSeconds));
                }
            } else if (isSpanEventEndpoint) {
                Agent.LOG.log(Level.FINE, "span_event_harvest_config from collector for {0} was null. Using default value: {1} max samples stored per minute", tracker.harvestable.getEndpointMethodName(), maxSamplesStored);
            }
            tracker.start(reportPeriodInMillis, maxSamplesStored);
        }
    }

    @Override
    public void stopHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.remove(rpmService);
        if (harvestTask != null) {
            harvestTask.stop();
        }
    }

    private synchronized HarvestTask getOrCreateHarvestTask(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.get(rpmService);
        if (harvestTask == null) {
            harvestTask = new HarvestTask(rpmService);
            this.harvestTasks.put(rpmService, harvestTask);
        }
        return harvestTask;
    }

    private synchronized List<HarvestTask> getHarvestTasks() {
        return new ArrayList<HarvestTask>(this.harvestTasks.values());
    }

    @Override
    public void addHarvestable(Harvestable harvestable) {
        HarvestableTracker existing = this.harvestables.putIfAbsent(harvestable, new HarvestableTracker(harvestable));
        if (existing != null) {
            Agent.LOG.log(Level.SEVERE, "Harvestable already added to the harvest service: {0}", harvestable);
            existing.stop();
        }
    }

    @Override
    public void removeHarvestable(Harvestable harvestable) {
        HarvestableTracker tracker;
        if (harvestable != null && (tracker = (HarvestableTracker)this.harvestables.remove(harvestable)) != null) {
            tracker.stop();
        }
    }

    @Override
    public void removeHarvestablesByAppName(String appName) {
        for (HarvestableTracker tracker : this.harvestables.values()) {
            if (!tracker.harvestable.getAppName().equals(appName)) continue;
            this.harvestables.remove(tracker.harvestable);
            if (tracker == null) continue;
            tracker.stop();
        }
    }

    @Override
    public void addHarvestListener(HarvestListener listener) {
        this.harvestListeners.add(listener);
    }

    @Override
    public void removeHarvestListener(HarvestListener listener) {
        this.harvestListeners.remove(listener);
    }

    @Override
    protected void doStop() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.stop();
        }
        for (HarvestableTracker h2 : this.harvestables.values()) {
            h2.stop();
        }
        this.scheduledHarvestExecutor.shutdown();
        this.scheduledFasterHarvestExecutor.shutdown();
    }

    private ScheduledFuture<?> scheduleHarvestTask(HarvestTask harvestTask) {
        return this.scheduledHarvestExecutor.scheduleAtFixedRate(SafeWrappers.safeRunnable(harvestTask), this.getInitialDelay(), this.getReportingPeriod(), TimeUnit.MILLISECONDS);
    }

    public long getInitialDelay() {
        return this.overrideInitialDelay <= 0L ? INITIAL_DELAY_IN_MILLISECONDS : this.overrideInitialDelay;
    }

    @VisibleForTesting
    public void setInitialDelayMillis(long millis) {
        this.overrideInitialDelay = millis;
    }

    public long getReportingPeriod() {
        return REPORTING_PERIOD_IN_MILLISECONDS;
    }

    public long getMinHarvestInterval() {
        return MIN_HARVEST_INTERVAL_IN_NANOSECONDS;
    }

    @Override
    public void harvestNow() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            for (HarvestableTracker h2 : this.harvestables.values()) {
                h2.harvestable.harvest();
            }
            task.harvestNow();
        }
    }

    @Override
    public Map<String, Object> getEventDataHarvestLimits() {
        HashMap<String, Object> eventHarvest = new HashMap<String, Object>();
        HashMap<String, Integer> harvestLimits = new HashMap<String, Integer>();
        eventHarvest.put(HARVEST_LIMITS, harvestLimits);
        for (Harvestable harvestable : this.harvestables.keySet()) {
            harvestLimits.put(harvestable.getEndpointMethodName(), harvestable.getMaxSamplesStored());
        }
        return eventHarvest;
    }

    private void reportHarvest(String appName, StatsEngine statsEngine, IRPMService rpmService) {
        try {
            rpmService.harvest(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error reporting harvest data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerBeforeHarvest(String appName, StatsEngine statsEngine, HarvestListener listener) {
        try {
            listener.beforeHarvest(appName, statsEngine);
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerAfterHarvest(String appName, HarvestListener listener) {
        try {
            listener.afterHarvest(appName);
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connected(IRPMService rpmService, AgentConfig agentConfig) {
            HarvestServiceImpl.this.startHarvest(rpmService);
            HarvestServiceImpl.this.startHarvestables(rpmService, agentConfig);
        }

        @Override
        public void disconnected(IRPMService rpmService) {
            for (HarvestableTracker h2 : HarvestServiceImpl.this.harvestables.values()) {
                h2.stop();
            }
        }
    }

    private class HarvestableTracker {
        private final Harvestable harvestable;
        private final List<ScheduledFuture<?>> tasks = new ArrayList();

        public HarvestableTracker(Harvestable harvestable) {
            this.harvestable = harvestable;
        }

        public synchronized void start(long reportPeriodInMillis, int maxSamplesStored) {
            this.stop();
            this.harvestable.configure(reportPeriodInMillis, maxSamplesStored);
            Runnable harvestTask = new Runnable(){

                @Override
                public void run() {
                    HarvestServiceImpl.this.getLogger().log(Level.FINER, "Harvestable: {0}/{1} running", HarvestableTracker.this.harvestable.getAppName(), HarvestableTracker.this.harvestable.getEndpointMethodName());
                    HarvestableTracker.this.harvestable.harvest();
                }
            };
            this.tasks.add(HarvestServiceImpl.this.scheduledFasterHarvestExecutor.scheduleAtFixedRate(SafeWrappers.safeRunnable(harvestTask), 0L, reportPeriodInMillis, TimeUnit.MILLISECONDS));
        }

        public synchronized void stop() {
            for (ScheduledFuture<?> task : this.tasks) {
                task.cancel(false);
            }
            this.tasks.clear();
        }
    }

    private final class HarvestTask
    implements Runnable {
        private final IRPMService rpmService;
        private ScheduledFuture<?> task;
        private final Lock harvestLock = new ReentrantLock();
        private StatsEngine lastStatsEngine = new StatsEngineImpl();
        private long lastHarvestStartTime;

        private HarvestTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        @Override
        public void run() {
            try {
                if (this.shouldHarvest()) {
                    this.harvest();
                }
            }
            catch (Throwable t2) {
                String msg = MessageFormat.format("Unexpected exception during harvest: {0}", t2);
                if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                    HarvestServiceImpl.this.getLogger().log(Level.WARNING, msg, t2);
                }
                HarvestServiceImpl.this.getLogger().warning(msg);
            }
        }

        private boolean shouldHarvest() {
            return System.nanoTime() - this.lastHarvestStartTime >= HarvestServiceImpl.this.getMinHarvestInterval();
        }

        private synchronized void start() {
            if (!this.isRunning()) {
                this.stop();
                String msg = MessageFormat.format("Scheduling harvest task for {0}", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().log(Level.FINE, msg);
                this.task = HarvestServiceImpl.this.scheduleHarvestTask(this);
            }
        }

        private synchronized void stop() {
            if (this.task != null) {
                HarvestServiceImpl.this.getLogger().fine(MessageFormat.format("Cancelling harvest task for {0}", this.rpmService.getApplicationName()));
                this.task.cancel(false);
            }
        }

        private boolean isRunning() {
            if (this.task == null) {
                return false;
            }
            return !this.task.isCancelled() || this.task.isDone();
        }

        private void harvestNow() {
            if (this.rpmService.isConnected()) {
                String msg = MessageFormat.format("Sending metrics for {0} immediately", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().info(msg);
                this.harvest();
            }
        }

        private void harvest() {
            this.harvestLock.lock();
            try {
                this.doHarvest();
            }
            catch (IgnoreSilentlyException | ServerCommandException exception) {
            }
            catch (Throwable e) {
                HarvestServiceImpl.this.getLogger().log(Level.INFO, "Error sending metric data for {0}: {1}", this.rpmService.getApplicationName(), e.toString());
            }
            finally {
                this.harvestLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHarvest() throws Exception {
            long duration;
            this.lastHarvestStartTime = System.nanoTime();
            String appName = this.rpmService.getApplicationName();
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Starting harvest for {0}", appName);
                HarvestServiceImpl.this.getLogger().fine(msg);
                Iterator linkText = this.rpmService.getApplicationLink();
                String version = Agent.getVersion();
                String reportingToAndVersion = MessageFormat.format("Application link: {0}, Agent version: {1}", linkText, version);
                HarvestServiceImpl.this.getLogger().fine(reportingToAndVersion);
            }
            StatsEngine harvestStatsEngine = ServiceFactory.getStatsService().getStatsEngineForHarvest(appName);
            harvestStatsEngine.mergeStats(this.lastStatsEngine);
            try {
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerBeforeHarvest(appName, harvestStatsEngine, listener);
                }
                HarvestServiceImpl.this.reportHarvest(appName, harvestStatsEngine, this.rpmService);
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerAfterHarvest(appName, listener);
                }
                if (harvestStatsEngine.getSize() > MetricIdRegistry.METRIC_LIMIT) {
                    harvestStatsEngine.clear();
                }
                this.lastStatsEngine = harvestStatsEngine;
                duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                if (harvestStatsEngine.getSize() > MetricIdRegistry.METRIC_LIMIT) {
                    harvestStatsEngine.clear();
                }
                this.lastStatsEngine = harvestStatsEngine;
                long duration2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration2, TimeUnit.MILLISECONDS);
                if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                    String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration2);
                    HarvestServiceImpl.this.getLogger().fine(msg);
                }
                throw throwable;
            }
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration);
                HarvestServiceImpl.this.getLogger().fine(msg);
            }
        }
    }
}

