/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.SqlTraceConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;

public final class SqlTraceConfigImpl
extends BaseConfig
implements SqlTraceConfig {
    public static final String ENABLED = "enabled";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String USE_LONGER_SQL_ID = "use_longer_sql_id";
    public static final boolean DEFAULT_USE_LONGER_SQL_ID = false;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.slow_sql.";
    private final boolean isEnabled = this.getProperty("enabled", true);
    private final boolean isUsingLongerSqlId = this.getProperty("use_longer_sql_id", false);

    private SqlTraceConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isUsingLongerSqlId() {
        return this.isUsingLongerSqlId;
    }

    @VisibleForTesting
    public static SqlTraceConfig createSqlTraceConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new SqlTraceConfigImpl(settings);
    }
}

