/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling;

import com.newrelic.agent.deps.org.apache.logging.log4j.core.LifeCycle;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LifeCycle2;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LogEvent;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@Plugin(name="Policies", category="Core", printObject=true)
public final class CompositeTriggeringPolicy
extends AbstractTriggeringPolicy {
    private final TriggeringPolicy[] triggeringPolicies;

    private CompositeTriggeringPolicy(TriggeringPolicy ... triggeringPolicies) {
        this.triggeringPolicies = triggeringPolicies;
    }

    public TriggeringPolicy[] getTriggeringPolicies() {
        return this.triggeringPolicies;
    }

    @Override
    public void initialize(RollingFileManager manager) {
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            LOGGER.debug("Initializing triggering policy {}", (Object)triggeringPolicy.toString());
            triggeringPolicy.initialize(manager);
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            if (!triggeringPolicy.isTriggeringEvent(event)) continue;
            return true;
        }
        return false;
    }

    @PluginFactory
    public static CompositeTriggeringPolicy createPolicy(TriggeringPolicy ... triggeringPolicy) {
        return new CompositeTriggeringPolicy(triggeringPolicy);
    }

    @Override
    public boolean stop(long timeout2, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = true;
        for (TriggeringPolicy triggeringPolicy : this.triggeringPolicies) {
            if (triggeringPolicy instanceof LifeCycle2) {
                stopped &= ((LifeCycle2)((Object)triggeringPolicy)).stop(timeout2, timeUnit);
                continue;
            }
            if (!(triggeringPolicy instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)triggeringPolicy)).stop();
            stopped &= true;
        }
        this.setStopped();
        return stopped;
    }

    public String toString() {
        return "CompositeTriggeringPolicy(policies=" + Arrays.toString(this.triggeringPolicies) + ")";
    }
}

