/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.custom;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.custom.ScalaTraitFinalFieldVisitor;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;

public class ScalaTraitFinalFieldTransformer
implements ContextClassTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        try {
            return this.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context);
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINE, "Unable to transform class " + className, t2);
            return null;
        }
    }

    private byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context) {
        ClassWriter writer;
        if (context.getScalaFinalFields().isEmpty()) {
            return null;
        }
        Agent.LOG.debug("Instrumenting class " + className);
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassVisitor cv = writer = new ClassWriter(2);
        cv = new ScalaTraitFinalFieldVisitor(cv, context.getScalaFinalFields());
        reader.accept(cv, 4);
        return writer.toByteArray();
    }
}

