/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.struts;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.struts.ActionProxy;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class Struts2ActionPointCut
extends TracerFactoryPointCut {
    public static final String STRUTS_ACTION__PROXY_INTERFACE = "com/opensymphony/xwork2/ActionProxy";
    private static final MethodMatcher METHOD_MATCHER = Struts2ActionPointCut.createExactMethodMatcher("execute", "()Ljava/lang/String;");

    public Struts2ActionPointCut(PointCutClassTransformer classTransformer) {
        super(Struts2ActionPointCut.class, (ClassMatcher)new InterfaceMatcher(STRUTS_ACTION__PROXY_INTERFACE), METHOD_MATCHER);
    }

    @Override
    public Tracer doGetTracer(Transaction tx, ClassMethodSignature sig, Object action, Object[] args2) {
        try {
            String realAction = action instanceof ActionProxy ? ((ActionProxy)action).getActionName() : (String)action.getClass().getMethod("getActionName", new Class[0]).invoke(action, new Object[0]);
            this.setTransactionName(tx, realAction);
            return new DefaultTracer(tx, sig, action, new SimpleMetricNameFormat("StrutsAction/" + realAction));
        }
        catch (Exception e) {
            return new DefaultTracer(tx, sig, action, new ClassMethodMetricNameFormat(sig, action, "StrutsAction"));
        }
    }

    private void setTransactionName(Transaction tx, String action) {
        if (!tx.isTransactionNamingEnabled()) {
            return;
        }
        TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(tx, TransactionNamePriority.FRAMEWORK)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Struts 2 action", action);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(tx, action, "StrutsAction", TransactionNamePriority.FRAMEWORK);
    }
}

