/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.model;

import com.newrelic.agent.model.CountedDuration;

public class TransactionTiming {
    static final float UNASSIGNED_FLOAT = Float.NEGATIVE_INFINITY;
    private final float duration;
    private final float totalTime;
    private final float timeToFirstByte;
    private final float timeToLastByte;
    private final float queueDuration;
    private final float gcCumulative;
    private final CountedDuration external;
    private final CountedDuration database;

    private TransactionTiming(Builder builder) {
        this.duration = builder.duration;
        this.totalTime = builder.totalTime;
        this.timeToFirstByte = builder.timeToFirstByte;
        this.timeToLastByte = builder.timeToLastByte;
        this.queueDuration = builder.queueDuration;
        this.gcCumulative = builder.gcCumulative;
        this.external = builder.external;
        this.database = builder.database;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getTotalTime() {
        return this.totalTime;
    }

    public float getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    public float getTimeToLastByte() {
        return this.timeToLastByte;
    }

    public float getQueueDuration() {
        return this.queueDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public float getExternalCallCount() {
        return this.external.getCallCount();
    }

    public float getExternalDuration() {
        return this.external.getDuration();
    }

    public float getDatabaseCallCount() {
        return this.database.getCallCount();
    }

    public float getDatabaseDuration() {
        return this.database.getDuration();
    }

    public float getGcCumulative() {
        return this.gcCumulative;
    }

    public static class Builder {
        private float duration;
        private float totalTime;
        private float timeToFirstByte = Float.NEGATIVE_INFINITY;
        private float timeToLastByte = Float.NEGATIVE_INFINITY;
        private float queueDuration = Float.NEGATIVE_INFINITY;
        public float gcCumulative = Float.NEGATIVE_INFINITY;
        public CountedDuration external = CountedDuration.UNASSIGNED;
        public CountedDuration database = CountedDuration.UNASSIGNED;

        public Builder duration(float duration) {
            this.duration = duration;
            return this;
        }

        public Builder totalTime(float totalTime) {
            this.totalTime = totalTime;
            return this;
        }

        public Builder timeToFirstByte(float timeToFirstByte) {
            this.timeToFirstByte = timeToFirstByte;
            return this;
        }

        public Builder timeToLastByte(float timeToLastByte) {
            this.timeToLastByte = timeToLastByte;
            return this;
        }

        public Builder queueDuration(float queueDuration) {
            this.queueDuration = queueDuration;
            return this;
        }

        public Builder gcCumulative(float gcCumulative) {
            this.gcCumulative = gcCumulative;
            return this;
        }

        public Builder external(CountedDuration external) {
            this.external = external;
            return this;
        }

        public Builder database(CountedDuration database) {
            this.database = database;
            return this;
        }

        public TransactionTiming build() {
            return new TransactionTiming(this);
        }
    }
}

