/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;

public class CleverClassLoader
extends SecureClassLoader {
    public CleverClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassSpecial(String name) throws ClassNotFoundException, IOException {
        String fileName = name.replace('.', '/');
        fileName = fileName + ".class";
        InputStream inStream = AgentBridge.getAgent().getClass().getClassLoader().getResourceAsStream(fileName);
        if (inStream == null) {
            throw new ClassNotFoundException("Unable to find class " + name);
        }
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            Streams.copy(inStream, oStream);
            Class clazz = this.loadClass(name, oStream.toByteArray());
            return clazz;
        }
        finally {
            inStream.close();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.newrelic")) {
            try {
                return AgentBridge.getAgent().getClass().getClassLoader().loadClass(name);
            }
            catch (NoClassDefFoundError e) {
                try {
                    return this.loadClassSpecial(name);
                }
                catch (IOException e1) {
                    throw e;
                }
            }
        }
        return super.loadClass(name);
    }

    protected Class loadClass(String name, byte[] bytes) {
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

