/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.jfr.toevent.AttributeValueSplitter;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.jfr.toevent.JITCompilationMapper;
import com.newrelic.jfr.toevent.JVMInformationMapper;
import com.newrelic.jfr.toevent.JVMSystemPropertyMapper;
import com.newrelic.jfr.toevent.ThreadLockEventMapper;
import com.newrelic.jfr.toevent.ValhallaVBCDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToEventRegistry {
    private static final List<EventToEvent> ALL_MAPPERS = Arrays.asList(new JITCompilationMapper(), new JVMInformationMapper(), new JVMSystemPropertyMapper(new AttributeValueSplitter()), new ThreadLockEventMapper(), new ValhallaVBCDetector());
    private final List<EventToEvent> mappers;

    private ToEventRegistry(List<EventToEvent> mappers) {
        this.mappers = mappers;
    }

    public static ToEventRegistry createDefault() {
        return ToEventRegistry.create(ToEventRegistry.allEventNames());
    }

    public static ToEventRegistry create(Collection<String> eventNames) {
        List<EventToEvent> filtered = ALL_MAPPERS.stream().filter(mapper -> eventNames.contains(mapper.getEventName())).collect(Collectors.toList());
        return new ToEventRegistry(filtered);
    }

    private List<EventToEvent> getMappers() {
        return this.mappers;
    }

    private static List<String> allEventNames() {
        return ALL_MAPPERS.stream().map(EventToEvent::getEventName).collect(Collectors.toList());
    }

    public Stream<EventToEvent> all() {
        return this.mappers.stream();
    }

    public Optional<EventToEvent> get(String eventName) {
        return this.mappers.stream().filter(toEvent -> toEvent.getEventName().equals(eventName)).findFirst();
    }
}

