/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.weave.weavepackage.ErrorTrapHandler;
import com.newrelic.weave.weavepackage.ExtensionClassTemplate;
import com.newrelic.weave.weavepackage.WeavePostprocessor;
import com.newrelic.weave.weavepackage.WeavePreprocessor;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WeavePackageConfig {
    private final Instrumentation instrumentation;
    private final String name;
    private final String alias;
    private final String vendorId;
    private final float version;
    private final String source;
    private final boolean enabled;
    private final boolean custom;
    private final ClassNode errorHandleClassNode;
    private final WeavePreprocessor preprocessor;
    private final WeavePostprocessor postprocessor;
    private final ClassNode extensionClassTemplate;

    public static Builder builder() {
        return new Builder();
    }

    private WeavePackageConfig(String name, String alias, String vendorId, float version, boolean enabled, String source2, boolean custom, Instrumentation instrumentation, ClassNode errorTrapClassNode, WeavePreprocessor preprocessor, WeavePostprocessor postprocessor, ClassNode extensionClassTemplate) {
        this.name = name;
        this.alias = alias;
        this.vendorId = vendorId;
        this.version = version;
        this.enabled = enabled;
        this.source = source2;
        this.custom = custom;
        this.instrumentation = instrumentation;
        this.errorHandleClassNode = errorTrapClassNode;
        this.preprocessor = preprocessor;
        this.postprocessor = postprocessor;
        this.extensionClassTemplate = extensionClassTemplate;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public float getVersion() {
        return this.version;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public ClassNode getErrorHandleClassNode() {
        return this.errorHandleClassNode;
    }

    public WeavePreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public WeavePostprocessor getPostprocessor() {
        return this.postprocessor;
    }

    public ClassNode getExtensionTemplate() {
        return this.extensionClassTemplate;
    }

    public String toString() {
        return "WeavePackageConfig [name=" + this.name + ", version=" + this.version + ", enabled=" + this.enabled + "]";
    }

    public static class Builder {
        private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.?\\d*)(.*)");
        private String name = null;
        private Instrumentation instrumentation = null;
        private String alias = null;
        private String vendorId = null;
        private float version = 1.0f;
        private String source = null;
        private boolean enabled = true;
        private boolean custom = false;
        private ClassNode errorHandleClassNode = ErrorTrapHandler.NO_ERROR_TRAP_HANDLER;
        private WeavePreprocessor preprocessor = WeavePreprocessor.NO_PREPROCESSOR;
        private WeavePostprocessor postprocessor = WeavePostprocessor.NO_POSTPROCESSOR;
        private ClassNode extensionClassTemplate = ExtensionClassTemplate.DEFAULT_EXTENSION_TEMPLATE;

        public Builder name(String name) {
            if (null != name) {
                this.name = name;
            }
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            if (null != instrumentation) {
                this.instrumentation = instrumentation;
            }
            return this;
        }

        public Builder alias(String alias) {
            if (null != alias) {
                this.alias = alias;
            }
            return this;
        }

        public Builder vendorId(String vendorId) {
            if (null != vendorId) {
                this.vendorId = vendorId;
            }
            return this;
        }

        public Builder version(float version) {
            this.version = version;
            return this;
        }

        public Builder source(String source2) {
            if (null != source2) {
                this.source = source2;
            }
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder custom(boolean custom) {
            this.custom = custom;
            return this;
        }

        public Builder errorHandleClassNode(ClassNode errorHandleClassNode) {
            if (null != errorHandleClassNode) {
                this.errorHandleClassNode = errorHandleClassNode;
            }
            return this;
        }

        public Builder weavePreprocessor(WeavePreprocessor preprocessor) {
            if (null != preprocessor) {
                this.preprocessor = preprocessor;
            }
            return this;
        }

        public Builder weavePostprocessor(WeavePostprocessor postprocessor) {
            if (null != postprocessor) {
                this.postprocessor = postprocessor;
            }
            return this;
        }

        public Builder extensionClassTemplate(ClassNode extensionClassTemplate) {
            if (null != extensionClassTemplate) {
                if (ExtensionClassTemplate.isValidExtensionNode(extensionClassTemplate)) {
                    this.extensionClassTemplate = extensionClassTemplate;
                } else {
                    throw new RuntimeException("Invalid extensionClassNode!");
                }
            }
            return this;
        }

        public Builder url(URL jarURL) throws Exception {
            try (JarInputStream jarStream = new JarInputStream(jarURL.openStream());){
                Builder builder = this.jarInputStream(jarStream).source(jarURL.toString());
                return builder;
            }
        }

        public Builder jarInputStream(JarInputStream jarStream) throws Exception {
            if (jarStream.getManifest() == null) {
                throw new IOException("The instrumentation jar did not contain a manifest");
            }
            Attributes mainAttributes = jarStream.getManifest().getMainAttributes();
            String name = mainAttributes.getValue("Implementation-Title");
            if (name == null) {
                throw new Exception("The Implementation-Title of an instrumentation package is undefined");
            }
            String alias = mainAttributes.getValue("Implementation-Title-Alias");
            String vendorId = mainAttributes.getValue("Implementation-Vendor-Id");
            String implementationVersion = mainAttributes.getValue("Implementation-Version");
            float version = this.version;
            if (null != implementationVersion) {
                try {
                    Matcher matcher = VERSION_PATTERN.matcher(implementationVersion);
                    if (matcher.matches()) {
                        version = Float.parseFloat(matcher.group(1));
                    }
                }
                catch (NumberFormatException matcher) {
                    // empty catch block
                }
            }
            boolean enabled = this.enabled;
            String enabledS = mainAttributes.getValue("Enabled");
            if (null != enabledS) {
                enabled = Boolean.parseBoolean(enabledS);
            }
            return this.name(name).alias(alias).vendorId(vendorId).version(version).enabled(enabled);
        }

        public WeavePackageConfig build() {
            if (null == this.name) {
                throw new RuntimeException("WeavePackageConfig must have an Implementation-Name");
            }
            return new WeavePackageConfig(this.name, this.alias, this.vendorId, this.version, this.enabled, this.source, this.custom, this.instrumentation, this.errorHandleClassNode, this.preprocessor, this.postprocessor, this.extensionClassTemplate);
        }
    }
}

