/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelManager;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.SpanEventSender;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.concurrent.GuardedBy;

public class InfiniteTracing
implements Consumer<SpanEvent> {
    private final Logger logger;
    private final InfiniteTracingConfig config;
    private final MetricAggregator aggregator;
    private final ExecutorService executorService;
    private final BlockingQueue<SpanEvent> queue;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Future<?> spanEventSenderFuture;
    @GuardedBy(value="lock")
    private SpanEventSender spanEventSender;
    @GuardedBy(value="lock")
    private ChannelManager channelManager;

    @VisibleForTesting
    InfiniteTracing(InfiniteTracingConfig config, MetricAggregator aggregator, ExecutorService executorService, BlockingQueue<SpanEvent> queue) {
        this.logger = config.getLogger();
        this.config = config;
        this.aggregator = aggregator;
        this.executorService = executorService;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String agentRunToken, Map<String, String> requestMetadata) {
        Object object = this.lock;
        synchronized (object) {
            this.aggregator.incrementCounter("Supportability/InfiniteTracing/gRPC/Compression/" + (this.config.getUseCompression() ? "enabled" : "disabled"));
            this.aggregator.incrementCounter("Supportability/InfiniteTracing/gRPC/Batching/" + (this.config.getUseBatching() ? "enabled" : "disabled"));
            if (this.spanEventSenderFuture != null) {
                this.channelManager.updateMetadata(agentRunToken, requestMetadata);
                this.channelManager.shutdownChannelAndBackoff(0);
                return;
            }
            this.logger.log(Level.INFO, "Starting Infinite Tracing.");
            this.channelManager = this.buildChannelManager(agentRunToken, requestMetadata);
            this.spanEventSender = this.buildSpanEventSender();
            this.spanEventSenderFuture = this.executorService.submit(this.spanEventSender);
        }
    }

    @VisibleForTesting
    ChannelManager buildChannelManager(String agentRunToken, Map<String, String> requestMetadata) {
        return new ChannelManager(this.config, this.aggregator, agentRunToken, requestMetadata);
    }

    @VisibleForTesting
    SpanEventSender buildSpanEventSender() {
        return new SpanEventSender(this.config, this.queue, this.aggregator, this.channelManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.spanEventSenderFuture == null) {
                return;
            }
            this.logger.log(Level.INFO, "Stopping Infinite Tracing.");
            this.spanEventSenderFuture.cancel(true);
            this.channelManager.shutdownChannelForever();
            this.spanEventSenderFuture = null;
            this.spanEventSender = null;
            this.channelManager = null;
        }
    }

    @Override
    public void accept(SpanEvent spanEvent) {
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/Seen");
        if (!this.queue.offer(spanEvent)) {
            this.logger.log(Level.FINEST, "Span event not accepted. The queue was full.");
        }
    }

    public static InfiniteTracing initialize(InfiniteTracingConfig config, MetricAggregator aggregator) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Infinite Tracing"));
        return new InfiniteTracing(config, aggregator, executorService, new LinkedBlockingDeque<SpanEvent>(config.getMaxQueueSize()));
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private final String serviceName;
        private final AtomicInteger counter = new AtomicInteger(0);

        DaemonThreadFactory(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public Thread newThread(Runnable runnable2) {
            Thread thread2 = new Thread(runnable2);
            thread2.setName("New Relic " + this.serviceName + " #" + this.counter.incrementAndGet());
            thread2.setDaemon(true);
            return thread2;
        }
    }
}

