/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.ChannelManager;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.Observer;
import com.newrelic.SpanConverter;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.V1;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class SpanEventSender
implements Runnable {
    private final Logger logger;
    private final InfiniteTracingConfig config;
    private final BlockingQueue<SpanEvent> queue;
    private final MetricAggregator aggregator;
    private final ChannelManager channelManager;
    private static final String INFINITE_TRACING = "InfiniteTracing";
    private static final long LINGER_MS = 5000L;
    private static final int MAX_BATCH_SIZE = 100;

    SpanEventSender(InfiniteTracingConfig config, BlockingQueue<SpanEvent> queue, MetricAggregator aggregator, ChannelManager channelManager) {
        this.logger = config.getLogger();
        this.config = config;
        this.queue = queue;
        this.aggregator = aggregator;
        this.channelManager = channelManager;
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "Initializing {0}", (Object)this.getClass().getSimpleName());
        try {
            while (true) {
                this.pollAndWrite();
            }
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, t2, "A problem occurred and no further spans will be sent.");
            return;
        }
    }

    @VisibleForTesting
    void pollAndWrite() {
        Observer observer = this.channelManager.getObserver();
        if (!this.awaitReadyObserver(observer)) {
            return;
        }
        if (this.config.getUseBatching()) {
            this.drainAndSendBatchWhenReady(observer);
        } else {
            this.pollAndSendSpan(observer);
        }
    }

    @VisibleForTesting
    boolean awaitReadyObserver(Observer observer) {
        if (observer.isReady()) {
            return true;
        }
        try {
            this.logger.log(Level.FINE, "Waiting for gRPC span observer to be ready.");
            this.aggregator.incrementCounter("Supportability/InfiniteTracing/NotReady");
            Thread.sleep(250L);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while awaiting ready gRPC span observer.");
        }
        return false;
    }

    @VisibleForTesting
    void drainAndSendBatchWhenReady(Observer observer) {
        Collection<SpanEvent> spanEvents;
        if (this.queue.size() < 100) {
            try {
                if (this.queue.isEmpty()) {
                    Thread.sleep(250L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted while waiting for span batch to fill.");
            }
        }
        if ((spanEvents = this.drainSpanBatch()).isEmpty()) {
            return;
        }
        V1.SpanBatch convertedSpanBatch = SpanConverter.convert(spanEvents);
        this.writeToObserver(observer, convertedSpanBatch);
    }

    @VisibleForTesting
    Collection<SpanEvent> drainSpanBatch() {
        LinkedList<SpanEvent> spanEvents = new LinkedList<SpanEvent>();
        this.queue.drainTo(spanEvents, 100);
        return spanEvents;
    }

    @VisibleForTesting
    void pollAndSendSpan(Observer observer) {
        SpanEvent span = this.pollSafely();
        if (span == null) {
            return;
        }
        V1.Span convertedSpan = SpanConverter.convert(span);
        this.writeToObserver(observer, convertedSpan);
    }

    @VisibleForTesting
    SpanEvent pollSafely() {
        try {
            return this.queue.poll(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while polling for spans.");
        }
    }

    @VisibleForTesting
    void writeToObserver(Observer observer, V1.Span span) {
        try {
            observer.onNext(span);
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, t2, "Unable to send span.");
            throw t2;
        }
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/Sent");
    }

    @VisibleForTesting
    void writeToObserver(Observer observer, V1.SpanBatch spanBatch) {
        try {
            observer.onNext(spanBatch);
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, t2, "Unable to send span batch.");
            throw t2;
        }
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/Sent", spanBatch.getSpansCount());
    }
}

