/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ExpirationService;
import com.newrelic.agent.TimedSet;
import com.newrelic.agent.TokenImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.RemovalCause;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.RemovalListener;
import com.newrelic.agent.model.TimeoutCause;
import com.newrelic.agent.util.TimeConversion;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TimedTokenSet
implements TimedSet<TokenImpl> {
    private final AtomicInteger timedOutTokens = new AtomicInteger(0);
    private final Cache<TokenImpl, TokenImpl> activeTokens;

    public TimedTokenSet(int timeOut, TimeUnit unit, final ExpirationService expirationService) {
        long timeOutMilli = TimeConversion.convertToMilliWithLowerBound(timeOut, unit, 250L);
        this.activeTokens = Caffeine.newBuilder().initialCapacity(8).expireAfterAccess(timeOutMilli, TimeUnit.MILLISECONDS).executor(Runnable::run).removalListener(new RemovalListener<TokenImpl, TokenImpl>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoval(TokenImpl token, TokenImpl value, RemovalCause cause) {
                block9: {
                    block8: {
                        Transaction tx = token.getTransaction().getTransactionIfExists();
                        try {
                            if (cause == RemovalCause.EXPIRED) {
                                Agent.LOG.log(Level.FINEST, "Timing out token {0} on transaction {1}", token, tx);
                                TimedTokenSet.this.timedOutTokens.incrementAndGet();
                                token.setTruncated();
                                if (tx != null) {
                                    tx.setTimeoutCause(TimeoutCause.TOKEN);
                                }
                                break block8;
                            }
                            if (cause == RemovalCause.EXPLICIT) {
                                Agent.LOG.log(Level.FINEST, "Expiring token {0} on transaction {1}", token, tx);
                                break block8;
                            }
                            Agent.LOG.log(Level.FINEST, "Token {0} on transaction {1} removed due to cause {2}", token, tx, (Object)cause);
                        }
                        catch (Exception e) {
                            Agent.LOG.log(Level.FINEST, "Token {0} on transaction {1} threw exception: {2}", token, tx, e);
                            break block9;
                        }
                        finally {
                            expirationService.expireToken(token::markExpired);
                        }
                    }
                    expirationService.expireToken(token::markExpired);
                }
            }
        }).build();
    }

    @Override
    public int timedOutCount() {
        return this.timedOutTokens.get();
    }

    @Override
    public boolean remove(TokenImpl token) {
        return this.activeTokens.asMap().remove(token) != null;
    }

    @Override
    public void removeAll() {
        this.activeTokens.invalidateAll();
    }

    @Override
    public void put(TokenImpl token) {
        this.activeTokens.put(token, token);
    }

    @Override
    public void cleanUp() {
        this.activeTokens.cleanUp();
    }

    @Override
    public void refresh(TokenImpl token) {
        this.activeTokens.getIfPresent(token);
    }
}

