/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigImpl;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.config.internal.DeepMapClone;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AgentConfigFactory {
    public static final String AGENT_CONFIG = "agent_config";
    public static final String PERIOD_REGEX = "\\.";
    public static final String DOT_SEPARATOR = ".";
    public static final String SLOW_SQL_PREFIX = "slow_sql.";
    public static final String TRANSACTION_TRACER_PREFIX = "transaction_tracer.";
    public static final String TRANSACTION_TRACER_CATEGORY_BACKGROUND_PREFIX = "transaction_tracer.category.background.";
    public static final String TRANSACTION_TRACER_CATEGORY_REQUEST_PREFIX = "transaction_tracer.category.request.";
    public static final String ERROR_COLLECTOR_PREFIX = "error_collector.";
    public static final String THREAD_PROFILER_PREFIX = "thread_profiler.";
    public static final String TRANSACTION_EVENTS_PREFIX = "transaction_events.";
    public static final String CUSTOM_INSIGHT_EVENTS_PREFIX = "custom_insights_events.";
    public static final String SPAN_EVENTS_PREFIX = "span_events.";
    public static final String BROWSER_MONITORING_PREFIX = "browser_monitoring.";
    public static final String HIGH_SECURITY = "high_security";
    public static final String SECURITY_POLICIES_TOKEN = "security_policies_token";
    public static final String COLLECT_ERRORS = "error_collector.collect_errors";
    public static final String EXPECTED_CLASSES = "error_collector.expected_classes";
    public static final String EXPECTED_STATUS_CODES = "error_collector.expected_status_codes";
    public static final String COLLECT_ERROR_EVENTS = "error_collector.collect_error_events";
    public static final String CAPTURE_ERROR_EVENTS = "error_collector.capture_events";
    public static final String CUSTOM_INSIGHTS_ENABLED = "custom_insights_events.enabled";
    public static final String MAX_ERROR_EVENT_SAMPLES_STORED = "error_collector.max_event_samples_stored";
    public static final String COLLECT_TRACES = "transaction_tracer.collect_traces";
    public static final String COLLECT_TRANSACTION_EVENTS = "transaction_events.collect_analytics_events";
    public static final String COLLECT_SPAN_EVENTS = "span_events.collect_span_events";
    public static final String COLLECT_CUSTOM_INSIGHTS_EVENTS = "custom_insights_events.collect_custom_events";
    public static final String RECORD_SQL = "transaction_tracer.record_sql";
    @Deprecated
    public static final String SLOW_QUERY_WHITELIST = "transaction_tracer.slow_query_whitelist";
    public static final String COLLECT_SLOW_QUERIES_FROM = "transaction_tracer.collect_slow_queries_from";
    public static final String CROSS_APPLICATION_TRACER_PREFIX = "cross_application_tracer.";
    public static final String DISTRIBUTED_TRACING_PREFIX = "distributed_tracing.";
    public static final String ENCODING_KEY = "cross_application_tracer.encoding_key";
    public static final String CROSS_PROCESS_ID = "cross_application_tracer.cross_process_id";
    public static final String TRUSTED_ACCOUNT_IDS = "cross_application_tracer.trusted_account_ids";
    public static final String TRUSTED_ACCOUNT_KEY = "distributed_tracing.trusted_account_key";
    public static final String ACCOUNT_ID = "distributed_tracing.account_id";
    public static final String PRIMARY_APPLICATION_ID = "distributed_tracing.primary_application_id";
    public static final String DISTRIBUTED_TRACING_ENABLED = "distributed_tracing.enabled";
    public static final String STRIP_EXCEPTION = "strip_exception_messages";
    public static final String STRIP_EXCEPTION_ENABLED = "strip_exception_messages.enabled";
    @Deprecated
    public static final String STRIP_EXCEPTION_WHITELIST = "strip_exception_messages.whitelist";
    public static final String STRIP_EXCEPTION_ALLOWED_CLASSES = "strip_exception_messages.allowed_classes";
    public static final String EVENT_HARVEST_CONFIG = "event_harvest_config";

    @VisibleForTesting
    public static AgentConfig createAgentConfig(Map<String, Object> localSettings, Map<String, Object> serverData, Map<String, Boolean> laspData) {
        Map<String, Object> mergedSettings = DeepMapClone.deepCopy(localSettings);
        AgentConfigFactory.mergeServerData(mergedSettings, serverData, laspData);
        return AgentConfigImpl.createAgentConfig(mergedSettings);
    }

    public static Map<String, Object> getAgentData(Map<String, Object> serverData) {
        if (serverData == null) {
            return new HashMap<String, Object>();
        }
        return DeepMapClone.deepCopy((Map)serverData.get(AGENT_CONFIG));
    }

    public static void mergeServerData(Map<String, Object> settings, Map<String, Object> serverData, Map<String, Boolean> laspData) {
        Object logLimit;
        Object harvestLimits;
        if (serverData == null && laspData == null) {
            return;
        }
        if (serverData == null) {
            serverData = new HashMap<String, Object>();
        }
        if (laspData == null) {
            laspData = new HashMap<String, Boolean>();
        }
        AgentConfig settingsConfig = AgentConfigImpl.createAgentConfig(settings);
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        String recordSqlSecure = AgentConfigFactory.getMostSecureSql(agentData, settingsConfig, laspData);
        boolean attributesIncludeEnabled = AgentConfigFactory.getLaspValue(laspData, "attributes.include", true);
        List attributesInclude = attributesIncludeEnabled ? settingsConfig.getAttributesConfig().attributesRootInclude() : Collections.emptyList();
        String attributesIncludeSecure = Joiner.on(",").join(attributesInclude);
        Boolean captureMessageParameters = AgentConfigFactory.getLaspValue(laspData, "message_parameters", true);
        if (!captureMessageParameters.booleanValue()) {
            String[] attributes;
            ArrayList<String> filteredAttributes = new ArrayList<String>();
            for (String attribute : attributes = attributesIncludeSecure.split(",")) {
                if (attribute.startsWith("message.parameters.")) continue;
                filteredAttributes.add(attribute);
            }
            attributesIncludeSecure = Joiner.on(",").join(filteredAttributes);
        }
        Boolean stripExceptionMessagesSecure = settingsConfig.getStripExceptionConfig().isEnabled() || AgentConfigFactory.getLaspValue(laspData, STRIP_EXCEPTION_ENABLED, false) != false;
        Boolean serverSideCustomEvents = (Boolean)serverData.get("collect_custom_events");
        Boolean customEventsSecure = serverSideCustomEvents == null ? Boolean.valueOf(settingsConfig.getInsightsConfig().isEnabled() && AgentConfigFactory.getLaspValue(laspData, CUSTOM_INSIGHTS_ENABLED, true) != false) : Boolean.valueOf(settingsConfig.getInsightsConfig().isEnabled() && AgentConfigFactory.getLaspValue(laspData, CUSTOM_INSIGHTS_ENABLED, true) != false && serverSideCustomEvents != false);
        Boolean customParametersSecure = AgentConfigFactory.getLaspValue(laspData, "custom_parameters", true);
        Boolean customInstrumentationEditor = AgentConfigFactory.getLaspValue(laspData, "custom_instrumentation_editor", true);
        agentData.remove("cross_application_tracing");
        agentData.remove(HIGH_SECURITY);
        agentData.remove("reinstrument");
        agentData.remove("reinstrument.attributes_enabled");
        agentData.remove(STRIP_EXCEPTION);
        agentData.remove(STRIP_EXCEPTION_ENABLED);
        agentData.remove(STRIP_EXCEPTION_ALLOWED_CLASSES);
        agentData.remove(STRIP_EXCEPTION_WHITELIST);
        agentData.remove(SLOW_QUERY_WHITELIST);
        agentData.remove(COLLECT_SLOW_QUERIES_FROM);
        Object serverRecordSql = agentData.remove(RECORD_SQL);
        if (AgentConfigFactory.isHighSecurity(settingsConfig.getProperty(HIGH_SECURITY))) {
            if (AgentConfigFactory.isValidRecordSqlValue(serverRecordSql)) {
                AgentConfigFactory.addServerProp(RECORD_SQL, serverRecordSql, settings);
            }
        } else {
            AgentConfigFactory.addServerProp(RECORD_SQL, serverRecordSql, settings);
        }
        AgentConfigFactory.addServerProp("transaction_naming_scheme", serverData.get("transaction_naming_scheme"), settings);
        AgentConfigFactory.mergeAgentData(settings, agentData);
        AgentConfigFactory.addServerProp("apdex_t", serverData.get("apdex_t"), settings);
        AgentConfigFactory.addServerProp(COLLECT_ERRORS, serverData.get("collect_errors"), settings);
        AgentConfigFactory.addServerProp(COLLECT_ERROR_EVENTS, serverData.get("collect_error_events"), settings);
        AgentConfigFactory.addServerProp(CAPTURE_ERROR_EVENTS, serverData.get("capture_events"), settings);
        AgentConfigFactory.addServerProp(MAX_ERROR_EVENT_SAMPLES_STORED, serverData.get("max_event_samples_stored"), settings);
        AgentConfigFactory.addServerProp(COLLECT_TRACES, serverData.get("collect_traces"), settings);
        AgentConfigFactory.addServerProp(COLLECT_TRANSACTION_EVENTS, serverData.get("collect_analytics_events"), settings);
        AgentConfigFactory.addServerProp(COLLECT_CUSTOM_INSIGHTS_EVENTS, serverData.get("collect_custom_events"), settings);
        AgentConfigFactory.addServerProp(COLLECT_SPAN_EVENTS, serverData.get("collect_span_events"), settings);
        AgentConfigFactory.addServerProp("span_event_harvest_config", serverData.get("span_event_harvest_config"), settings);
        AgentConfigFactory.addServerProp("web_transactions_apdex", serverData.get("web_transactions_apdex"), settings);
        AgentConfigFactory.addServerProp(CROSS_PROCESS_ID, serverData.get("cross_process_id"), settings);
        AgentConfigFactory.addServerProp(ENCODING_KEY, serverData.get("encoding_key"), settings);
        AgentConfigFactory.addServerProp(TRUSTED_ACCOUNT_IDS, serverData.get("trusted_account_ids"), settings);
        AgentConfigFactory.addServerProp(TRUSTED_ACCOUNT_KEY, serverData.get("trusted_account_key"), settings);
        AgentConfigFactory.addServerProp(ACCOUNT_ID, serverData.get("account_id"), settings);
        AgentConfigFactory.addServerProp(PRIMARY_APPLICATION_ID, serverData.get("primary_application_id"), settings);
        AgentConfigFactory.addServerProp(EXPECTED_CLASSES, serverData.get("expected_classes"), settings);
        AgentConfigFactory.addServerProp(EXPECTED_STATUS_CODES, serverData.get("expected_status_codes"), settings);
        AgentConfigFactory.addServerProp("agent_run_id", serverData.get("agent_run_id"), settings);
        AgentConfigFactory.addServerProp("account_id", serverData.get("account_id"), settings);
        AgentConfigFactory.addServerProp("agent_home", ConfigFileHelper.getNewRelicDirectory().getAbsolutePath(), settings);
        if (AgentJarHelper.getAgentJarDirectory() != null) {
            AgentConfigFactory.addServerProp("agent_jar_location", AgentJarHelper.getAgentJarDirectory().getAbsolutePath(), settings);
        }
        if (settingsConfig.getProperty(SECURITY_POLICIES_TOKEN) != null) {
            AgentConfigFactory.addServerProp(RECORD_SQL, recordSqlSecure, settings);
            AgentConfigFactory.addServerProp("attributes.include", attributesIncludeSecure, settings);
            if (!attributesIncludeEnabled) {
                AgentConfigFactory.addServerProp("error_collector.attributes.include", Collections.emptyList(), settings);
                AgentConfigFactory.addServerProp("transaction_events.attributes.include", Collections.emptyList(), settings);
                AgentConfigFactory.addServerProp("transaction_tracer.attributes.include", Collections.emptyList(), settings);
                AgentConfigFactory.addServerProp("browser_monitoring.attributes.include", Collections.emptyList(), settings);
                AgentConfigFactory.addServerProp("span_events.attributes.include", Collections.emptyList(), settings);
                AgentConfigFactory.addServerProp("transaction_segments.attributes.include", Collections.emptyList(), settings);
            }
            AgentConfigFactory.addServerProp(STRIP_EXCEPTION_ENABLED, stripExceptionMessagesSecure, settings);
            AgentConfigFactory.addServerProp(CUSTOM_INSIGHTS_ENABLED, customEventsSecure, settings);
            AgentConfigFactory.addServerProp("custom_parameters", customParametersSecure, settings);
            AgentConfigFactory.addServerProp("custom_instrumentation_editor", customInstrumentationEditor, settings);
        }
        Object eventHarvestConfig = serverData.get(EVENT_HARVEST_CONFIG);
        AgentConfigFactory.addServerProp(EVENT_HARVEST_CONFIG, eventHarvestConfig, settings);
        if (eventHarvestConfig instanceof Map && (harvestLimits = ((Map)eventHarvestConfig).get("harvest_limits")) instanceof Map && (logLimit = ((Map)harvestLimits).get("log_event_data")) instanceof Number && ((Number)logLimit).intValue() == 0) {
            String loggingForwardingEnabled = "application_logging.forwarding.enabled";
            AgentConfigFactory.addServerProp(loggingForwardingEnabled, false, settings);
        }
        AgentConfigFactory.addServerProp("browser_key", serverData.get("browser_key"), settings);
        AgentConfigFactory.addServerProp("browser_monitoring.loader_version", serverData.get("browser_monitoring.loader_version"), settings);
        AgentConfigFactory.addServerProp("js_agent_loader", serverData.get("js_agent_loader"), settings);
        AgentConfigFactory.addServerProp("js_agent_file", serverData.get("js_agent_file"), settings);
        AgentConfigFactory.addServerProp("beacon", serverData.get("beacon"), settings);
        AgentConfigFactory.addServerProp("error_beacon", serverData.get("error_beacon"), settings);
        AgentConfigFactory.addServerProp("application_id", serverData.get("application_id"), settings);
        AgentConfigFactory.addServerProp("url_rules", serverData.get("url_rules"), settings);
        AgentConfigFactory.addServerProp("metric_name_rules", serverData.get("metric_name_rules"), settings);
        AgentConfigFactory.addServerProp("transaction_name_rules", serverData.get("transaction_name_rules"), settings);
        AgentConfigFactory.addServerProp("transaction_segment_terms", serverData.get("transaction_segment_terms"), settings);
        AgentConfigFactory.addServerProp("instrumentation", serverData.get("instrumentation"), settings);
    }

    private static String getMostSecureSql(Map<String, Object> agentData, AgentConfig settings, Map<String, Boolean> laspData) {
        String server = (String)agentData.get(RECORD_SQL);
        String local = settings.getTransactionTracerConfig().getRecordSql();
        Boolean lasp = AgentConfigFactory.getLaspValue(laspData, RECORD_SQL, null);
        if ("off".equals(server) || "off".equals(local) || lasp != null && !lasp.booleanValue()) {
            return "off";
        }
        if ("obfuscated".equals(server) || "obfuscated".equals(local) || lasp != null && lasp.booleanValue()) {
            return "obfuscated";
        }
        return "raw";
    }

    private static Boolean getLaspValue(Map<String, Boolean> policies, String key, Boolean defaultValue) {
        if (policies != null && policies.containsKey(key)) {
            return policies.get(key);
        }
        return defaultValue;
    }

    private static boolean isValidRecordSqlValue(Object recordSqlValue) {
        if (recordSqlValue == null || !(recordSqlValue instanceof String)) {
            return false;
        }
        String rSql = ((String)recordSqlValue).toLowerCase();
        return rSql.equals("off") || rSql.equals("obfuscated");
    }

    private static boolean isHighSecurity(Object value) {
        return value instanceof Boolean && (Boolean)value != false;
    }

    private static void mergeAgentData(Map<String, Object> settings, Map<String, Object> agentData) {
        for (Map.Entry<String, Object> entry : agentData.entrySet()) {
            AgentConfigFactory.addServerProp(entry.getKey(), entry.getValue(), settings);
        }
    }

    private static void addServerProp(String prop, Object val, Map<String, Object> settings) {
        if (val == null) {
            return;
        }
        AgentConfigFactory.addMappedProperty(prop, ServerProp.createPropObject(val), settings);
    }

    public static void addSimpleMappedProperty(String prop, Object val, Map<String, Object> settings) {
        AgentConfigFactory.addMappedProperty(prop, val, settings);
    }

    private static void addMappedProperty(String prop, Object val, Map<String, Object> settings) {
        String[] propArray;
        if (val == null) {
            return;
        }
        HashMap<String, Object> currentMap = settings;
        int count = 0;
        for (String propPart : propArray = prop.split(PERIOD_REGEX)) {
            if (++count < propArray.length) {
                HashMap<String, Object> propMap = null;
                Object propValue = currentMap.get(propPart);
                if (propValue instanceof Map) {
                    propMap = (HashMap<String, Object>)currentMap.get(propPart);
                } else if (propValue instanceof ServerProp) {
                    propMap = (Map)((ServerProp)propValue).getValue();
                }
                if (propMap == null) {
                    propMap = new HashMap<String, Object>();
                    currentMap.put(propPart, propMap);
                }
                currentMap = propMap;
                continue;
            }
            currentMap.put(propPart, val);
        }
    }
}

