/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ApplicationLoggingContextDataConfig;
import com.newrelic.agent.config.BaseConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ApplicationLoggingForwardingConfig
extends BaseConfig {
    public static final String ROOT = "forwarding";
    public static final String ENABLED = "enabled";
    public static final String MAX_SAMPLES_STORED = "max_samples_stored";
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_MAX_SAMPLES_STORED = 10000;
    private final boolean enabled;
    private final int maxSamplesStored = this.initMaxSamplesStored();
    private final ApplicationLoggingContextDataConfig contextDataConfig;

    public ApplicationLoggingForwardingConfig(Map<String, Object> props, String parentRoot, boolean highSecurity) {
        super(props, parentRoot + ROOT + ".");
        boolean storedMoreThan0 = this.maxSamplesStored > 0;
        this.enabled = storedMoreThan0 && !highSecurity && this.getProperty(ENABLED, true) != false;
        this.contextDataConfig = this.createContextDataConfig(highSecurity);
    }

    private int initMaxSamplesStored() {
        try {
            return this.getProperty(MAX_SAMPLES_STORED, 10000);
        }
        catch (ClassCastException classCastException) {
            Agent.LOG.log(Level.WARNING, "The max_samples_stored was likely too large {0}, we will use default {1}", this.getProperty(MAX_SAMPLES_STORED), 10000);
            return 10000;
        }
    }

    private ApplicationLoggingContextDataConfig createContextDataConfig(boolean highSecurity) {
        Map<String, Object> contextDataProps = this.getProperty("context_data", Collections.emptyMap());
        return new ApplicationLoggingContextDataConfig(contextDataProps, this.systemPropertyPrefix, highSecurity);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public boolean isContextDataEnabled() {
        return this.enabled && this.contextDataConfig.getEnabled();
    }

    public List<String> contextDataInclude() {
        return this.contextDataConfig.getInclude();
    }

    public List<String> contextDataExclude() {
        return this.contextDataConfig.getExclude();
    }
}

