/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.InsightsConfig;
import com.newrelic.api.agent.NewRelic;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class InsightsConfigImpl
extends BaseConfig
implements InsightsConfig {
    public static final String MAX_SAMPLES_STORED_PROP = "max_samples_stored";
    public static final int DEFAULT_MAX_SAMPLES_STORED = 30000;
    public static final String MAX_ATTRIBUTE_VALUE = "max_attribute_value";
    public static final int DEFAULT_MAX_ATTRIBUTE_VALUE = 255;
    public static final int MAX_MAX_ATTRIBUTE_VALUE = 4095;
    public static final String ENABLED_PROP = "enabled";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.custom_insights_events.";
    public static final String ENABLED = "newrelic.config.custom_insights_events.enabled";
    public static final String COLLECT_CUSTOM_EVENTS = "collect_custom_events";
    private final int maxSamplesStored = this.getProperty("max_samples_stored", 30000);
    private final boolean isEnabled;
    private final int maxAttributeValue;

    public InsightsConfigImpl(Map<String, Object> pProps, boolean highSecurity) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
        this.isEnabled = !highSecurity && this.initEnabled();
        this.maxAttributeValue = this.initMaxAttributeValue();
    }

    private boolean initEnabled() {
        boolean storedMoreThan0 = this.maxSamplesStored > 0;
        Boolean configEnabled = this.getProperty(ENABLED_PROP, true);
        Boolean featureGateEnabled = this.getProperty(COLLECT_CUSTOM_EVENTS, true);
        return storedMoreThan0 && configEnabled != false && featureGateEnabled != false;
    }

    private int initMaxAttributeValue() {
        int maxAttributeValue = this.getProperty(MAX_ATTRIBUTE_VALUE, 255);
        if (maxAttributeValue > 4095) {
            NewRelic.getAgent().getLogger().log(Level.WARNING, "The value for custom_insights_events.max_attribute_value was too large {0}, we will use maximum allowed {1}", (Object)maxAttributeValue, (Object)30000);
            maxAttributeValue = 4095;
        }
        return maxAttributeValue;
    }

    static InsightsConfigImpl createInsightsConfig(Map<String, Object> settings, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new InsightsConfigImpl(settings, highSecurity);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public int getMaxAttributeValue() {
        return this.maxAttributeValue;
    }
}

