/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import java.util.Set;

public class ErrorMessageReplacer {
    @VisibleForTesting
    static final String STRIPPED_EXCEPTION_REPLACEMENT = "Message removed by New Relic 'strip_exception_messages' setting";
    private final StripExceptionConfig config;
    @VisibleForTesting
    public static final ErrorMessageReplacer NO_REPLACEMENT = new ErrorMessageReplacer(new StripExceptionConfig(){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Set<String> getAllowedClasses() {
            return null;
        }
    });

    public ErrorMessageReplacer(StripExceptionConfig config) {
        this.config = config;
    }

    public String getMessage(Throwable throwableParam) {
        if (throwableParam == null) {
            return "";
        }
        if (this.useStrippedExceptionReplacement(throwableParam)) {
            return STRIPPED_EXCEPTION_REPLACEMENT;
        }
        String result = throwableParam.getMessage();
        if (result == null) {
            return "";
        }
        return result;
    }

    boolean useStrippedExceptionReplacement(Throwable throwable) {
        return this.config != null && this.config.isEnabled() && !this.config.getAllowedClasses().contains(throwable.getClass().getName());
    }
}

