/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.google.common.hash.HashCode;
import com.newrelic.agent.deps.com.google.common.hash.HashFunction;
import com.newrelic.agent.deps.com.google.common.hash.Hashing;
import com.newrelic.agent.util.StringMap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Murmur3StringMap
implements StringMap {
    private final HashFunction hashFunction = Hashing.murmur3_128(394852370);
    private final Charset charSet = StandardCharsets.UTF_8;
    private final Map<Object, String> stringMap = new ConcurrentHashMap<Object, String>();

    @Override
    public Map<Object, String> getStringMap() {
        return this.stringMap;
    }

    @Override
    public Object addString(String string) {
        String key;
        if (null == string) {
            return null;
        }
        if (string.length() < 12) {
            key = string;
        } else {
            HashCode hash = this.hashFunction.newHasher().putString(string, this.charSet).hash();
            byte[] eightBytes = new byte[8];
            hash.writeBytesTo(eightBytes, 0, 8);
            key = new String(Base64.getEncoder().encode(eightBytes), StandardCharsets.US_ASCII);
        }
        this.stringMap.put(key, string);
        return key;
    }
}

